/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.model.entity.ModelTransferGadget;
import me.desht.pneumaticcraft.client.render.entity.RenderSemiblockBase;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityTransferGadget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderTransferGadget
extends RenderSemiblockBase<EntityTransferGadget> {
    public static final IRenderFactory<EntityTransferGadget> FACTORY = RenderTransferGadget::new;
    private final ModelTransferGadget model = new ModelTransferGadget();

    private RenderTransferGadget(EntityRendererManager rendererManager) {
        super(rendererManager);
    }

    public void render(EntityTransferGadget entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        Direction side;
        if (entity.isAir()) {
            return;
        }
        matrixStackIn.func_227860_a_();
        if (entity.getTimeSinceHit() > 0) {
            this.wobble(entity, partialTicks, matrixStackIn);
        }
        matrixStackIn.func_227861_a_(0.0, (side = entity.getSide()).func_176740_k() == Direction.Axis.Y ? 1.5 : -1.5, 0.0);
        switch (side) {
            case UP: {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                matrixStackIn.func_227861_a_(-1.5, -1.5, 0.0);
                break;
            }
            case DOWN: {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
                matrixStackIn.func_227861_a_(1.5, -1.5, 0.0);
                break;
            }
            case NORTH: {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                break;
            }
            case WEST: {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            }
        }
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)this.getEntityTexture(entity)));
        this.model.func_225598_a_(matrixStackIn, builder, this.kludgeLightingLevel(entity, packedLightIn), OverlayTexture.func_229200_a_((float)0.0f, (boolean)false), 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    public Vector3d getRenderOffset(EntityTransferGadget entityIn, float partialTicks) {
        VoxelShape shape = entityIn.getBlockState().func_196954_c((IBlockReader)entityIn.getWorld(), entityIn.getBlockPos());
        double yOff = (shape.func_197758_c(Direction.Axis.Y) - shape.func_197762_b(Direction.Axis.Y)) / 2.0;
        switch (entityIn.getSide()) {
            case DOWN: {
                return new Vector3d(0.0, shape.func_197762_b(Direction.Axis.Y), 0.0);
            }
            case UP: {
                return new Vector3d(0.0, shape.func_197758_c(Direction.Axis.Y), 0.0);
            }
            case NORTH: {
                return new Vector3d(0.0, yOff, shape.func_197762_b(Direction.Axis.Z) - 0.5);
            }
            case SOUTH: {
                return new Vector3d(0.0, yOff, shape.func_197758_c(Direction.Axis.Z) - 0.5);
            }
            case WEST: {
                return new Vector3d(shape.func_197762_b(Direction.Axis.X) - 0.5, yOff, 0.0);
            }
            case EAST: {
                return new Vector3d(shape.func_197758_c(Direction.Axis.X) - 0.5, yOff, 0.0);
            }
        }
        return Vector3d.field_186680_a;
    }

    public ResourceLocation getEntityTexture(EntityTransferGadget entityTransferGadget) {
        return entityTransferGadget.getIOMode().getTexture();
    }
}

