/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.IKeyListener;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiArmorColors;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.LauncherTracker;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.DroneDebugClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.HackClientHandler;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPneumaticKick;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeatureBulk;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum HUDHandler implements IKeyListener
{
    INSTANCE;

    private static final int PROGRESS_BAR_HEIGHT = 17;
    private int lastScaledWidth = -1;
    private int lastScaledHeight = -1;
    private long lastArmorInitSound;
    private boolean sentForceInitPacket = false;
    private final List<ArmorMessage> pendingMessages = new ArrayList<ArmorMessage>();
    private final boolean[] gaveCriticalWarning = new boolean[4];
    private final boolean[] gaveLowPressureWarning = new boolean[4];

    public static HUDHandler getInstance() {
        return INSTANCE;
    }

    public <T extends IArmorUpgradeClientHandler> T getSpecificRenderer(Class<T> clazz) {
        return ArmorUpgradeClientRegistry.getInstance().byClass(clazz);
    }

    @SubscribeEvent
    public void renderHUD3d(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null || mc.field_71474_y.field_74319_N || mc.field_71462_r != null || !ItemPneumaticArmor.isPneumaticArmorPiece((PlayerEntity)player, EquipmentSlotType.HEAD) || WidgetKeybindCheckBox.getCoreComponents() == null || !WidgetKeybindCheckBox.getCoreComponents().checked) {
            return;
        }
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player);
        if (commonArmorHandler.getArmorPressure(EquipmentSlotType.HEAD) > 0.0f) {
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            Vector3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
            matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
            for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                if (!commonArmorHandler.isArmorReady(slot)) continue;
                GlStateManager.func_227621_I_();
                List<IArmorUpgradeClientHandler> clientHandlers = ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot);
                for (int i = 0; i < clientHandlers.size(); ++i) {
                    if (!commonArmorHandler.isUpgradeInserted(slot, i) || !WidgetKeybindCheckBox.forUpgrade((IArmorUpgradeClientHandler)clientHandlers.get((int)i)).checked) continue;
                    clientHandlers.get(i).render3D(matrixStack, (IRenderTypeBuffer)buffer, event.getPartialTicks());
                }
                GlStateManager.func_227619_H_();
            }
            matrixStack.func_227865_b_();
        }
    }

    @SubscribeEvent
    public void renderHUD2d(RenderGameOverlayEvent.Post event) {
        ItemStack armorStack;
        if (event.getType() != RenderGameOverlayEvent.ElementType.HELMET) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null || mc.field_71474_y.field_74319_N || mc.field_71462_r != null || !ItemPneumaticArmor.isPlayerWearingAnyPneumaticArmor((PlayerEntity)player)) {
            return;
        }
        float partialTicks = event.getPartialTicks();
        MatrixStack matrixStack = event.getMatrixStack();
        MainWindow mw = event.getWindow();
        matrixStack.func_227860_a_();
        RenderSystem.color4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.8f);
        CommonArmorHandler comHudHandler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player);
        boolean anyArmorInInit = false;
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            armorStack = player.func_184582_a(slot);
            if (!(armorStack.func_77973_b() instanceof ItemPneumaticArmor) || !(comHudHandler.getArmorPressure(slot) >= 1.0E-4f) || comHudHandler.isArmorReady(slot)) continue;
            anyArmorInInit = true;
            break;
        }
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            armorStack = player.func_184582_a(slot);
            if (!(armorStack.func_77973_b() instanceof ItemPneumaticArmor) || comHudHandler.getArmorPressure(slot) < 1.0E-4f) continue;
            if (anyArmorInInit && comHudHandler.isArmorEnabled()) {
                int xLeft = mw.func_198107_o() / 2;
                int yOffset = 10 + (3 - slot.func_188454_b()) * 17;
                float progress = (float)comHudHandler.getTicksSinceEquipped(slot) * 100.0f / (float)comHudHandler.getStartupTime(slot);
                progress = Math.min(100.0f, progress + event.getPartialTicks());
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                RenderProgressBar.render2d(matrixStack, (float)mw.func_198107_o() / 2.0f, yOffset, mw.func_198107_o() - 10, yOffset + 17 - 1, -90.0f, progress, -1426079744, -1442775296);
                RenderSystem.disableBlend();
                RenderSystem.enableTexture();
                GuiUtils.renderItemStack(matrixStack, armorStack, xLeft + 2, yOffset);
            }
            if (!comHudHandler.isArmorReady(slot)) continue;
            float pressure = comHudHandler.getArmorPressure(slot);
            this.handlePressureWarnings((PlayerEntity)player, slot, pressure);
            if (!WidgetKeybindCheckBox.getCoreComponents().checked && Minecraft.func_71410_x().field_71462_r != null) continue;
            List<IArmorUpgradeClientHandler> renderHandlers = ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot);
            for (int i = 0; i < renderHandlers.size(); ++i) {
                IArmorUpgradeClientHandler clientHandler = renderHandlers.get(i);
                if (!comHudHandler.isUpgradeInserted(slot, i) || !comHudHandler.isUpgradeEnabled(slot, i)) continue;
                IGuiAnimatedStat stat = clientHandler.getAnimatedStat();
                if (stat != null) {
                    stat.renderStat(matrixStack, -1, -1, partialTicks);
                }
                clientHandler.render2D(matrixStack, partialTicks, pressure > 0.0f);
            }
        }
        if (LauncherTracker.INSTANCE.getLauncherProgress() > 0) {
            LauncherTracker.INSTANCE.render(matrixStack, mw, partialTicks);
        }
        this.pendingMessages.forEach(message -> message.renderMessage(matrixStack, partialTicks));
        matrixStack.func_227865_b_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (comHudHandler.isArmorEnabled() && anyArmorInInit) {
            for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                if (!ItemPneumaticArmor.isPneumaticArmorPiece((PlayerEntity)player, slot) || !(comHudHandler.getArmorPressure(slot) > 0.0f)) continue;
                String text = Math.min(100, comHudHandler.getTicksSinceEquipped(slot) * 100 / comHudHandler.getStartupTime(slot)) + "%";
                mc.field_71466_p.func_238405_a_(matrixStack, text, (float)mw.func_198107_o() * 0.75f - 8.0f, (float)(14 + 17 * (3 - slot.func_188454_b())), 0xFFFF40);
            }
        }
        RenderSystem.enableBlend();
    }

    private void handlePressureWarnings(PlayerEntity player, EquipmentSlotType slot, float pressure) {
        if (pressure <= 0.1f && !this.gaveCriticalWarning[slot.func_188454_b()]) {
            this.addMessage(new ArmorMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.outOfAir", player.func_184582_a(slot).func_200301_q()), 100, 0x70FF0000));
            this.gaveCriticalWarning[slot.func_188454_b()] = true;
            player.func_184185_a((SoundEvent)ModSounds.MINIGUN_STOP.get(), 1.0f, 2.0f);
        } else if (pressure > 0.1f && pressure <= 0.5f && !this.gaveLowPressureWarning[slot.func_188454_b()]) {
            this.addMessage(new ArmorMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.almostOutOfAir", player.func_184582_a(slot).func_200301_q()), 60, 1895792640));
            this.gaveLowPressureWarning[slot.func_188454_b()] = true;
        }
        if (pressure > 0.6f) {
            this.gaveLowPressureWarning[slot.func_188454_b()] = false;
        }
        if (pressure > 0.2f) {
            this.gaveCriticalWarning[slot.func_188454_b()] = false;
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            PlayerEntity player = event.player;
            if (player == mc.field_71439_g && player.field_70170_p.field_72995_K) {
                boolean anyArmorEquipped = false;
                CommonArmorHandler comHudHandler = CommonArmorHandler.getHandlerForPlayer();
                for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                    if (!ItemPneumaticArmor.isPneumaticArmorPiece(player, slot)) continue;
                    this.updateArmorPiece((PlayerEntity)mc.field_71439_g, slot, comHudHandler);
                    anyArmorEquipped = true;
                }
                if (anyArmorEquipped) {
                    this.ensureArmorInit(player, comHudHandler);
                    this.updateLauncherTracker();
                    this.pendingMessages.forEach(message -> message.getStat().tickWidget());
                    this.pendingMessages.removeIf(message -> message == null || --message.lifeSpan <= 0);
                } else {
                    this.pendingMessages.clear();
                    this.sentForceInitPacket = false;
                }
            }
        }
    }

    private void ensureArmorInit(PlayerEntity player, CommonArmorHandler comHudHandler) {
        if (!ItemPneumaticArmor.isPneumaticArmorPiece(player, EquipmentSlotType.HEAD) && !this.sentForceInitPacket) {
            boolean state = WidgetKeybindCheckBox.getCoreComponents().checked;
            if (state) {
                comHudHandler.setUpgradeEnabled(EquipmentSlotType.HEAD, (byte)0, true);
                NetworkHandler.sendToServer(new PacketToggleArmorFeature(EquipmentSlotType.HEAD, 0, true));
            }
            this.sentForceInitPacket = true;
        }
    }

    private void updateLauncherTracker() {
        if (LauncherTracker.INSTANCE.getLauncherProgress() > 0) {
            if (!KeyHandler.getInstance().keybindLauncher.func_151470_d()) {
                LauncherTracker.INSTANCE.trigger();
            } else {
                LauncherTracker.INSTANCE.chargeLauncher();
            }
        }
    }

    private void updateArmorPiece(PlayerEntity player, EquipmentSlotType slot, CommonArmorHandler commonArmorHandler) {
        boolean armorEnabled = WidgetKeybindCheckBox.getCoreComponents().checked;
        List<IArmorUpgradeHandler> upgradeHandlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
        ItemStack armorStack = player.func_184582_a(slot);
        int ticksSinceEquipped = commonArmorHandler.getTicksSinceEquipped(slot);
        int startupTime = commonArmorHandler.getStartupTime(slot);
        ITextComponent itemName = armorStack.func_200301_q();
        if (ticksSinceEquipped > startupTime && armorEnabled) {
            for (int i = 0; i < upgradeHandlers.size(); ++i) {
                IArmorUpgradeHandler upgradeHandler = upgradeHandlers.get(i);
                if (!commonArmorHandler.isUpgradeInserted(slot, i) || !commonArmorHandler.isUpgradeEnabled(slot, i)) continue;
                IArmorUpgradeClientHandler clientHandler = ArmorUpgradeClientRegistry.getInstance().getClientHandler(upgradeHandler);
                IGuiAnimatedStat stat = clientHandler.getAnimatedStat();
                if (stat != null) {
                    if (commonArmorHandler.getArmorPressure(slot) > upgradeHandler.getMinimumPressure()) {
                        stat.openStat();
                    } else {
                        stat.closeStat();
                    }
                    stat.tickWidget();
                }
                clientHandler.tickClient(commonArmorHandler);
            }
        } else if (ticksSinceEquipped == startupTime) {
            this.playArmorInitSound(player, (SoundEvent)ModSounds.HUD_INIT_COMPLETE.get(), 1.0f);
            this.addMessage(new ArmorMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.initComplete", itemName), 50, 0x7000AA00));
        } else if (ticksSinceEquipped == 0 && WidgetKeybindCheckBox.getCoreComponents().checked) {
            for (IArmorUpgradeClientHandler handler : ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot)) {
                handler.reset();
            }
            ArrayList<PacketToggleArmorFeatureBulk.FeatureSetting> features = new ArrayList<PacketToggleArmorFeatureBulk.FeatureSetting>();
            for (byte idx = 0; idx < upgradeHandlers.size(); idx = (byte)(idx + 1)) {
                boolean state = armorEnabled && WidgetKeybindCheckBox.forUpgrade((IArmorUpgradeHandler)upgradeHandlers.get((int)idx)).checked;
                commonArmorHandler.setUpgradeEnabled(slot, idx, state);
                features.add(new PacketToggleArmorFeatureBulk.FeatureSetting(slot, idx, state));
            }
            NetworkHandler.sendToServer(new PacketToggleArmorFeatureBulk(features));
        } else if (ticksSinceEquipped == 1) {
            this.playArmorInitSound(player, (SoundEvent)ModSounds.HUD_INIT.get(), 0.5f);
            this.addMessage(new ArmorMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.initStarted", itemName), 50, 0x7000AA00));
        } else {
            for (int i = 0; i < upgradeHandlers.size(); ++i) {
                if (ticksSinceEquipped != startupTime / (upgradeHandlers.size() + 2) * (i + 1)) continue;
                this.playArmorInitSound(player, (SoundEvent)ModSounds.HUD_INIT.get(), 0.5f + (float)(i + 1) / (float)(upgradeHandlers.size() + 2) * 0.5f);
                boolean upgradeEnabled = commonArmorHandler.isUpgradeInserted(slot, i);
                IFormattableTextComponent message = PneumaticCraftUtils.xlate(upgradeHandlers.get(i).getTranslationKey(), new Object[0]).func_240702_b_(upgradeEnabled ? " installed" : " not installed");
                this.addMessage(new ArmorMessage((ITextComponent)message, 80, upgradeEnabled ? 0x7000AA00 : 1895792640));
            }
        }
    }

    private void playArmorInitSound(PlayerEntity player, SoundEvent sound, float pitch) {
        long when = player.field_70170_p.func_82737_E();
        if (when - this.lastArmorInitSound >= 30L) {
            player.field_70170_p.func_184134_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), sound, SoundCategory.PLAYERS, 0.2f, pitch, true);
        }
        this.lastArmorInitSound = when;
    }

    public void addFeatureToggleMessage(String key, boolean enabled) {
        this.addMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message." + (enabled ? "enable" : "disable") + "Setting", PneumaticCraftUtils.xlate(key, new Object[0])), Collections.emptyList(), 60, 0x7000AA00);
    }

    public void addFeatureToggleMessage(String key, String subKey, boolean enabled) {
        IFormattableTextComponent msg = PneumaticCraftUtils.xlate(key, new Object[0]).func_240702_b_(": ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate(subKey, new Object[0]));
        this.addMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message." + (enabled ? "enable" : "disable") + "Setting", msg), Collections.emptyList(), 60, 0x7000AA00);
    }

    public void addMessage(ITextComponent title, List<ITextComponent> message, int duration, int backColor) {
        this.addMessage(new ArmorMessage(title, message, duration, backColor));
    }

    public void addMessage(ArmorMessage message) {
        if (this.pendingMessages.size() > 0) {
            message.setDependingMessage(this.pendingMessages.get(this.pendingMessages.size() - 1).getStat());
        }
        this.pendingMessages.add(message);
    }

    @Override
    public void handleInput(KeyBinding key) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_195544_aj()) {
            if (key == KeyHandler.getInstance().keybindOpenOptions) {
                if (ItemPneumaticArmor.isPlayerWearingAnyPneumaticArmor((PlayerEntity)mc.field_71439_g)) {
                    mc.func_147108_a((Screen)GuiArmorMainScreen.getInstance());
                }
            } else if (key == KeyHandler.getInstance().keybindHack && HackClientHandler.enabledForPlayer((PlayerEntity)mc.field_71439_g)) {
                this.getSpecificRenderer(BlockTrackerClientHandler.class).hack();
                this.getSpecificRenderer(EntityTrackerClientHandler.class).hack();
            } else if (key == KeyHandler.getInstance().keybindDebuggingDrone && DroneDebugClientHandler.enabledForPlayer((PlayerEntity)mc.field_71439_g)) {
                this.getSpecificRenderer(EntityTrackerClientHandler.class).selectAsDebuggingTarget();
            } else if (key == KeyHandler.getInstance().keybindKick && CommonArmorHandler.getHandlerForPlayer().getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.DISPENSER) > 0) {
                NetworkHandler.sendToServer(new PacketPneumaticKick());
            } else if (key == KeyHandler.getInstance().keybindLauncher && !mc.field_71439_g.func_184592_cb().func_190926_b() && LauncherTracker.INSTANCE.isPlayerOKToLaunch()) {
                LauncherTracker.INSTANCE.startCharging();
            }
        }
    }

    @SubscribeEvent
    public void onMouseScroll(InputEvent.MouseScrollEvent event) {
        boolean isCaptured = this.getSpecificRenderer(BlockTrackerClientHandler.class).scroll(event);
        if (!isCaptured) {
            isCaptured = this.getSpecificRenderer(EntityTrackerClientHandler.class).scroll(event);
        }
        if (isCaptured) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleResolutionChange(GuiScreenEvent.InitGuiEvent event) {
        MainWindow mw;
        Screen gui = event.getGui();
        if (gui.getMinecraft().field_71441_e != null && ((mw = gui.getMinecraft().func_228018_at_()).func_198107_o() != this.lastScaledWidth || mw.func_198087_p() != this.lastScaledHeight)) {
            for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                for (IArmorUpgradeClientHandler handler : ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot)) {
                    handler.onResolutionChanged();
                }
            }
            this.lastScaledWidth = mw.func_198107_o();
            this.lastScaledHeight = mw.func_198087_p();
        }
    }

    public int getStatOverlayColor() {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184582_a(EquipmentSlotType.HEAD);
        int eyepieceColor = stack.func_77973_b() instanceof ItemPneumaticArmor ? ((ItemPneumaticArmor)stack.func_77973_b()).getEyepieceColor(stack) : GuiArmorColors.SelectorType.EYEPIECE.getDefaultColor();
        return eyepieceColor & 0xFFFFFF | 0x30000000;
    }

    public void updateOverlayColors(EquipmentSlotType slot) {
        int color = this.getStatOverlayColor();
        ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot).forEach(clientHandler -> clientHandler.setOverlayColor(color));
    }
}

