/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketChestplateLauncher;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3f;

public enum LauncherTracker {
    INSTANCE;

    public static final int MAX_PROGRESS = 15;
    private int launcherProgress = 0;

    public int getLauncherProgress() {
        return this.launcherProgress;
    }

    public boolean isPlayerOKToLaunch() {
        if (this.launcherProgress > 0) {
            return false;
        }
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer();
        return handler.isArmorReady(EquipmentSlotType.CHEST) && handler.getUpgradeCount(EquipmentSlotType.CHEST, EnumUpgrade.DISPENSER) > 0 && handler.getArmorPressure(EquipmentSlotType.CHEST) > 0.1f;
    }

    public void startCharging() {
        if (KeyHandler.getInstance().keybindLauncher.func_151470_d()) {
            ++this.launcherProgress;
        }
    }

    public void chargeLauncher() {
        if (this.launcherProgress > 0 && this.launcherProgress < 15) {
            ++this.launcherProgress;
        }
    }

    public void trigger() {
        NetworkHandler.sendToServer(new PacketChestplateLauncher((float)this.launcherProgress / 15.0f));
        this.launcherProgress = 0;
    }

    public void render(MatrixStack matrixStack, MainWindow sr, float partialTicks) {
        matrixStack.func_227860_a_();
        RenderSystem.disableTexture();
        if (Minecraft.func_71410_x().field_71439_g.func_184591_cq() == HandSide.LEFT) {
            matrixStack.func_227861_a_((double)(sr.func_198107_o() - 30), (double)(sr.func_198087_p() - 30), -90.0);
            matrixStack.func_227862_a_(-1.0f, 1.0f, 1.0f);
        } else {
            matrixStack.func_227861_a_(30.0, (double)(sr.func_198087_p() - 30), -90.0);
        }
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-60.0f));
        float progress = Math.min(100.0f, ((float)this.launcherProgress + partialTicks) * 100.0f / 15.0f);
        RenderProgressBar.render2d(matrixStack, 0.0f, 0.0f, (float)sr.func_198107_o() / 6.0f - 30.0f, 12.0f, 0.0f, progress, -1442840416, -1438605057);
        RenderSystem.enableTexture();
        matrixStack.func_227865_b_();
    }
}

