/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.api.hacking.IHacking;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class PneumaticHelmetRegistry
implements IPneumaticHelmetRegistry {
    private static final PneumaticHelmetRegistry INSTANCE = new PneumaticHelmetRegistry();
    public final List<Supplier<? extends IEntityTrackEntry>> entityTrackEntries = new ArrayList<Supplier<? extends IEntityTrackEntry>>();
    public final Map<Class<? extends Entity>, Supplier<? extends IHackableEntity>> hackableEntities = new HashMap<Class<? extends Entity>, Supplier<? extends IHackableEntity>>();
    public final Map<ResourceLocation, Supplier<? extends IHackableEntity>> idToEntityHackables = new HashMap<ResourceLocation, Supplier<? extends IHackableEntity>>();
    private final Map<Block, Supplier<? extends IHackableBlock>> hackableBlocks = new HashMap<Block, Supplier<? extends IHackableBlock>>();
    private final Map<Block, Supplier<? extends IHackableBlock>> hackableTaggedBlocks = new HashMap<Block, Supplier<? extends IHackableBlock>>();
    private final Map<ResourceLocation, Supplier<? extends IHackableBlock>> pendingBlockTags = new HashMap<ResourceLocation, Supplier<? extends IHackableBlock>>();
    private final Map<ResourceLocation, Supplier<? extends IHackableBlock>> idToBlockHackables = new HashMap<ResourceLocation, Supplier<? extends IHackableBlock>>();

    public static PneumaticHelmetRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerEntityTrackEntry(Supplier<? extends IEntityTrackEntry> entry) {
        Validate.notNull(entry);
        this.entityTrackEntries.add(entry);
    }

    @Override
    public void addHackable(Class<? extends Entity> entityClazz, Supplier<? extends IHackableEntity> iHackable) {
        Validate.isTrue((!(iHackable instanceof Entity) ? 1 : 0) != 0, (String)"Entities that already implement IHackableEntity do not need to be registered as hackable!", (Object[])new Object[0]);
        IHackableEntity hackableEntity = iHackable.get();
        if (hackableEntity.getHackableId() != null) {
            this.idToEntityHackables.put(hackableEntity.getHackableId(), iHackable);
        }
        this.hackableEntities.put(entityClazz, iHackable);
    }

    @Override
    public void addHackable(Block block, Supplier<? extends IHackableBlock> iHackable) {
        Validate.isTrue((!(iHackable instanceof Block) ? 1 : 0) != 0, (String)"Blocks that already implement IHackableBlock do not need to be registered as hackable!", (Object[])new Object[0]);
        IHackableBlock hackableBlock = iHackable.get();
        if (hackableBlock.getHackableId() != null) {
            this.idToBlockHackables.put(hackableBlock.getHackableId(), iHackable);
        }
        this.hackableBlocks.put(block, iHackable);
    }

    @Override
    public void addHackable(ITag.INamedTag<Block> blockTag, Supplier<? extends IHackableBlock> iHackable) {
        Validate.isTrue((!(iHackable instanceof Block) ? 1 : 0) != 0, (String)"Blocks that already implement IHackableBlock do not need to be registered as hackable!", (Object[])new Object[0]);
        this.pendingBlockTags.put(blockTag.func_230234_a_(), iHackable);
    }

    public void resolveBlockTags(ITagCollection<Block> tags) {
        this.hackableTaggedBlocks.clear();
        this.pendingBlockTags.forEach((id, hackable) -> tags.func_199910_a(id).func_230236_b_().forEach(arg_0 -> this.lambda$null$0((Supplier)hackable, arg_0)));
    }

    @Override
    public List<IHackableEntity> getCurrentEntityHacks(Entity entity) {
        return entity.getCapability(PNCCapabilities.HACKING_CAPABILITY).map(IHacking::getCurrentHacks).orElse(Collections.emptyList());
    }

    @Override
    public void registerBlockTrackEntry(IBlockTrackEntry entry) {
        BlockTrackEntryList.INSTANCE.trackList.add((Object)entry);
    }

    @Override
    public void registerRenderHandler(IArmorUpgradeHandler handler, IArmorUpgradeClientHandler clientHandler) {
        Validate.notNull((Object)clientHandler, (String)"Render handler can't be null!", (Object[])new Object[0]);
        ArmorUpgradeClientRegistry.getInstance().registerHandler(handler, clientHandler);
    }

    public IHackableBlock getHackable(Block block) {
        Supplier<? extends IHackableBlock> sup = this.hackableBlocks.get(block);
        if (sup != null) {
            return sup.get();
        }
        sup = this.hackableTaggedBlocks.get(block);
        return sup == null ? null : sup.get();
    }

    public IHackableEntity getHackable(Entity entity, PlayerEntity player) {
        for (Map.Entry<Class<? extends Entity>, Supplier<? extends IHackableEntity>> entry : this.hackableEntities.entrySet()) {
            IHackableEntity hackable;
            if (!entry.getKey().isAssignableFrom(entity.getClass()) || !(hackable = entry.getValue().get()).canHack(entity, player)) continue;
            return hackable;
        }
        return null;
    }

    public IHackableEntity getEntityById(ResourceLocation id) {
        Supplier<? extends IHackableEntity> sup = this.idToEntityHackables.get(id);
        return sup == null ? null : sup.get();
    }

    private /* synthetic */ void lambda$null$0(Supplier hackable, Block block) {
        this.hackableTaggedBlocks.put(block, hackable);
    }
}

