/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.InventoryTrackEvent;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.TrackerBlacklistManager;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlockTrackEntryInventory
implements IBlockTrackEntry {
    private static final ResourceLocation ID = PneumaticCraftUtils.RL("block_tracker.module.inventories");

    @Override
    public boolean shouldTrackWithThisEntry(IBlockReader world, BlockPos pos, BlockState state, TileEntity te) {
        if (te instanceof ChestTileEntity && state.func_235901_b_((Property)ChestBlock.field_196314_b) && state.func_177229_b((Property)ChestBlock.field_196314_b) == ChestType.RIGHT) {
            return false;
        }
        return te != null && !TrackerBlacklistManager.isInventoryBlacklisted(te) && IBlockTrackEntry.hasCapabilityOnAnyFace((ICapabilityProvider)te, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) && !MinecraftForge.EVENT_BUS.post((Event)new InventoryTrackEvent(te));
    }

    @Override
    public List<BlockPos> getServerUpdatePositions(TileEntity te) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        if (te instanceof ChestTileEntity && te.func_195044_w().func_177229_b((Property)ChestBlock.field_196314_b) == ChestType.LEFT) {
            Direction dir = ChestBlock.func_196311_i((BlockState)te.func_195044_w());
            res.add(te.func_174877_v().func_177972_a(dir));
            NetworkHandler.sendToServer(new PacketDescriptionPacketRequest(te.func_174877_v().func_177972_a(dir)));
        }
        res.add(te.func_174877_v());
        return res;
    }

    @Override
    public int spamThreshold() {
        return 16;
    }

    @Override
    public void addInformation(World world, BlockPos pos, TileEntity te, Direction face, List<ITextComponent> infoList) {
        try {
            IOHelper.getInventoryForTE(te, face).ifPresent(inventory -> {
                boolean empty = true;
                ItemStack[] inventoryStacks = new ItemStack[inventory.getSlots()];
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack iStack = inventory.getStackInSlot(i);
                    if (!iStack.func_190926_b()) {
                        empty = false;
                    }
                    inventoryStacks[i] = iStack;
                }
                if (empty) {
                    infoList.add((ITextComponent)new StringTextComponent("Contents: Empty"));
                } else {
                    infoList.add((ITextComponent)new StringTextComponent("Contents:"));
                    ArrayList<ITextComponent> l = new ArrayList<ITextComponent>();
                    PneumaticCraftUtils.summariseItemStacks(l, inventoryStacks);
                    infoList.addAll(l);
                }
            });
        }
        catch (Throwable e) {
            TrackerBlacklistManager.addInventoryTEToBlacklist(te, e);
        }
    }

    @Override
    public ResourceLocation getEntryID() {
        return ID;
    }
}

