/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.google.common.base.Strings;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.AirConditionerOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class AirConClientHandler
extends IArmorUpgradeClientHandler.SimpleToggleableHandler {
    private static final int MAX_AC = 20;
    public static int deltaTemp;
    private static int currentAC;
    private IGuiAnimatedStat acStat;

    public AirConClientHandler() {
        super(ArmorUpgradeRegistry.getInstance().airConHandler);
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new AirConditionerOptions(screen, this);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
        super.tickClient(armorHandler);
        if ((armorHandler.getPlayer().field_70170_p.func_82737_E() & 3L) == 0L) {
            if (currentAC < deltaTemp) {
                ++currentAC;
            } else if (currentAC > deltaTemp) {
                --currentAC;
            }
        }
        if (this.acStat.isStatOpen()) {
            int ac = MathHelper.func_76125_a((int)currentAC, (int)-20, (int)20);
            String bar = (ac < 0 ? TextFormatting.BLUE : TextFormatting.GOLD) + Strings.repeat((String)"|", (int)Math.abs(ac)) + TextFormatting.DARK_GRAY + Strings.repeat((String)"|", (int)(20 - Math.abs(ac)));
            this.acStat.setTitle((ITextComponent)new StringTextComponent("A/C: " + bar).func_240699_a_(TextFormatting.YELLOW));
            this.acStat.setBackgroundColor(ac < 0 ? 805339391 : (ac == 0 ? 0x3000AA00 : 822071296));
        }
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.acStat == null) {
            this.acStat = new WidgetAnimatedStat(null, StringTextComponent.field_240750_d_, WidgetAnimatedStat.StatIcon.NONE, HUDHandler.getInstance().getStatOverlayColor(), null, ArmorHUDLayout.INSTANCE.airConStat);
            this.acStat.setMinimumContractedDimensions(0, 0);
        }
        return this.acStat;
    }

    @Override
    public void onResolutionChanged() {
        this.acStat = null;
    }

    static {
        currentAC = 0;
    }
}

