/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.TubeModuleClientRegistry;
import me.desht.pneumaticcraft.client.render.tube_module.TubeModuleRendererBase;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;

public class RenderPressureTubeModule
extends TileEntityRenderer<TileEntityPressureTube> {
    private final Map<ResourceLocation, TubeModuleRendererBase<?>> models = new HashMap();

    public RenderPressureTubeModule(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileEntityPressureTube tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (tile.getCamouflage() != null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Hand holdingModule = null;
        if (mc.field_71439_g.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof ItemTubeModule) {
            holdingModule = Hand.MAIN_HAND;
        } else if (mc.field_71439_g.func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof ItemTubeModule) {
            holdingModule = Hand.OFF_HAND;
        }
        List modules = tile.tubeModules().collect(Collectors.toList());
        if (modules.isEmpty() && holdingModule == null) {
            return;
        }
        if (holdingModule != null && mc.field_71476_x instanceof BlockRayTraceResult) {
            Direction face;
            BlockRayTraceResult brtr = (BlockRayTraceResult)mc.field_71476_x;
            Direction direction = face = mc.field_71439_g.func_213453_ef() ? brtr.func_216354_b().func_176734_d() : brtr.func_216354_b();
            if (brtr.func_216350_a().equals((Object)tile.func_174877_v()) && mc.field_71441_e.func_175625_s(brtr.func_216350_a()) == tile && tile.getModule(face) == null) {
                TubeModule fakeModule = ((ItemTubeModule)mc.field_71439_g.func_184586_b(holdingModule).func_77973_b()).createModule();
                fakeModule.markFake();
                fakeModule.setDirection(face);
                fakeModule.setTube(tile);
                this.getModuleRenderer(fakeModule).renderModule(fakeModule, matrixStack, buffer, partialTicks, combinedLight, combinedOverlay);
            }
        }
        for (TubeModule m : modules) {
            this.getModuleRenderer(m).renderModule(m, matrixStack, buffer, partialTicks, combinedLight, combinedOverlay);
        }
    }

    private <T extends TubeModule> TubeModuleRendererBase<T> getModuleRenderer(T module) {
        TubeModuleRendererBase res = this.models.computeIfAbsent(module.getType(), k -> TubeModuleClientRegistry.createModel(module));
        return res;
    }

    public boolean isGlobalRenderer(TileEntityPressureTube te) {
        return te.tubeModules().findAny().isPresent();
    }
}

