/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.StringUtils;

public class GuiUtils {
    private static final ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    public static final String TRANSLATION_LINE_BREAK = "${br}";

    public static void renderItemStack(MatrixStack matrixStack, ItemStack stack, int x, int y) {
        if (!stack.func_190926_b()) {
            boolean flag;
            IBakedModel bakedmodel = itemRenderer.func_184393_a(stack, (World)null, (LivingEntity)Minecraft.func_71410_x().field_71439_g);
            matrixStack.func_227860_a_();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.func_227861_a_((double)x, (double)y, 150.0);
            matrixStack.func_227861_a_(8.0, 8.0, 0.0);
            matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
            matrixStack.func_227862_a_(16.0f, 16.0f, 16.0f);
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            boolean bl = flag = !bakedmodel.func_230044_c_();
            if (!bakedmodel.func_230044_c_()) {
                RenderHelper.func_227783_c_();
            }
            itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixStack, (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
            buffer.func_228461_a_();
            RenderSystem.enableDepthTest();
            if (flag) {
                RenderHelper.func_227784_d_();
            }
            RenderSystem.disableAlphaTest();
            RenderSystem.disableRescaleNormal();
            matrixStack.func_227865_b_();
        }
    }

    public static void renderItemStackOverlay(MatrixStack matrixStack, FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text) {
        if (!stack.func_190926_b()) {
            ClientPlayerEntity clientplayerentity;
            float f3;
            if (stack.func_190916_E() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                matrixStack.func_227861_a_(0.0, 0.0, 250.0);
                IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                fr.func_228079_a_(s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF, true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                buffer.func_228461_a_();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                GuiUtils.drawUntexturedQuad(matrixStack, bufferbuilder, xPosition + 2, yPosition + 13, 0.0f, 13.0f, 2.0f, 0, 0, 0, 255);
                GuiUtils.drawUntexturedQuad(matrixStack, bufferbuilder, xPosition + 2, yPosition + 13, 0.0f, i, 1.0f, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f = f3 = (clientplayerentity = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : clientplayerentity.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
                GuiUtils.drawUntexturedQuad(matrixStack, bufferbuilder1, xPosition, yPosition + MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 0.0f, 16.0f, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
    }

    public static void renderBlockInGui(MatrixStack matrixStack, BlockState block, float x, float y, float z, float rotate, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, (double)z);
        matrixStack.func_227862_a_(scale, -scale, scale);
        matrixStack.func_227861_a_(-0.5, -1.0, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
        matrixStack.func_227861_a_(0.5, 0.0, -0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotate));
        matrixStack.func_227861_a_(-0.5, 0.0, 0.5);
        matrixStack.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227861_a_(0.0, 0.0, -1.0);
        mc.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        mc.func_175602_ab().renderBlock(block, matrixStack, (IRenderTypeBuffer)buffers, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        buffers.func_228461_a_();
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }

    public static void drawFluid(MatrixStack matrixStack, Rectangle2d bounds, @Nullable FluidStack fluidStack, @Nullable IFluidTank tank) {
        int scaledAmount;
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation fluidStill = fluid.getAttributes().getStillTexture(fluidStack);
        if (fluidStill == null) {
            fluidStill = MissingTextureSprite.func_195675_b();
        }
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluidStill);
        int n = scaledAmount = tank == null ? bounds.func_199317_d() : fluidStack.getAmount() * bounds.func_199317_d() / tank.getCapacity();
        if (fluidStack.getAmount() > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        scaledAmount = Math.min(scaledAmount, bounds.func_199317_d());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int xTileCount = bounds.func_199316_c() / 16;
        int xRemainder = bounds.func_199316_c() - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = bounds.func_199319_b() + bounds.func_199317_d();
        if (fluid.getAttributes().getDensity() < 0) {
            yStart -= bounds.func_199317_d() - scaledAmount;
        }
        int[] cols = RenderUtils.decomposeColor(fluid.getAttributes().getColor(fluidStack));
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int w = xTile == xTileCount ? xRemainder : 16;
                int h = yTile == yTileCount ? yRemainder : 16;
                int x = bounds.func_199318_a() + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (bounds.func_199316_c() <= 0 || h <= 0) continue;
                int maskTop = 16 - h;
                int maskRight = 16 - w;
                GuiUtils.drawFluidTexture(matrixStack, x, y, fluidStillSprite, maskTop, maskRight, 100.0f, cols);
            }
        }
        RenderSystem.disableBlend();
    }

    private static void drawFluidTexture(MatrixStack matrixStack, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, float zLevel, int[] cols) {
        float uMin = textureSprite.func_94209_e();
        float uMax = textureSprite.func_94212_f();
        float vMin = textureSprite.func_94206_g();
        float vMax = textureSprite.func_94210_h();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        worldrenderer.func_227888_a_(posMat, xCoord, yCoord + 16.0f, zLevel).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(uMin, vMax).func_181675_d();
        worldrenderer.func_227888_a_(posMat, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(uMax, vMax).func_181675_d();
        worldrenderer.func_227888_a_(posMat, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(uMax, vMin).func_181675_d();
        worldrenderer.func_227888_a_(posMat, xCoord, yCoord + (float)maskTop, zLevel).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_225583_a_(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void showPopupHelpScreen(MatrixStack matrixStack, Screen screen, FontRenderer fontRenderer, List<ITextComponent> helpText) {
        int y;
        int x;
        List<IReorderingProcessor> l = GuiUtils.wrapTextComponentList(helpText, screen.field_230708_k_ / 2, fontRenderer);
        fontRenderer.getClass();
        int lineSpacing = 9 + 1;
        int boxHeight = Math.min(screen.field_230709_l_, l.size() * lineSpacing);
        int maxLines = boxHeight / lineSpacing;
        int boxWidth = l.stream().max(Comparator.comparingInt(arg_0 -> ((FontRenderer)fontRenderer).func_243245_a(arg_0))).map(arg_0 -> ((FontRenderer)fontRenderer).func_243245_a(arg_0)).orElse(0);
        if (screen instanceof ContainerScreen) {
            x = (((ContainerScreen)screen).getXSize() - boxWidth) / 2;
            y = (((ContainerScreen)screen).getYSize() - boxHeight) / 2;
        } else {
            x = (screen.field_230708_k_ - boxWidth) / 2;
            y = (screen.field_230709_l_ - boxHeight) / 2;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 400.0);
        GuiUtils.drawPanel(matrixStack, x, y, boxHeight, boxWidth);
        for (IReorderingProcessor line : l) {
            fontRenderer.func_238422_b_(matrixStack, line, (float)x, (float)y, -2039584);
            y += lineSpacing;
            if (maxLines-- != 0) continue;
            break;
        }
        matrixStack.func_227865_b_();
    }

    public static void drawPanel(MatrixStack matrixStack, int x, int y, int panelHeight, int panelWidth) {
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x - 4), (int)(y - 4), (int)(x + panelWidth + 8), (int)(y + panelHeight + 8), (int)-1073741824);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x - 4), (int)(y - 4), (int)(x + panelWidth + 8), (int)(y - 3), (int)-8355712);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x - 4), (int)(y + panelHeight + 8), (int)(x + panelWidth + 8), (int)(y + panelHeight + 9), (int)-8355712);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x - 4), (int)(y - 4), (int)(x - 3), (int)(y + panelHeight + 8), (int)-8355712);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + panelWidth + 8), (int)(y - 4), (int)(x + panelWidth + 9), (int)(y + panelHeight + 8), (int)-8355712);
    }

    public static void drawTexture(MatrixStack matrixStack, ResourceLocation texture, int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        RenderSystem.enableTexture();
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        builder.func_227888_a_(posMat, (float)x, (float)(y + 16), 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(posMat, (float)(x + 16), (float)(y + 16), 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(posMat, (float)(x + 16), (float)y, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(posMat, (float)x, (float)y, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawUntexturedQuad(MatrixStack matrixStack, BufferBuilder renderer, float x, float y, float z, float width, float height, int red, int green, int blue, int alpha) {
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_227888_a_(posMat, x, y, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(posMat, x, y + height, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(posMat, x + width, y + height, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(posMat, x + width, y, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawOutline(MatrixStack matrixStack, BufferBuilder renderer, float x, float y, float z, float width, float height, int red, int green, int blue, int alpha) {
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        renderer.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        renderer.func_227888_a_(posMat, x, y, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(posMat, x, y + height, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(posMat, x + width, y + height, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(posMat, x + width, y, z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void glColorHex(int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void drawScaledText(MatrixStack matrixStack, FontRenderer fr, String text, int x, int y, int color, float scale) {
        if (scale != 1.0f) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)x, (double)y, 0.0);
            matrixStack.func_227862_a_(scale, scale, scale);
            fr.func_238421_b_(matrixStack, text, 0.0f, 0.0f, color);
            matrixStack.func_227865_b_();
        } else {
            fr.func_238421_b_(matrixStack, text, (float)x, (float)y, color);
        }
    }

    public static List<IReorderingProcessor> wrapTextComponentList(List<ITextComponent> text, int maxWidth, FontRenderer font) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ITextComponent line : text) {
            builder.addAll((Iterable)RenderComponentsUtil.func_238505_a_((ITextProperties)line, (int)maxWidth, (FontRenderer)font));
        }
        return builder.build();
    }

    public static List<ITextComponent> xlateAndSplit(String key, Object ... params) {
        return Arrays.stream(StringUtils.splitByWholeSeparator((String)I18n.func_135052_a((String)key, (Object[])params), (String)TRANSLATION_LINE_BREAK)).map(StringTextComponent::new).collect(Collectors.toList());
    }
}

