/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.ai.ChunkPositionSorter;
import me.desht.pneumaticcraft.common.ai.DroneClaimManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnIndicatorParticles;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.ThreadedSorter;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;

public abstract class DroneAIBlockInteraction<W extends ProgWidgetAreaItemBase>
extends Goal {
    private static final int MAX_LOOKUPS_PER_SEARCH = 30;
    private static final int DRONE_DEBUG_PARTICLE_RANGE_SQ = 1024;
    protected final IDroneBase drone;
    protected final W progWidget;
    private final IBlockOrdered.Ordering order;
    private BlockPos curPos;
    private final List<BlockPos> area;
    final ICollisionReader worldCache;
    private final List<BlockPos> blacklist = new ArrayList<BlockPos>();
    private int curY;
    private int lastSuccessfulY;
    private int minY;
    private int maxY;
    private ThreadedSorter<BlockPos> sorter;
    private boolean aborted;
    private boolean searching;
    private int searchIndex;
    private int totalActions;
    private int maxActions = -1;

    public DroneAIBlockInteraction(IDroneBase drone, W progWidget) {
        this.drone = drone;
        this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        this.progWidget = progWidget;
        this.order = progWidget instanceof IBlockOrdered ? ((IBlockOrdered)progWidget).getOrder() : IBlockOrdered.Ordering.CLOSEST;
        this.area = ((ProgWidgetAreaItemBase)progWidget).getCachedAreaList();
        this.worldCache = ((ProgWidgetAreaItemBase)progWidget).getChunkCache(drone.world());
        AxisAlignedBB extents = ((ProgWidgetAreaItemBase)progWidget).getAreaExtents();
        if (this.area.size() > 0) {
            this.minY = (int)extents.field_72338_b;
            this.maxY = (int)extents.field_72337_e;
            if (this.order == IBlockOrdered.Ordering.HIGH_TO_LOW) {
                this.curY = this.maxY;
            } else if (this.order == IBlockOrdered.Ordering.LOW_TO_HIGH) {
                this.curY = this.minY;
            }
        }
    }

    public boolean func_75250_a() {
        if (this.aborted || this.maxActions >= 0 && this.totalActions >= this.maxActions) {
            return false;
        }
        if (!this.searching) {
            this.searching = true;
            this.lastSuccessfulY = this.curY;
            this.curPos = null;
            this.searchIndex = 0;
            if (this.sorter == null || this.sorter.isDone()) {
                this.sorter = new ThreadedSorter<BlockPos>(this.area, new ChunkPositionSorter(this.drone, this.order));
            }
            return true;
        }
        return false;
    }

    private void updateY() {
        this.searchIndex = 0;
        if (this.order == IBlockOrdered.Ordering.LOW_TO_HIGH) {
            if (++this.curY > this.maxY) {
                this.curY = this.minY;
            }
        } else if (this.order == IBlockOrdered.Ordering.HIGH_TO_LOW && --this.curY < this.minY) {
            this.curY = this.maxY;
        }
    }

    private boolean isYValid(int y) {
        return this.order == IBlockOrdered.Ordering.CLOSEST || y == this.curY;
    }

    public DroneAIBlockInteraction<?> setMaxActions(int maxActions) {
        this.maxActions = maxActions;
        return this;
    }

    protected abstract boolean isValidPosition(BlockPos var1);

    protected abstract boolean doBlockInteraction(BlockPos var1, double var2);

    public boolean func_75253_b() {
        block17: {
            double distSq;
            block18: {
                if (this.aborted) {
                    return false;
                }
                if (this.searching) {
                    if (!this.sorter.isDone()) {
                        return true;
                    }
                    boolean firstRun = true;
                    int searchedBlocks = 0;
                    while (this.curPos == null && this.curY != this.lastSuccessfulY && this.order != IBlockOrdered.Ordering.CLOSEST || firstRun) {
                        firstRun = false;
                        ArrayList<BlockPos> inspectedPositions = new ArrayList<BlockPos>();
                        while (!this.shouldAbort() && this.searchIndex < this.area.size()) {
                            BlockPos pos = this.area.get(this.searchIndex);
                            ++this.searchIndex;
                            if (!(!this.isYValid(pos.func_177956_o()) || this.blacklist.contains(pos) || this.respectClaims() && DroneClaimManager.getInstance(this.drone.world()).isClaimed(pos))) {
                                if (!this.drone.getDebugger().getDebuggingPlayers().isEmpty()) {
                                    inspectedPositions.add(pos);
                                }
                                if (this.isValidPosition(pos)) {
                                    this.curPos = pos;
                                    if (this.moveToPositions()) {
                                        if (this.tryMoveToBlock(pos)) {
                                            return true;
                                        }
                                        if (this.drone.getPathNavigator().isGoingToTeleport()) {
                                            return this.movedToBlockOK(pos);
                                        }
                                        this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.general.debug.cantNavigate", pos);
                                    } else {
                                        this.searching = false;
                                        ++this.totalActions;
                                        return true;
                                    }
                                }
                                ++searchedBlocks;
                            }
                            if (searchedBlocks < 30) continue;
                            this.indicateToListeningPlayers(inspectedPositions);
                            return true;
                        }
                        this.indicateToListeningPlayers(inspectedPositions);
                        if (this.curPos != null) continue;
                        this.updateY();
                    }
                    if (!this.shouldAbort()) {
                        this.addEndingDebugEntry();
                    }
                    return false;
                }
                if (this.curPos == null) break block17;
                if (this.respectClaims()) {
                    DroneClaimManager.getInstance(this.drone.world()).claim(this.curPos);
                }
                distSq = this.drone.getDronePos().func_72436_e(Vector3d.func_237489_a_((Vector3i)this.curPos));
                if (!this.moveToPositions()) break block18;
                int n = this.moveIntoBlock() ? 1 : 4;
                if (!(distSq < (double)n)) break block17;
            }
            return this.doBlockInteraction(this.curPos, distSq);
        }
        return !this.drone.getPathNavigator().hasNoPath();
    }

    private boolean tryMoveToBlock(BlockPos pos) {
        if (this.moveIntoBlock()) {
            if (this.blockAllowsMovement(this.worldCache, this.curPos, this.worldCache.func_180495_p(pos)) && this.drone.getPathNavigator().moveToXYZ(this.curPos.func_177958_n(), (double)this.curPos.func_177956_o() + 0.5, this.curPos.func_177952_p())) {
                return this.movedToBlockOK(pos);
            }
        } else {
            ISidedWidget w = this.progWidget instanceof ISidedWidget ? (ISidedWidget)this.progWidget : null;
            for (Direction dir : DirectionUtil.VALUES) {
                BlockPos pos2 = this.curPos.func_177972_a(dir);
                if (this.drone.getDronePos().func_186679_c((double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5) < 0.5) {
                    return this.movedToBlockOK(pos);
                }
                if (w != null && !w.isSideSelected(dir) || !this.blockAllowsMovement(this.worldCache, pos2, this.worldCache.func_180495_p(pos2)) || !this.drone.getPathNavigator().moveToXYZ(pos2.func_177958_n(), (double)pos2.func_177956_o() + 0.5, pos2.func_177952_p())) continue;
                return this.movedToBlockOK(pos);
            }
        }
        return false;
    }

    private boolean blockAllowsMovement(ICollisionReader world, BlockPos pos, BlockState state) {
        return state.func_177230_c() instanceof FlowingFluidBlock ? this.drone.canMoveIntoFluid((Fluid)((FlowingFluidBlock)state.func_177230_c()).getFluid()) : world.func_180495_p(pos).func_196957_g((IBlockReader)world, pos, PathType.AIR);
    }

    private boolean movedToBlockOK(BlockPos pos) {
        this.searching = false;
        ++this.totalActions;
        if (this.respectClaims()) {
            DroneClaimManager.getInstance(this.drone.world()).claim(pos);
        }
        this.blacklist.clear();
        return true;
    }

    protected void addEndingDebugEntry() {
        this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.blockInteraction.debug.noBlocksValid");
    }

    protected boolean respectClaims() {
        return false;
    }

    protected boolean moveIntoBlock() {
        return false;
    }

    private boolean shouldAbort() {
        return this.aborted;
    }

    public void abort() {
        this.aborted = true;
    }

    protected boolean moveToPositions() {
        return true;
    }

    private void indicateToListeningPlayers(List<BlockPos> pos) {
        if (!pos.isEmpty()) {
            for (ServerPlayerEntity player : this.drone.getDebugger().getDebuggingPlayers()) {
                CommonArmorHandler handler;
                if (!(player.func_70092_e((double)pos.get(0).func_177958_n(), (double)pos.get(0).func_177956_o(), (double)pos.get(0).func_177952_p()) < 1024.0) || !(handler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player)).isArmorReady(EquipmentSlotType.HEAD) || !handler.isEntityTrackerEnabled() || handler.getUpgradeCount(EquipmentSlotType.HEAD, EnumUpgrade.ENTITY_TRACKER) <= 0 || handler.getUpgradeCount(EquipmentSlotType.HEAD, EnumUpgrade.DISPENSER) <= 0) continue;
                NetworkHandler.sendToPlayer(new PacketSpawnIndicatorParticles(pos, this.progWidget.getColor()), player);
            }
        }
    }

    void addToBlacklist(BlockPos coord) {
        this.blacklist.add(coord);
        this.drone.sendWireframeToClient(coord);
    }
}

