/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetLiquidImport;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DroneAILiquidImport<W extends ProgWidgetInventoryBase>
extends DroneAIImExBase<W> {
    public DroneAILiquidImport(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.emptyTank(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        return this.emptyTank(pos, false) && super.doBlockInteraction(pos, squareDistToBlock);
    }

    private boolean shouldVoidExcess() {
        return this.progWidget instanceof ProgWidgetLiquidImport && ((ProgWidgetLiquidImport)this.progWidget).shouldVoidExcess();
    }

    private boolean emptyTank(BlockPos pos, boolean simulate) {
        if (!this.shouldVoidExcess() && this.drone.getFluidTank().getFluidAmount() == this.drone.getFluidTank().getCapacity()) {
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.liquidImport.debug.fullDroneTank");
            this.abort();
            return false;
        }
        TileEntity te = this.drone.world().func_175625_s(pos);
        if (te != null) {
            Direction side;
            boolean didWork = false;
            Direction[] directionArray = DirectionUtil.VALUES;
            int n = directionArray.length;
            for (int i = 0; !(i >= n || ((ProgWidgetInventoryBase)this.progWidget).isSideSelected(side = directionArray[i]) && (didWork = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).map(handler -> this.tryImportFluid((IFluidHandler)handler, simulate)).orElse(false).booleanValue())); ++i) {
            }
            if (didWork) {
                return true;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.liquidImport.debug.emptiedToMax", pos);
        }
        if (!((ProgWidgetInventoryBase)this.progWidget).useCount() || this.getRemainingCount() >= 1000) {
            LazyOptional cap = this.drone.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            FluidState state = this.drone.world().func_204610_c(pos);
            BlockState blockState = this.drone.world().func_180495_p(pos);
            if (state.func_206889_d() && ((ILiquidFiltered)((Object)((ProgWidgetInventoryBase)this.progWidget))).isFluidValid(state.func_206886_c())) {
                FluidStack stack = new FluidStack(state.func_206886_c(), 1000);
                if ((this.shouldVoidExcess() || this.drone.getFluidTank().fill(stack, IFluidHandler.FluidAction.SIMULATE) == 1000) && !simulate && blockState.func_177230_c() instanceof IBucketPickupHandler) {
                    ((IBucketPickupHandler)blockState.func_177230_c()).func_204508_a((IWorld)this.drone.world(), pos, blockState);
                    this.decreaseCount(1000);
                    this.drone.getFluidTank().fill(stack, IFluidHandler.FluidAction.EXECUTE);
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private boolean tryImportFluid(IFluidHandler sourceHandler, boolean simulate) {
        FluidStack importedFluid = sourceHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (!importedFluid.isEmpty() && ((ILiquidFiltered)((Object)((ProgWidgetInventoryBase)this.progWidget))).isFluidValid(importedFluid.getFluid())) {
            int filledAmount = this.drone.getFluidTank().fill(importedFluid, IFluidHandler.FluidAction.SIMULATE);
            if (filledAmount > 0) {
                if (((ProgWidgetInventoryBase)this.progWidget).useCount()) {
                    filledAmount = Math.min(filledAmount, this.getRemainingCount());
                }
                if (!simulate) {
                    this.decreaseCount(this.drone.getFluidTank().fill(sourceHandler.drain(filledAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE));
                }
                return true;
            }
            return this.shouldVoidExcess();
        }
        return false;
    }
}

