/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.SpecialVariableRetrievalEvent;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.ai.DroneAIExternalProgram;
import me.desht.pneumaticcraft.common.ai.DroneEntityAIPickupItems;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.progwidgets.IJumpBackWidget;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableProvider;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.variables.GlobalVariableManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class DroneAIManager
implements IVariableProvider {
    private final List<EntityAITaskEntry> taskEntries = new ArrayList<EntityAITaskEntry>();
    private final List<EntityAITaskEntry> executingTaskEntries = new ArrayList<EntityAITaskEntry>();
    private final IProfiler theProfiler;
    private int tickCount;
    static final int TICK_RATE = 3;
    private final IDroneBase drone;
    private List<IProgWidget> progWidgets;
    private IProgWidget curActiveWidget;
    private Goal curWidgetAI;
    private Goal curWidgetTargetAI;
    private boolean stopWhenEndReached;
    private boolean wasAIOveridden;
    private String currentLabel = "Main";
    private Map<String, BlockPos> coordinateVariables = new HashMap<String, BlockPos>();
    private Map<String, ItemStack> itemVariables = new HashMap<String, ItemStack>();
    private final Stack<IProgWidget> jumpBackWidgets = new Stack();
    private static final int MAX_JUMP_STACK_SIZE = 100;

    public DroneAIManager(IDroneBase drone) {
        this.theProfiler = drone.world().func_217381_Z();
        this.drone = drone;
        if (!drone.world().field_72995_K) {
            this.setWidgets(drone.getProgWidgets());
        }
    }

    public DroneAIManager(IDroneBase drone, List<IProgWidget> progWidgets) {
        this.theProfiler = drone.world().func_217381_Z();
        this.drone = drone;
        this.stopWhenEndReached = true;
        this.setWidgets(progWidgets);
    }

    public void dontStopWhenEndReached() {
        this.stopWhenEndReached = false;
    }

    public void setWidgets(List<IProgWidget> progWidgets) {
        this.progWidgets = progWidgets;
        if (progWidgets.isEmpty()) {
            this.setActiveWidget(null);
        } else {
            for (IProgWidget widget : progWidgets) {
                if (!(widget instanceof IVariableWidget)) continue;
                ((IVariableWidget)((Object)widget)).setAIManager(this);
            }
            this.gotoFirstWidget();
        }
    }

    void connectVariables(DroneAIManager subAI) {
        subAI.coordinateVariables = this.coordinateVariables;
        subAI.itemVariables = this.itemVariables;
    }

    public void clearVariables() {
        this.coordinateVariables.clear();
        this.itemVariables.clear();
    }

    public boolean isIdling() {
        return this.curWidgetAI == null;
    }

    Goal getCurrentAI() {
        return this.curWidgetAI;
    }

    public IDroneBase getDrone() {
        return this.drone;
    }

    public CompoundNBT writeToNBT(CompoundNBT tag) {
        ListNBT tagList = new ListNBT();
        for (Map.Entry<String, BlockPos> entry : this.coordinateVariables.entrySet()) {
            CompoundNBT t = new CompoundNBT();
            t.func_74778_a("key", entry.getKey());
            t.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry.getValue()));
            tagList.add((Object)t);
        }
        tag.func_218657_a("coords", (INBT)tagList);
        ListNBT tagList2 = new ListNBT();
        for (Map.Entry<String, ItemStack> entry : this.itemVariables.entrySet()) {
            CompoundNBT t = new CompoundNBT();
            t.func_74778_a("key", entry.getKey());
            t.func_218657_a("item", (INBT)entry.getValue().serializeNBT());
            tagList2.add((Object)t);
        }
        tag.func_218657_a("items", (INBT)tagList2);
        return tag;
    }

    public void readFromNBT(CompoundNBT tag) {
        this.coordinateVariables.clear();
        ListNBT tagList = tag.func_150295_c("coords", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT t = tagList.func_150305_b(i);
            this.coordinateVariables.put(t.func_74779_i("key"), NBTUtil.func_186861_c((CompoundNBT)t.func_74775_l("pos")));
        }
        ListNBT tagList2 = tag.func_150295_c("items", 10);
        for (int i = 0; i < tagList2.size(); ++i) {
            CompoundNBT t = tagList2.func_150305_b(i);
            this.itemVariables.put(t.func_74779_i("key"), ItemStack.func_199557_a((CompoundNBT)t.func_74775_l("item")));
        }
    }

    @Override
    public boolean hasCoordinate(String varName) {
        return this.getCoordinateInternal(varName) != null;
    }

    @Override
    public BlockPos getCoordinate(String varName) {
        BlockPos pos = this.getCoordinateInternal(varName);
        return pos != null ? pos : BlockPos.field_177992_a;
    }

    private BlockPos getCoordinateInternal(String varName) {
        if (varName.startsWith("$")) {
            SpecialVariableRetrievalEvent.CoordinateVariable.Drone event = new SpecialVariableRetrievalEvent.CoordinateVariable.Drone(this.drone, varName.substring(1));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getCoordinate();
        }
        if (varName.startsWith("#")) {
            return GlobalVariableManager.getInstance().getPos(varName.substring(1));
        }
        return this.coordinateVariables.get(varName);
    }

    public void setCoordinate(String varName, BlockPos coord) {
        if (varName.startsWith("#")) {
            GlobalVariableManager.getInstance().set(varName.substring(1), coord);
        } else if (!varName.startsWith("$")) {
            this.coordinateVariables.put(varName, coord);
            this.drone.onVariableChanged(varName, true);
        }
    }

    @Override
    public boolean hasStack(String varName) {
        return !this.getStack(varName).func_190926_b();
    }

    @Override
    public ItemStack getStack(String varName) {
        ItemStack item;
        if (varName.startsWith("$")) {
            SpecialVariableRetrievalEvent.ItemVariable.Drone event = new SpecialVariableRetrievalEvent.ItemVariable.Drone(this.drone, varName.substring(1));
            MinecraftForge.EVENT_BUS.post((Event)event);
            item = event.getItem();
        } else {
            item = varName.startsWith("#") ? GlobalVariableManager.getInstance().getItem(varName.substring(1)) : this.itemVariables.getOrDefault(varName, ItemStack.field_190927_a);
        }
        return item;
    }

    public void setItem(String varName, @Nonnull ItemStack item) {
        if (varName.startsWith("#")) {
            GlobalVariableManager.getInstance().set(varName.substring(1), item);
        } else if (!varName.startsWith("$")) {
            this.itemVariables.put(varName, item);
            this.drone.onVariableChanged(varName, false);
        }
    }

    private void updateWidgetFlow() {
        boolean isExecuting = false;
        for (EntityAITaskEntry entry : this.executingTaskEntries) {
            if (this.curWidgetAI != entry.goal) continue;
            isExecuting = true;
            break;
        }
        if (!(isExecuting || this.curActiveWidget == null || this.curWidgetTargetAI != null && this.curWidgetTargetAI.func_75250_a())) {
            IProgWidget widget = this.curActiveWidget.getOutputWidget(this.drone, this.progWidgets);
            if (widget != null) {
                if (this.curActiveWidget.getOutputWidget() != widget && this.addJumpBackWidget(this.curActiveWidget)) {
                    return;
                }
                this.setActiveWidget(widget);
            } else if (this.stopWhenEndReached) {
                this.setActiveWidget(null);
            } else {
                this.gotoFirstWidget();
            }
        }
        if (this.curActiveWidget == null && !this.stopWhenEndReached) {
            this.gotoFirstWidget();
        }
    }

    private void gotoFirstWidget() {
        this.setLabel("Main");
        if (!this.jumpBackWidgets.isEmpty()) {
            this.setActiveWidget(this.jumpBackWidgets.pop());
        } else {
            for (IProgWidget widget : this.progWidgets) {
                if (!(widget instanceof ProgWidgetStart)) continue;
                this.setActiveWidget(widget);
                return;
            }
        }
    }

    private void setActiveWidget(IProgWidget widget) {
        Goal targetAI = null;
        Goal ai = null;
        if (widget != null) {
            boolean first = widget instanceof ProgWidgetStart;
            targetAI = widget.getWidgetTargetAI(this.drone, widget);
            ai = widget.getWidgetAI(this.drone, widget);
            HashSet<IProgWidget> visitedWidgets = new HashSet<IProgWidget>();
            while (!visitedWidgets.contains(widget) && targetAI == null && ai == null) {
                visitedWidgets.add(widget);
                IProgWidget oldWidget = widget;
                widget = widget.getOutputWidget(this.drone, this.progWidgets);
                if (widget == null) {
                    if (!first) {
                        if (this.stopWhenEndReached) {
                            this.setActiveWidget(null);
                        } else {
                            this.gotoFirstWidget();
                        }
                    }
                    return;
                }
                if (oldWidget.getOutputWidget() != widget && this.addJumpBackWidget(oldWidget)) {
                    return;
                }
                targetAI = widget.getWidgetTargetAI(this.drone, widget);
                ai = widget.getWidgetAI(this.drone, widget);
            }
            this.drone.setActiveProgram(widget);
        } else {
            this.setLabel("Stopped");
        }
        this.curActiveWidget = widget;
        if (this.curWidgetAI != null) {
            this.removeGoal(this.curWidgetAI);
        }
        if (this.curWidgetTargetAI != null) {
            this.drone.getTargetAI().func_85156_a(this.curWidgetTargetAI);
        }
        if (ai != null) {
            this.addGoal(2, ai);
        }
        if (targetAI != null) {
            this.drone.getTargetAI().func_75776_a(2, targetAI);
        }
        this.curWidgetAI = ai;
        this.curWidgetTargetAI = targetAI;
    }

    private boolean addJumpBackWidget(IProgWidget widget) {
        if (widget instanceof IJumpBackWidget) {
            if (this.jumpBackWidgets.size() >= 100) {
                this.drone.overload("jumpStackTooLarge", 100);
                this.jumpBackWidgets.clear();
                this.setActiveWidget(null);
                return true;
            }
            this.jumpBackWidgets.push(widget);
        }
        return false;
    }

    public List<EntityAITaskEntry> getRunningTasks() {
        return this.taskEntries;
    }

    public Goal getTargetAI() {
        return this.curWidgetTargetAI;
    }

    private void addGoal(int priority, Goal goal) {
        this.taskEntries.add(new EntityAITaskEntry(priority, goal));
    }

    private void removeGoal(Goal goal) {
        Iterator<EntityAITaskEntry> iterator = this.taskEntries.iterator();
        while (iterator.hasNext()) {
            EntityAITaskEntry entityaitaskentry = iterator.next();
            Goal entityaibase1 = entityaitaskentry.goal;
            if (entityaibase1 != goal) continue;
            if (this.executingTaskEntries.contains(entityaitaskentry)) {
                entityaibase1.func_75251_c();
                this.executingTaskEntries.remove(entityaitaskentry);
            }
            iterator.remove();
        }
    }

    private void pickupItemsIfMagnet() {
        int magnetUpgrades = this.drone.getUpgrades(EnumUpgrade.MAGNET);
        if (magnetUpgrades > 0 && !this.drone.getProgWidgets().isEmpty()) {
            int range = Math.min(6, 1 + magnetUpgrades);
            int rangeSq = range * range;
            Vector3d v = this.drone.getDronePos();
            AxisAlignedBB aabb = new AxisAlignedBB(v.field_72450_a, v.field_72448_b, v.field_72449_c, v.field_72450_a, v.field_72448_b, v.field_72449_c).func_186662_g((double)range);
            List items = this.drone.world().func_175647_a(ItemEntity.class, aabb, item -> item != null && item.func_70089_S() && !item.func_174874_s() && !ItemRegistry.getInstance().shouldSuppressMagnet((Entity)item) && this.drone.getDronePos().func_72436_e(item.func_213303_ch()) <= (double)rangeSq);
            for (ItemEntity item2 : items) {
                DroneEntityAIPickupItems.tryPickupItem(this.drone, item2);
            }
        }
    }

    public void onUpdateTasks() {
        if (PNCConfig.Common.Advanced.stopDroneAI) {
            return;
        }
        this.pickupItemsIfMagnet();
        if (!this.drone.isAIOverridden()) {
            if (this.wasAIOveridden && this.curWidgetTargetAI != null) {
                this.drone.getTargetAI().func_75776_a(2, this.curWidgetTargetAI);
            }
            this.wasAIOveridden = false;
            ArrayList<EntityAITaskEntry> arraylist = new ArrayList<EntityAITaskEntry>();
            if (this.tickCount++ % 3 == 0) {
                for (EntityAITaskEntry entityaitaskentry : this.taskEntries) {
                    boolean flag = this.executingTaskEntries.contains(entityaitaskentry);
                    if (flag) {
                        if (this.canUse(entityaitaskentry) && this.canContinue(entityaitaskentry)) continue;
                        entityaitaskentry.goal.func_75251_c();
                        this.executingTaskEntries.remove(entityaitaskentry);
                    }
                    if (!this.canUse(entityaitaskentry) || !entityaitaskentry.goal.func_75250_a()) continue;
                    arraylist.add(entityaitaskentry);
                    this.executingTaskEntries.add(entityaitaskentry);
                }
                this.updateWidgetFlow();
            } else {
                Iterator<EntityAITaskEntry> iterator = this.executingTaskEntries.iterator();
                while (iterator.hasNext()) {
                    EntityAITaskEntry entityaitaskentry;
                    entityaitaskentry = iterator.next();
                    if (entityaitaskentry.goal.func_75253_b()) continue;
                    entityaitaskentry.goal.func_75251_c();
                    iterator.remove();
                }
            }
            this.theProfiler.func_76320_a("goalStart");
            for (EntityAITaskEntry entityaitaskentry : arraylist) {
                this.theProfiler.func_76320_a(entityaitaskentry.goal.getClass().getSimpleName());
                entityaitaskentry.goal.func_75249_e();
                this.theProfiler.func_76319_b();
            }
            this.theProfiler.func_76319_b();
            this.theProfiler.func_76320_a("goalTick");
            for (EntityAITaskEntry entityaitaskentry : this.executingTaskEntries) {
                entityaitaskentry.goal.func_75246_d();
            }
            this.theProfiler.func_76319_b();
        } else {
            if (!this.wasAIOveridden && this.curWidgetTargetAI != null) {
                this.drone.getTargetAI().func_85156_a(this.curWidgetTargetAI);
            }
            this.wasAIOveridden = true;
            for (EntityAITaskEntry ai : this.executingTaskEntries) {
                ai.goal.func_75251_c();
            }
            this.executingTaskEntries.clear();
            this.drone.setDugBlock(null);
        }
    }

    private boolean canContinue(EntityAITaskEntry par1EntityAITaskEntry) {
        this.theProfiler.func_76320_a("canContinue");
        boolean flag = par1EntityAITaskEntry.goal.func_75253_b();
        this.theProfiler.func_76319_b();
        return flag;
    }

    private boolean canUse(EntityAITaskEntry par1EntityAITaskEntry) {
        this.theProfiler.func_76320_a("canUse");
        for (EntityAITaskEntry entry : this.taskEntries) {
            if (entry == par1EntityAITaskEntry) continue;
            if (par1EntityAITaskEntry.priority >= entry.priority) {
                if (!this.executingTaskEntries.contains(entry) || this.areTasksCompatible(par1EntityAITaskEntry, entry)) continue;
                this.theProfiler.func_76319_b();
                return false;
            }
            if (!this.executingTaskEntries.contains(entry) || entry.goal.func_220685_C_()) continue;
            this.theProfiler.func_76319_b();
            return false;
        }
        this.theProfiler.func_76319_b();
        return true;
    }

    private boolean areTasksCompatible(EntityAITaskEntry e1, EntityAITaskEntry e2) {
        EnumSet flags = e2.goal.func_220686_i();
        return e1.goal.func_220686_i().stream().noneMatch(flags::contains);
    }

    public void setLabel(String label) {
        this.currentLabel = label;
        this.drone.updateLabel();
    }

    public String getLabel() {
        if (this.curWidgetAI instanceof DroneAIExternalProgram) {
            return ((DroneAIExternalProgram)this.curWidgetAI).getRunningAI().getLabel() + " --> " + this.currentLabel;
        }
        return this.currentLabel;
    }

    public static class EntityAITaskEntry {
        public final Goal goal;
        public final int priority;

        EntityAITaskEntry(int priority, Goal goal) {
            this.priority = priority;
            this.goal = goal;
        }
    }
}

