/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.gui.GuiAphorismTile;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAphorismTile;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockAphorismTile
extends BlockPneumaticCraft
implements ColorHandlers.ITintableBlock {
    public static final float APHORISM_TILE_THICKNESS = 0.0625f;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] INVIS_SHAPES = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.01, (double)16.0), Block.func_208617_a((double)0.0, (double)15.99, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.01), Block.func_208617_a((double)0.0, (double)0.0, (double)15.99, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.01, (double)16.0, (double)16.0), Block.func_208617_a((double)15.99, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    public static final BooleanProperty INVISIBLE = BooleanProperty.func_177716_a((String)"invisible");

    public BlockAphorismTile() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 4.0f).func_200942_a());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)INVISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{INVISIBLE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return state.func_177230_c() == ModBlocks.APHORISM_TILE.get() && (Boolean)state.func_177229_b((Property)INVISIBLE) != false ? INVIS_SHAPES[this.getRotation(state).func_176745_a()] : SHAPES[this.getRotation(state).func_176745_a()];
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.directionProperty(), (Comparable)ctx.func_196000_l().func_176734_d());
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityAphorismTile.class;
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return state.func_177230_c() == ModBlocks.APHORISM_TILE.get() && (Boolean)state.func_177229_b((Property)INVISIBLE) != false ? BlockRenderType.INVISIBLE : super.func_149645_b(state);
    }

    @Override
    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> curInfo, ITooltipFlag flag) {
        CompoundNBT subTag;
        super.func_190948_a(stack, world, curInfo, flag);
        CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
        if (tag != null && tag.func_74764_b("ExtraData") && (subTag = tag.func_74775_l("ExtraData")) != null && (subTag.func_74764_b("borderColor") || subTag.func_74764_b("backgroundColor"))) {
            ListNBT l = subTag.func_150295_c("lines", 8);
            if (!l.isEmpty()) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("gui.tooltip.block.pneumaticcraft.aphorism_tile.text", new Object[0]).func_240699_a_(TextFormatting.YELLOW));
                l.forEach(el -> curInfo.add((ITextComponent)new StringTextComponent("  " + el.func_150285_a_()).func_240699_a_(TextFormatting.ITALIC)));
            }
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("gui.tooltip.block.pneumaticcraft.aphorism_tile.reset", new Object[0]).func_240699_a_(TextFormatting.DARK_GREEN));
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entityLiving, ItemStack iStack) {
        super.func_180633_a(world, pos, state, entityLiving, iStack);
        if (world.field_72995_K) {
            PneumaticCraftUtils.getTileEntityAt((IBlockReader)world, pos, TileEntityAphorismTile.class).ifPresent(teAT -> {
                CompoundNBT tag = iStack.func_179543_a("BlockEntityTag");
                if (tag != null) {
                    teAT.readFromPacket(tag);
                }
                GuiAphorismTile.openGui(teAT, true);
                if (entityLiving instanceof PlayerEntity) {
                    this.sendEditorMessage((PlayerEntity)entityLiving);
                }
            });
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brtr) {
        DyeColor color;
        if (world.field_72995_K && hand == Hand.MAIN_HAND && player.func_184586_b(hand).func_190926_b() && !player.func_225608_bj_()) {
            PneumaticCraftUtils.getTileEntityAt((IBlockReader)world, pos, TileEntityAphorismTile.class).ifPresent(teAT -> {
                GuiAphorismTile.openGui(teAT, false);
                this.sendEditorMessage(player);
            });
        } else if (!world.field_72995_K && (color = DyeColor.getColor((ItemStack)player.func_184586_b(hand))) != null) {
            PneumaticCraftUtils.getTileEntityAt((IBlockReader)world, pos, TileEntityAphorismTile.class).ifPresent(teAT -> {
                if (this.clickedBorder(state, brtr.func_216347_e())) {
                    if (teAT.getBorderColor() != color.func_196059_a()) {
                        teAT.setBorderColor(color.func_196059_a());
                        if (PNCConfig.Common.General.useUpDyesWhenColoring) {
                            player.func_184586_b(hand).func_190918_g(1);
                        }
                    }
                } else if (teAT.getBackgroundColor() != color.func_196059_a()) {
                    teAT.setBackgroundColor(color.func_196059_a());
                    if (PNCConfig.Common.General.useUpDyesWhenColoring) {
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                }
            });
        }
        return ActionResultType.SUCCESS;
    }

    private boolean clickedBorder(BlockState state, Vector3d hitVec) {
        double x = Math.abs(hitVec.field_72450_a - (double)((int)hitVec.field_72450_a));
        double y = Math.abs(hitVec.field_72448_b - (double)((int)hitVec.field_72448_b));
        double z = Math.abs(hitVec.field_72449_c - (double)((int)hitVec.field_72449_c));
        switch (this.getRotation(state)) {
            case EAST: 
            case WEST: {
                return y < 0.1 || y > 0.9 || z < 0.1 || z > 0.9;
            }
            case NORTH: 
            case SOUTH: {
                return y < 0.1 || y > 0.9 || x < 0.1 || x > 0.9;
            }
            case UP: 
            case DOWN: {
                return x < 0.1 || x > 0.9 || z < 0.1 || z > 0.9;
            }
        }
        return false;
    }

    private void sendEditorMessage(PlayerEntity player) {
        IFormattableTextComponent msg = new StringTextComponent(TextFormatting.WHITE.toString()).func_230529_a_((ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.aphorismTileEditor")).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.holdF1forHelp"));
        player.func_146105_b((ITextComponent)msg, true);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    public boolean onWrenched(World world, PlayerEntity player, BlockPos pos, Direction face, Hand hand) {
        if (player != null && player.func_225608_bj_()) {
            return PneumaticCraftUtils.getTileEntityAt((IBlockReader)world, pos, TileEntityAphorismTile.class).map(teAt -> {
                if (++teAt.textRotation > 3) {
                    teAt.textRotation = 0;
                }
                teAt.sendDescriptionPacket();
                return true;
            }).orElse(false);
        }
        return super.onWrenched(world, player, pos, face, hand);
    }

    @Override
    protected boolean rotateForgeWay() {
        return false;
    }

    @Override
    public int getTintColor(BlockState state, @Nullable IBlockDisplayReader world, @Nullable BlockPos pos, int tintIndex) {
        if (world != null && pos != null) {
            return PneumaticCraftUtils.getTileEntityAt((IBlockReader)world, pos, TileEntityAphorismTile.class).map(teAt -> {
                switch (tintIndex) {
                    case 0: {
                        return DyeColor.func_196056_a((int)teAt.getBorderColor()).getColorValue();
                    }
                    case 1: {
                        return ColorHandlers.desaturate(DyeColor.func_196056_a((int)teAt.getBackgroundColor()).getColorValue());
                    }
                }
                return -1;
            }).orElse(-1);
        }
        return -1;
    }

    public static class ItemBlockAphorismTile
    extends BlockItem
    implements ColorHandlers.ITintableItem {
        public ItemBlockAphorismTile(BlockAphorismTile blockAphorismTile) {
            super((Block)blockAphorismTile, ModItems.defaultProps());
        }

        private static int getColor(ItemStack stack, String key, DyeColor fallback) {
            CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
            if (tag != null && tag.func_74764_b("ExtraData")) {
                return tag.func_74775_l("ExtraData").func_74762_e(key);
            }
            return fallback.func_196059_a();
        }

        @Override
        public int getTintColor(ItemStack stack, int tintIndex) {
            switch (tintIndex) {
                case 0: {
                    return DyeColor.func_196056_a((int)ItemBlockAphorismTile.getColor(stack, "borderColor", DyeColor.BLUE)).getColorValue();
                }
                case 1: {
                    return ColorHandlers.desaturate(DyeColor.func_196056_a((int)ItemBlockAphorismTile.getColor(stack, "backgroundColor", DyeColor.WHITE)).getColorValue());
                }
            }
            return 0xFFFFFF;
        }
    }
}

