/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.render.fluid.IFluidItemRenderInfoProvider;
import me.desht.pneumaticcraft.client.render.fluid.RenderFluidTank;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.capabilities.FluidItemWrapper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.IFluidRendered;
import me.desht.pneumaticcraft.common.tileentity.TileEntityFluidTank;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockFluidTank
extends BlockPneumaticCraft
implements ColorHandlers.ITintableBlock {
    private static final VoxelShape S1 = BlockFluidTank.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape S2 = BlockFluidTank.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)S1, (VoxelShape)S2, (IBooleanFunction)IBooleanFunction.field_223244_o_);
    private final Size size;

    public BlockFluidTank(Size size) {
        super(ModBlocks.defaultProps());
        this.size = size;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{UP, DOWN});
    }

    public Size getSize() {
        return this.size;
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return this.size.cls;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState state = super.func_196258_a(ctx);
        return state == null ? null : (BlockState)((BlockState)state.func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState up = worldIn.func_180495_p(currentPos.func_177984_a());
        if (((Boolean)stateIn.func_177229_b((Property)UP)).booleanValue() && !(up.func_177230_c() instanceof BlockFluidTank)) {
            stateIn = (BlockState)stateIn.func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false));
        }
        BlockState down = worldIn.func_180495_p(currentPos.func_177977_b());
        if (((Boolean)stateIn.func_177229_b((Property)DOWN)).booleanValue() && !(down.func_177230_c() instanceof BlockFluidTank)) {
            stateIn = (BlockState)stateIn.func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false));
        }
        return stateIn;
    }

    @Override
    public boolean onWrenched(World world, PlayerEntity player, BlockPos pos, Direction side, Hand hand) {
        if (!player.func_225608_bj_()) {
            TileEntityFluidTank te;
            BlockRayTraceResult brtr;
            RayTraceResult rtr = RayTraceUtils.getMouseOverServer((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
            if (rtr.func_216346_c() == RayTraceResult.Type.BLOCK && (brtr = (BlockRayTraceResult)rtr).func_216350_a().equals((Object)pos) && (te = this.getTankAt(world, pos)) != null) {
                double y = brtr.func_216347_e().field_72448_b - (double)((int)brtr.func_216347_e().field_72448_b);
                return this.tryToggleConnection(te, y >= 0.5 ? Direction.UP : Direction.DOWN);
            }
            return false;
        }
        return super.onWrenched(world, player, pos, side, hand);
    }

    private boolean tryToggleConnection(TileEntityFluidTank thisTank, Direction dir) {
        BlockState state = thisTank.func_195044_w();
        TileEntityFluidTank neighbourTank = this.getTankAt(thisTank.func_145831_w(), thisTank.func_174877_v().func_177972_a(dir));
        if (neighbourTank == null) {
            return false;
        }
        BlockState stateOther = neighbourTank.func_195044_w();
        boolean isConnected = (Boolean)state.func_177229_b((Property)BlockFluidTank.connectionProperty(dir));
        if (isConnected) {
            thisTank.func_145831_w().func_175656_a(thisTank.func_174877_v(), (BlockState)state.func_206870_a((Property)BlockFluidTank.connectionProperty(dir), (Comparable)Boolean.valueOf(false)));
            thisTank.func_145831_w().func_175656_a(neighbourTank.func_174877_v(), (BlockState)stateOther.func_206870_a((Property)BlockFluidTank.connectionProperty(dir.func_176734_d()), (Comparable)Boolean.valueOf(false)));
            return true;
        }
        FluidStack stack = thisTank.getTank().getFluid();
        if (neighbourTank.isFluidCompatible(stack, (IFluidTank)neighbourTank.getTank()) && neighbourTank.isNeighbourCompatible(stack, dir)) {
            thisTank.func_145831_w().func_175656_a(thisTank.func_174877_v(), (BlockState)state.func_206870_a((Property)BlockFluidTank.connectionProperty(dir), (Comparable)Boolean.valueOf(true)));
            thisTank.func_145831_w().func_175656_a(neighbourTank.func_174877_v(), (BlockState)stateOther.func_206870_a((Property)BlockFluidTank.connectionProperty(dir.func_176734_d()), (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    private TileEntityFluidTank getTankAt(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileEntityFluidTank ? (TileEntityFluidTank)te : null;
    }

    @Override
    public int getTintColor(BlockState state, @Nullable IBlockDisplayReader world, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 1) {
            return this.size.tintColor;
        }
        return -1;
    }

    public static enum Size {
        SMALL(32000, -7303024, TileEntityFluidTank.Small.class),
        MEDIUM(64000, -192, TileEntityFluidTank.Medium.class),
        LARGE(128000, -7214876, TileEntityFluidTank.Large.class),
        HUGE(512000, -10864304, TileEntityFluidTank.Huge.class);

        private final int capacity;
        private final int tintColor;
        private final Class<? extends TileEntityFluidTank> cls;

        private Size(int capacity, int tintColor, Class<? extends TileEntityFluidTank> cls) {
            this.capacity = capacity;
            this.tintColor = tintColor;
            this.cls = cls;
        }

        public int getCapacity() {
            return this.capacity;
        }
    }

    public static class ItemBlockFluidTank
    extends BlockItem
    implements ColorHandlers.ITintableItem,
    IFluidRendered {
        public static final String TANK_NAME = "Tank";
        private final int capacity;
        private RenderFluidTank.ItemRenderInfoProvider renderInfoProvider;

        public ItemBlockFluidTank(Block block) {
            super(block, ModItems.defaultProps());
            this.capacity = ((BlockFluidTank)block).size.capacity;
        }

        public boolean hasContainerItem(ItemStack stack) {
            return FluidUtil.getFluidContained((ItemStack)stack).map(f -> !f.isEmpty()).orElse(false);
        }

        public ItemStack getContainerItem(ItemStack itemStack) {
            boolean creative = UpgradableItemUtils.hasCreativeUpgrade(itemStack);
            return (ItemStack)FluidUtil.getFluidHandler((ItemStack)itemStack.func_77946_l()).map(handler -> {
                handler.drain(1000, creative ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                return handler.getContainer();
            }).orElseThrow(RuntimeException::new);
        }

        @Override
        public int getTintColor(ItemStack stack, int tintIndex) {
            if (tintIndex == 1 && stack.func_77973_b() instanceof ItemBlockFluidTank) {
                Block b = ((ItemBlockFluidTank)stack.func_77973_b()).func_179223_d();
                return ((BlockFluidTank)b).size.tintColor;
            }
            return -1;
        }

        @Override
        public IFluidItemRenderInfoProvider getFluidItemRenderer() {
            if (this.renderInfoProvider == null) {
                this.renderInfoProvider = new RenderFluidTank.ItemRenderInfoProvider();
            }
            return this.renderInfoProvider;
        }

        public int getItemStackLimit(ItemStack stack) {
            return stack.func_77942_o() && stack.func_77978_p().func_74764_b("BlockEntityTag") ? 1 : 64;
        }

        @Nullable
        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
            if (stack.func_77973_b() instanceof ItemBlockFluidTank) {
                return new FluidItemWrapper(stack, TANK_NAME, this.capacity);
            }
            return super.initCapabilities(stack, nbt);
        }
    }
}

