/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.heat.TemperatureCategory;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketBlockDestroyed;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class BlockPneumaticCraft
extends Block
implements IPneumaticWrenchable,
IUpgradeAcceptor {
    static final VoxelShape ALMOST_FULL_SHAPE = Block.func_208617_a((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5);
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty[] CONNECTION_PROPERTIES = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    public static final EnumProperty<TemperatureCategory> TEMPERATURE = EnumProperty.func_177709_a((String)"temperature", TemperatureCategory.class);

    protected BlockPneumaticCraft(AbstractBlock.Properties props) {
        super(props);
    }

    public boolean hasTileEntity(BlockState state) {
        return this.getTileEntityClass() != null;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        try {
            return this.getTileEntityClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract Class<? extends TileEntity> getTileEntityClass();

    @Override
    public String getUpgradeAcceptorTranslationKey() {
        return this.func_149739_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brtr) {
        ItemStack heldItem = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (player.func_225608_bj_() || !(te instanceof INamedContainerProvider) || this.isRotatable() && (heldItem.func_77973_b() == ModItems.MANOMETER.get() || ModdedWrenchUtils.getInstance().isModdedWrench(heldItem)) || hand == Hand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(player.func_184614_ca())) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K && te instanceof TileEntityBase) {
            if (FluidUtils.tryFluidInsertion(te, null, player, hand)) {
                world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
            if (FluidUtils.tryFluidExtraction(te, null, player, hand)) {
                world.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
            if (te instanceof INamedContainerProvider) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState state = super.func_196258_a(ctx);
        if (state != null) {
            for (Direction facing : DirectionUtil.VALUES) {
                if (!state.func_235901_b_((Property)BlockPneumaticCraft.connectionProperty(facing))) continue;
                TileEntity te = ctx.func_195991_k().func_175625_s(ctx.func_195995_a().func_177972_a(facing));
                boolean b = te != null && te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, facing.func_176734_d()).isPresent();
                state = (BlockState)state.func_206870_a((Property)BlockPneumaticCraft.connectionProperty(facing), (Comparable)Boolean.valueOf(b));
            }
            if (this.isRotatable()) {
                Direction f = this.canRotateToTopOrBottom() ? ctx.func_196010_d() : ctx.func_195992_f();
                state = (BlockState)state.func_206870_a((Property)this.directionProperty(), (Comparable)(this.reversePlacementRotation() ? f.func_176734_d() : f));
            }
        }
        return state;
    }

    protected boolean reversePlacementRotation() {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityBase && stack.func_82837_s()) {
            ((TileEntityBase)te).setCustomName(stack.func_200301_q());
        }
        if (te instanceof IHeatExchangingTE) {
            ((IHeatExchangingTE)te).initHeatExchangersOnPlacement(world, pos);
        }
    }

    public static BooleanProperty connectionProperty(Direction dir) {
        return CONNECTION_PROPERTIES[dir.func_176745_a()];
    }

    DirectionProperty directionProperty() {
        return this.canRotateToTopOrBottom() ? BlockStateProperties.field_208155_H : BlockStateProperties.field_208157_J;
    }

    protected Direction getRotation(IBlockReader world, BlockPos pos) {
        return this.getRotation(world.func_180495_p(pos));
    }

    public Direction getRotation(BlockState state) {
        return (Direction)state.func_177229_b((Property)this.directionProperty());
    }

    protected void setRotation(World world, BlockPos pos, Direction rotation) {
        this.setRotation(world, pos, rotation, world.func_180495_p(pos));
    }

    private void setRotation(World world, BlockPos pos, Direction rotation, BlockState state) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)this.directionProperty(), (Comparable)rotation));
    }

    public boolean isRotatable() {
        return false;
    }

    protected boolean canRotateToTopOrBottom() {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        if (this.isRotatable()) {
            builder.func_206894_a(new Property[]{this.directionProperty()});
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        if (this.isRotatable()) {
            state = (BlockState)state.func_206870_a((Property)this.directionProperty(), (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)this.directionProperty())));
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return this.isRotatable() ? state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)this.directionProperty()))) : state;
    }

    @Override
    public boolean onWrenched(World world, PlayerEntity player, BlockPos pos, Direction side, Hand hand) {
        if (player != null && player.func_225608_bj_()) {
            TileEntity te = world.func_175625_s(pos);
            boolean preserve = false;
            if (te instanceof TileEntityBase) {
                preserve = true;
                ((TileEntityBase)te).setPreserveStateOnBreak(true);
            }
            if (!player.func_184812_l_() || preserve) {
                Block.func_220059_a((BlockState)world.func_180495_p(pos), (IWorld)world, (BlockPos)pos, (TileEntity)te);
            }
            BlockPneumaticCraft.removeBlockSneakWrenched(world, pos);
            return true;
        }
        if (this.isRotatable()) {
            BlockState state = world.func_180495_p(pos);
            if (!this.rotateCustom(world, pos, state, side)) {
                TileEntity te;
                if (this.rotateForgeWay()) {
                    if (!this.canRotateToTopOrBottom()) {
                        side = Direction.UP;
                    }
                    if (this.getRotation((IBlockReader)world, pos).func_176740_k() != side.func_176740_k()) {
                        this.setRotation(world, pos, DirectionUtil.rotateAround(this.getRotation((IBlockReader)world, pos), side.func_176740_k()));
                    }
                } else {
                    Direction f = this.getRotation((IBlockReader)world, pos);
                    do {
                        f = Direction.func_82600_a((int)(f.func_176745_a() + 1));
                    } while (!this.canRotateToTopOrBottom() && f.func_176740_k() == Direction.Axis.Y);
                    this.setRotation(world, pos, f);
                }
                if ((te = world.func_175625_s(pos)) instanceof TileEntityBase) {
                    ((TileEntityBase)te).onBlockRotated();
                }
            }
            return true;
        }
        return false;
    }

    protected boolean rotateForgeWay() {
        return true;
    }

    protected boolean rotateCustom(World world, BlockPos pos, BlockState state, Direction side) {
        return false;
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos tilePos) {
        TileEntity te;
        if (world instanceof World && !((World)world).field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityBase) {
            ((TileEntityBase)te).onNeighborTileUpdate(tilePos);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityBase) {
            ((TileEntityBase)te).onNeighborBlockUpdate(fromPos);
        }
    }

    private int getSavedAir(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
        if (tag != null && tag.func_74764_b("AirAmount")) {
            return tag.func_74762_e("AirAmount");
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> curInfo, ITooltipFlag flag) {
        TileEntity te;
        if (stack.func_77942_o()) {
            CompoundNBT subTag;
            int savedAir = this.getSavedAir(stack);
            if (savedAir != 0) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.air", Integer.toString(savedAir)).func_240699_a_(TextFormatting.GREEN));
            }
            if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof IUpgradeAcceptor) {
                UpgradableItemUtils.addUpgradeInformation(stack, curInfo, flag);
            }
            if ((subTag = stack.func_179543_a("BlockEntityTag")) != null && subTag.func_150297_b("SavedTanks", 10)) {
                CompoundNBT tag = subTag.func_74775_l("SavedTanks");
                for (String s : tag.func_150296_c()) {
                    CompoundNBT tankTag = tag.func_74775_l(s);
                    FluidTank tank = new FluidTank(tankTag.func_74762_e("Amount"));
                    tank.readFromNBT(tankTag);
                    FluidStack fluidStack = tank.getFluid();
                    if (fluidStack.isEmpty()) continue;
                    curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.fluid", new Object[0]).func_240702_b_(fluidStack.getAmount() + "mB ").func_230529_a_(fluidStack.getDisplayName()).func_240699_a_(TextFormatting.GREEN));
                }
            }
            this.addExtraInformation(stack, world, curInfo, flag);
        }
        if (ClientUtils.hasShiftDown() && this.hasTileEntity(this.func_176223_P()) && (te = this.createTileEntity(this.func_176223_P(), world)) instanceof TileEntityPneumaticBase) {
            float pressure = ((TileEntityPneumaticBase)te).dangerPressure;
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxPressure", Float.valueOf(pressure)).func_240699_a_(TextFormatting.YELLOW));
        }
    }

    protected void addExtraInformation(ItemStack stack, IBlockReader world, List<ITextComponent> curInfo, ITooltipFlag flag) {
    }

    public boolean func_149740_M(BlockState state) {
        Class<? extends TileEntity> teClass = this.getTileEntityClass();
        return teClass != null && IComparatorSupport.class.isAssignableFrom(teClass);
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return ((IComparatorSupport)world.func_175625_s(pos)).getComparatorValue();
    }

    @Override
    public Map<EnumUpgrade, Integer> getApplicableUpgrades() {
        TileEntity te;
        if (this.hasTileEntity(this.func_176223_P()) && (te = this.createTileEntity(this.func_176223_P(), null)) instanceof IUpgradeAcceptor) {
            return ((IUpgradeAcceptor)te).getApplicableUpgrades();
        }
        return Collections.emptyMap();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityBase) {
                NonNullList drops = NonNullList.func_191196_a();
                ((TileEntityBase)te).getContentsToDrop((NonNullList<ItemStack>)drops);
                drops.forEach(stack -> PneumaticCraftUtils.dropItemOnGround(stack, world, pos));
                if (!((TileEntityBase)te).shouldPreserveStateOnBreak()) {
                    te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(handler -> {
                        if (handler.getAir() > 0) {
                            NetworkHandler.sendToAllTracking(new PacketSpawnParticle(AirParticleData.DENSE, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0, 0.0, 0.0, (int)(5.0f * handler.getPressure()), 1.0, 1.0, 1.0), world, pos);
                            world.func_184133_a(null, pos, (SoundEvent)ModSounds.SHORT_HISS.get(), SoundCategory.BLOCKS, 0.3f, 0.8f);
                        }
                    });
                }
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        TileEntity ourTE;
        if (stateIn.func_235901_b_((Property)BlockPneumaticCraft.connectionProperty(facing)) && (ourTE = worldIn.func_175625_s(currentPos)) != null && ourTE.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, facing).isPresent()) {
            TileEntity te = worldIn.func_175625_s(currentPos.func_177972_a(facing));
            boolean b = te != null && te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, facing.func_176734_d()).isPresent();
            stateIn = (BlockState)stateIn.func_206870_a((Property)BlockPneumaticCraft.connectionProperty(facing), (Comparable)Boolean.valueOf(b));
            return stateIn;
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return this.func_220071_b(state, worldIn, pos, ISelectionContext.func_216377_a()).func_197766_b();
    }

    static void removeBlockSneakWrenched(World world, BlockPos pos) {
        if (!world.func_201670_d()) {
            world.func_217377_a(pos, false);
            NetworkHandler.sendToAllTracking(new PacketBlockDestroyed(pos), world, pos);
        }
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (player instanceof ServerPlayerEntity && !(player instanceof FakePlayer) && te instanceof TileEntityBase && !((TileEntityBase)te).shouldPreserveStateOnBreak()) {
            AdvancementTriggers.MACHINE_VANDAL.trigger((ServerPlayerEntity)player);
        }
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }
}

