/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySmartChest;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockSmartChest
extends BlockPneumaticCraft {
    private static final VoxelShape SHAPE = BlockSmartChest.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public BlockSmartChest() {
        super(ModBlocks.reinforcedStoneProps());
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntitySmartChest.class;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean reversePlacementRotation() {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public static class ItemBlockBlockSmartChest
    extends BlockItem
    implements IInventoryItem {
        public ItemBlockBlockSmartChest(Block block) {
            super(block, ModItems.defaultProps());
        }

        @Override
        public void getStacksInItem(ItemStack stack, List<ItemStack> curStacks) {
            IInventoryItem.getStacks(stack, curStacks);
        }

        @Override
        public String getTooltipPrefix(ItemStack stack) {
            return TextFormatting.GREEN.toString();
        }

        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
            CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
            if (tag != null && tag.func_74764_b("Items")) {
                int lastSlot;
                CompoundNBT subTag = tag.func_74775_l("Items");
                ListNBT l = subTag.func_150295_c("Filter", 10);
                if (!l.isEmpty()) {
                    tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.smartChest.filter", l.size()));
                }
                if ((lastSlot = subTag.func_74762_e("LastSlot")) < 72) {
                    tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.smartChest.slotsClosed", 72 - lastSlot));
                }
            }
        }
    }
}

