/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.Random;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockWallLamp
extends BlockPneumaticCraft
implements ColorHandlers.ITintableBlock {
    private static final VoxelShape BASE1 = BlockWallLamp.func_208617_a((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)1.0, (double)14.0);
    private static final VoxelShape BASE2 = BlockWallLamp.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)1.0, (double)13.0);
    private static final VoxelShape BASE3 = BlockWallLamp.func_208617_a((double)4.0, (double)1.0, (double)3.0, (double)12.0, (double)2.0, (double)13.0);
    private static final VoxelShape BASE4 = BlockWallLamp.func_208617_a((double)3.0, (double)1.0, (double)4.0, (double)13.0, (double)2.0, (double)12.0);
    private static final VoxelShape SHAPE_UP = VoxelShapes.func_216384_a((VoxelShape)BASE1, (VoxelShape[])new VoxelShape[]{BASE2, BASE3, BASE4});
    private static final VoxelShape SHAPE_NORTH = VoxelShapeUtils.rotateX(SHAPE_UP, 270);
    private static final VoxelShape SHAPE_DOWN = VoxelShapeUtils.rotateX(SHAPE_NORTH, 270);
    private static final VoxelShape SHAPE_SOUTH = VoxelShapeUtils.rotateX(SHAPE_UP, 90);
    private static final VoxelShape SHAPE_WEST = VoxelShapeUtils.rotateY(SHAPE_NORTH, 270);
    private static final VoxelShape SHAPE_EAST = VoxelShapeUtils.rotateY(SHAPE_NORTH, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_DOWN, SHAPE_UP, SHAPE_NORTH, SHAPE_SOUTH, SHAPE_WEST, SHAPE_EAST};
    private static final int[] DARKENED = new int[DyeColor.values().length];
    private final DyeColor color;
    private final boolean inverted;

    public BlockWallLamp(DyeColor color, boolean inverted) {
        super(ModBlocks.defaultProps().func_235838_a_(BlockWallLamp.getLightValue()));
        this.color = color;
        this.inverted = inverted;
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(inverted)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208190_q});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b((Property)this.directionProperty())).func_176745_a()];
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue() && !this.shouldLight((World)worldIn, pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)BlockStateProperties.field_208190_q), 2);
        }
    }

    @Override
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean isLit;
        if (!worldIn.field_72995_K && (isLit = ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue()) != this.shouldLight(worldIn, pos)) {
            if (isLit) {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            } else {
                worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)BlockStateProperties.field_208190_q), 2);
            }
        }
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)this.directionProperty(), (Comparable)context.func_196000_l())).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.shouldLight(context.func_195991_k(), context.func_195995_a())));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.getRotation(stateIn).func_176734_d() == facing && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return HorizontalFaceBlock.func_220185_b((IWorldReader)worldIn, (BlockPos)pos, (Direction)this.getRotation(state).func_176734_d());
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return null;
    }

    @Override
    public int getTintColor(BlockState state, @Nullable IBlockDisplayReader world, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 1 && state != null) {
            return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? this.color.getColorValue() : DARKENED[this.color.ordinal()];
        }
        return -1;
    }

    private boolean shouldLight(World world, BlockPos pos) {
        return this.inverted != world.func_175640_z(pos);
    }

    private static ToIntFunction<BlockState> getLightValue() {
        return state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? 15 : 0;
    }

    static {
        for (DyeColor c : DyeColor.values()) {
            TintColor tc = new TintColor(c.getColorValue()).darker();
            BlockWallLamp.DARKENED[c.func_196059_a()] = tc.getRGB();
        }
    }

    public static class ItemWallLamp
    extends BlockItem
    implements ICustomTooltipName {
        public ItemWallLamp(BlockWallLamp blockWallLamp) {
            super((Block)blockWallLamp, ModItems.defaultProps());
        }

        @Override
        public String getCustomTooltipTranslationKey() {
            if (this.func_179223_d() instanceof BlockWallLamp) {
                return ((BlockWallLamp)this.func_179223_d()).inverted ? "block.pneumaticcraft.wall_lamp_inverted" : "block.pneumaticcraft.wall_lamp";
            }
            return "block.pneumaticcraft.wall_lamp";
        }
    }
}

