/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.entity.semiblock.EntitySemiblockBase;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureBlock;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.tileentity.RangeManager;
import me.desht.pneumaticcraft.common.tileentity.TileEntityHeatSink;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class ModuleAirGrate
extends TubeModule {
    private int grateRange;
    private boolean vacuum;
    private final Set<TileEntityHeatSink> heatSinks = new HashSet<TileEntityHeatSink>();
    private boolean showRange;
    private EntityFilter entityFilter = null;
    private TileEntity adjacentInsertionTE = null;
    private Direction adjacentInsertionSide;
    private final Map<BlockPos, Boolean> traceabilityCache = new HashMap<BlockPos, Boolean>();

    public ModuleAirGrate(ItemTubeModule itemTubeModule) {
        super(itemTubeModule);
    }

    @Override
    public double getWidth() {
        return 16.0;
    }

    @Override
    public void update() {
        super.update();
        World world = this.pressureTube.func_145831_w();
        BlockPos pos = this.pressureTube.func_174877_v();
        if ((world.func_82737_E() & 0x1FL) == 0L) {
            this.traceabilityCache.clear();
        }
        int oldGrateRange = this.grateRange;
        this.grateRange = this.calculateRange();
        if (oldGrateRange != this.grateRange) {
            if (!world.field_72995_K) {
                this.getTube().getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(h -> NetworkHandler.sendToAllTracking((Object)new PacketUpdatePressureBlock(this.getTube(), null, h.getSideLeaking(), h.getAir()), this.getTube()));
            } else if (this.showRange) {
                AreaRenderManager.getInstance().showArea(RangeManager.getFrame(this.getAffectedAABB()), 1627373664, this.pressureTube, false);
            }
        }
        if (!world.field_72995_K) {
            this.coolHeatSinks();
        }
        this.pushEntities(world, pos, new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5));
    }

    private AxisAlignedBB getAffectedAABB() {
        BlockPos pos = this.pressureTube.func_174877_v().func_177967_a(this.getDirection(), this.grateRange + 1);
        return new AxisAlignedBB(pos, pos).func_186662_g((double)this.grateRange);
    }

    private int calculateRange() {
        float range = this.pressureTube.getPressure() * 4.0f;
        boolean bl = this.vacuum = range < 0.0f;
        if (this.vacuum) {
            range *= -4.0f;
        }
        return (int)range;
    }

    private void pushEntities(World world, BlockPos pos, Vector3d tileVec) {
        AxisAlignedBB bbBox = this.getAffectedAABB();
        List entities = world.func_175647_a(Entity.class, bbBox, (Predicate)this.entityFilter);
        double d0 = this.grateRange * 3;
        int entitiesMoved = 0;
        for (Entity entity : entities) {
            double z;
            double d4;
            double d5;
            if (!entity.field_70170_p.field_72995_K && entity instanceof ItemEntity && entity.func_70089_S() && entity.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < 1.0) {
                this.tryItemInsertion((ItemEntity)entity);
                continue;
            }
            if (this.ignoreEntity(entity) || !this.rayTraceOK(entity, tileVec)) continue;
            double x = (entity.func_226277_ct_() - (double)pos.func_177958_n() - 0.5) / d0;
            double y = (entity.func_226278_cu_() + (double)entity.func_70047_e() - (double)pos.func_177956_o() - 0.5) / d0;
            BlockPos entityPos = entity.func_233580_cy_();
            if (!Block.func_220055_a((IWorldReader)world, (BlockPos)entityPos, (Direction)Direction.UP) && !world.func_175623_d(entityPos)) {
                y -= 0.15;
            }
            if (!((d5 = 1.0 - (d4 = Math.sqrt(x * x + y * y + (z = (entity.func_226281_cx_() - (double)pos.func_177952_p() - 0.5) / d0) * z))) > 0.0)) continue;
            d5 *= d5;
            if (this.vacuum) {
                d5 *= -1.0;
            }
            entity.func_213315_a(MoverType.SELF, new Vector3d(x * d5, y * d5, z * d5));
            ++entitiesMoved;
            if (!world.field_72995_K || !(world.field_73012_v.nextDouble() < 0.2)) continue;
            if (this.vacuum) {
                world.func_195594_a((IParticleData)AirParticleData.DENSE, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), -x, -y, -z);
                continue;
            }
            world.func_195594_a((IParticleData)AirParticleData.DENSE, (double)pos.func_177958_n() + 0.5 + (double)this.getDirection().func_82601_c(), (double)pos.func_177956_o() + 0.5 + (double)this.getDirection().func_96559_d(), (double)pos.func_177952_p() + 0.5 + (double)this.getDirection().func_82599_e(), x, y, z);
        }
        if (!world.field_72995_K) {
            this.pressureTube.addAir(-entitiesMoved * 2);
        }
    }

    private boolean ignoreEntity(Entity entity) {
        if (entity instanceof PlayerEntity) {
            return ((PlayerEntity)entity).func_184812_l_() || entity.func_225608_bj_() || entity.func_175149_v();
        }
        return !entity.func_70104_M() || entity instanceof EntitySemiblockBase;
    }

    private boolean rayTraceOK(Entity entity, Vector3d tileVec) {
        BlockPos pos = new BlockPos(entity.func_174824_e(0.0f));
        return this.traceabilityCache.computeIfAbsent(pos, k -> {
            Vector3d entityVec = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
            RayTraceContext ctx = new RayTraceContext(entityVec, tileVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity);
            BlockRayTraceResult trace = entity.func_130014_f_().func_217299_a(ctx);
            return trace.func_216350_a().equals((Object)this.pressureTube.func_174877_v());
        });
    }

    private void tryItemInsertion(ItemEntity entity) {
        if (this.getAdjacentInventory() != null) {
            ItemStack stack = entity.func_92059_d();
            ItemStack excess = IOHelper.insert(this.getAdjacentInventory(), stack, this.adjacentInsertionSide, false);
            if (excess.func_190926_b()) {
                entity.func_70106_y();
            } else {
                entity.func_92058_a(excess);
            }
        }
    }

    private TileEntity getAdjacentInventory() {
        if (this.adjacentInsertionTE != null && !this.adjacentInsertionTE.func_145837_r()) {
            return this.adjacentInsertionTE;
        }
        this.adjacentInsertionTE = null;
        for (Direction dir : DirectionUtil.VALUES) {
            TileEntity inv = this.pressureTube.func_145831_w().func_175625_s(this.pressureTube.func_174877_v().func_177972_a(dir));
            if (inv == null || !inv.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()).isPresent()) continue;
            this.adjacentInsertionTE = inv;
            this.adjacentInsertionSide = dir.func_176734_d();
            break;
        }
        return this.adjacentInsertionTE;
    }

    private void coolHeatSinks() {
        if (this.grateRange >= 2) {
            int curTeIndex = (int)(this.pressureTube.func_145831_w().func_82737_E() % 27L);
            BlockPos curPos = this.pressureTube.func_174877_v().func_177967_a(this.dir, 2).func_177982_a(-1 + curTeIndex % 3, -1 + curTeIndex / 3 % 3, -1 + curTeIndex / 9 % 3);
            TileEntity te = this.pressureTube.func_145831_w().func_175625_s(curPos);
            if (te instanceof TileEntityHeatSink) {
                this.heatSinks.add((TileEntityHeatSink)te);
            }
            Iterator<TileEntityHeatSink> iterator = this.heatSinks.iterator();
            int tubesCooled = 0;
            while (iterator.hasNext()) {
                TileEntityHeatSink heatSink = iterator.next();
                if (heatSink.func_145837_r()) {
                    iterator.remove();
                    continue;
                }
                for (int i = 0; i < 4; ++i) {
                    heatSink.onFannedByAirGrate();
                }
                ++tubesCooled;
            }
            if (tubesCooled > 0) {
                this.pressureTube.addAir(-(5 + tubesCooled / 3));
            }
        }
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.vacuum = tag.func_74767_n("vacuum");
        this.grateRange = tag.func_74762_e("grateRange");
        String f = tag.func_74779_i("entityFilter");
        this.entityFilter = f.isEmpty() ? null : EntityFilter.fromString(f);
    }

    @Override
    public CompoundNBT writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("vacuum", this.vacuum);
        tag.func_74768_a("grateRange", this.grateRange);
        tag.func_74778_a("entityFilter", this.entityFilter == null ? "" : this.entityFilter.toString());
        return tag;
    }

    @Override
    public void addInfo(List<ITextComponent> curInfo) {
        super.addInfo(curInfo);
        String txt = this.grateRange == 0 ? "Idle" : (this.vacuum ? "Attracting" : "Repelling");
        curInfo.add((ITextComponent)new StringTextComponent("Status: ").func_240702_b_(txt).func_240699_a_(TextFormatting.WHITE));
        curInfo.add((ITextComponent)new StringTextComponent("Range: ").func_240702_b_(this.grateRange + " blocks").func_240699_a_(TextFormatting.WHITE));
        if (this.entityFilter != null) {
            curInfo.add((ITextComponent)new StringTextComponent("Entity Filter: \"").func_240702_b_(this.entityFilter.toString()).func_240702_b_("\"").func_240699_a_(TextFormatting.WHITE));
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.pressureTube.func_174877_v().func_177967_a(this.getDirection(), this.grateRange + 1)).func_186662_g((double)(this.grateRange * 2));
    }

    public String getEntityFilterString() {
        return this.entityFilter == null ? "" : this.entityFilter.toString();
    }

    public void setEntityFilter(String filter) {
        this.entityFilter = EntityFilter.fromString(filter);
    }

    @Override
    public void onPlaced() {
    }

    public boolean isShowRange() {
        return this.showRange;
    }

    public void setShowRange(boolean showRange) {
        this.showRange = showRange;
        if (showRange) {
            AreaRenderManager.getInstance().showArea(RangeManager.getFrame(this.getAffectedAABB()), 1627373664, this.pressureTube, false);
        } else {
            AreaRenderManager.getInstance().removeHandlers(this.pressureTube);
        }
    }

    @Override
    public void onRemoved() {
        if (this.pressureTube.func_145831_w().field_72995_K) {
            AreaRenderManager.getInstance().removeHandlers(this.pressureTube);
        }
    }
}

