/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.BlockAdvancedAirCompressor;
import me.desht.pneumaticcraft.common.block.BlockAdvancedLiquidCompressor;
import me.desht.pneumaticcraft.common.block.BlockAerialInterface;
import me.desht.pneumaticcraft.common.block.BlockAirCannon;
import me.desht.pneumaticcraft.common.block.BlockAirCompressor;
import me.desht.pneumaticcraft.common.block.BlockAphorismTile;
import me.desht.pneumaticcraft.common.block.BlockAssemblyController;
import me.desht.pneumaticcraft.common.block.BlockAssemblyDrill;
import me.desht.pneumaticcraft.common.block.BlockAssemblyIOUnit;
import me.desht.pneumaticcraft.common.block.BlockAssemblyLaser;
import me.desht.pneumaticcraft.common.block.BlockAssemblyPlatform;
import me.desht.pneumaticcraft.common.block.BlockChargingStation;
import me.desht.pneumaticcraft.common.block.BlockCompressedIron;
import me.desht.pneumaticcraft.common.block.BlockCreativeCompressor;
import me.desht.pneumaticcraft.common.block.BlockDisplayTable;
import me.desht.pneumaticcraft.common.block.BlockDrillPipe;
import me.desht.pneumaticcraft.common.block.BlockDroneRedstoneEmitter;
import me.desht.pneumaticcraft.common.block.BlockElectrostaticCompressor;
import me.desht.pneumaticcraft.common.block.BlockElevatorBase;
import me.desht.pneumaticcraft.common.block.BlockElevatorCaller;
import me.desht.pneumaticcraft.common.block.BlockElevatorFrame;
import me.desht.pneumaticcraft.common.block.BlockEmptySpawner;
import me.desht.pneumaticcraft.common.block.BlockEtchingTank;
import me.desht.pneumaticcraft.common.block.BlockFluidEtchingAcid;
import me.desht.pneumaticcraft.common.block.BlockFluidMixer;
import me.desht.pneumaticcraft.common.block.BlockFluidTank;
import me.desht.pneumaticcraft.common.block.BlockFluxCompressor;
import me.desht.pneumaticcraft.common.block.BlockGasLift;
import me.desht.pneumaticcraft.common.block.BlockHeatPipe;
import me.desht.pneumaticcraft.common.block.BlockHeatSink;
import me.desht.pneumaticcraft.common.block.BlockKeroseneLamp;
import me.desht.pneumaticcraft.common.block.BlockKeroseneLampLight;
import me.desht.pneumaticcraft.common.block.BlockLiquidCompressor;
import me.desht.pneumaticcraft.common.block.BlockLiquidHopper;
import me.desht.pneumaticcraft.common.block.BlockOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.block.BlockPlasticBrick;
import me.desht.pneumaticcraft.common.block.BlockPneumaticDoor;
import me.desht.pneumaticcraft.common.block.BlockPneumaticDoorBase;
import me.desht.pneumaticcraft.common.block.BlockPneumaticDynamo;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberGlass;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberInterface;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberValve;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberWall;
import me.desht.pneumaticcraft.common.block.BlockPressureTube;
import me.desht.pneumaticcraft.common.block.BlockPressurizedSpawner;
import me.desht.pneumaticcraft.common.block.BlockProgrammableController;
import me.desht.pneumaticcraft.common.block.BlockProgrammer;
import me.desht.pneumaticcraft.common.block.BlockRefineryController;
import me.desht.pneumaticcraft.common.block.BlockRefineryOutput;
import me.desht.pneumaticcraft.common.block.BlockReinforcedChest;
import me.desht.pneumaticcraft.common.block.BlockSecurityStation;
import me.desht.pneumaticcraft.common.block.BlockSentryTurret;
import me.desht.pneumaticcraft.common.block.BlockSmartChest;
import me.desht.pneumaticcraft.common.block.BlockSpawnerExtractor;
import me.desht.pneumaticcraft.common.block.BlockTagWorkbench;
import me.desht.pneumaticcraft.common.block.BlockThermalCompressor;
import me.desht.pneumaticcraft.common.block.BlockThermalLagging;
import me.desht.pneumaticcraft.common.block.BlockThermopneumaticProcessingPlant;
import me.desht.pneumaticcraft.common.block.BlockUVLightBox;
import me.desht.pneumaticcraft.common.block.BlockUniversalSensor;
import me.desht.pneumaticcraft.common.block.BlockVacuumPump;
import me.desht.pneumaticcraft.common.block.BlockVacuumTrap;
import me.desht.pneumaticcraft.common.block.BlockVortexTube;
import me.desht.pneumaticcraft.common.block.BlockWallLamp;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.BlockDroneInterface;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"pneumaticcraft");
    public static final DeferredRegister<Item> ITEMS = ModItems.ITEMS;
    public static final RegistryObject<BlockPressureTube> PRESSURE_TUBE = ModBlocks.register("pressure_tube", () -> new BlockPressureTube(BlockPressureTube.Tier.ONE));
    public static final RegistryObject<BlockPressureTube> ADVANCED_PRESSURE_TUBE = ModBlocks.register("advanced_pressure_tube", () -> new BlockPressureTube(BlockPressureTube.Tier.TWO));
    public static final RegistryObject<BlockAirCannon> AIR_CANNON = ModBlocks.register("air_cannon", BlockAirCannon::new);
    public static final RegistryObject<BlockPressureChamberWall> PRESSURE_CHAMBER_WALL = ModBlocks.register("pressure_chamber_wall", BlockPressureChamberWall::new);
    public static final RegistryObject<BlockPressureChamberGlass> PRESSURE_CHAMBER_GLASS = ModBlocks.register("pressure_chamber_glass", BlockPressureChamberGlass::new);
    public static final RegistryObject<BlockPressureChamberValve> PRESSURE_CHAMBER_VALVE = ModBlocks.register("pressure_chamber_valve", BlockPressureChamberValve::new);
    public static final RegistryObject<BlockPressureChamberInterface> PRESSURE_CHAMBER_INTERFACE = ModBlocks.register("pressure_chamber_interface", BlockPressureChamberInterface::new);
    public static final RegistryObject<BlockChargingStation> CHARGING_STATION = ModBlocks.register("charging_station", BlockChargingStation::new);
    public static final RegistryObject<BlockDrillPipe> DRILL_PIPE = ModBlocks.register("drill_pipe", BlockDrillPipe::new);
    public static final RegistryObject<BlockElevatorBase> ELEVATOR_BASE = ModBlocks.register("elevator_base", BlockElevatorBase::new);
    public static final RegistryObject<BlockElevatorFrame> ELEVATOR_FRAME = ModBlocks.register("elevator_frame", BlockElevatorFrame::new);
    public static final RegistryObject<BlockVacuumPump> VACUUM_PUMP = ModBlocks.register("vacuum_pump", BlockVacuumPump::new);
    public static final RegistryObject<BlockPneumaticDoorBase> PNEUMATIC_DOOR_BASE = ModBlocks.register("pneumatic_door_base", BlockPneumaticDoorBase::new);
    public static final RegistryObject<BlockPneumaticDoor> PNEUMATIC_DOOR = ModBlocks.register("pneumatic_door", BlockPneumaticDoor::new, block -> () -> new BlockPneumaticDoor.ItemBlockPneumaticDoor((Block)block.get()));
    public static final RegistryObject<BlockAssemblyPlatform> ASSEMBLY_PLATFORM = ModBlocks.register("assembly_platform", BlockAssemblyPlatform::new);
    public static final RegistryObject<BlockAssemblyIOUnit> ASSEMBLY_IO_UNIT_IMPORT = ModBlocks.register("assembly_io_unit_import", () -> new BlockAssemblyIOUnit.Import(ModBlocks.defaultProps()));
    public static final RegistryObject<BlockAssemblyIOUnit> ASSEMBLY_IO_UNIT_EXPORT = ModBlocks.register("assembly_io_unit_export", () -> new BlockAssemblyIOUnit.Export(ModBlocks.defaultProps()));
    public static final RegistryObject<BlockAssemblyDrill> ASSEMBLY_DRILL = ModBlocks.register("assembly_drill", BlockAssemblyDrill::new);
    public static final RegistryObject<BlockAssemblyLaser> ASSEMBLY_LASER = ModBlocks.register("assembly_laser", BlockAssemblyLaser::new);
    public static final RegistryObject<BlockAssemblyController> ASSEMBLY_CONTROLLER = ModBlocks.register("assembly_controller", BlockAssemblyController::new);
    public static final RegistryObject<BlockCompressedIron> COMPRESSED_IRON_BLOCK = ModBlocks.register("compressed_iron_block", BlockCompressedIron::new);
    public static final RegistryObject<BlockUVLightBox> UV_LIGHT_BOX = ModBlocks.register("uv_light_box", BlockUVLightBox::new);
    public static final RegistryObject<BlockSecurityStation> SECURITY_STATION = ModBlocks.register("security_station", BlockSecurityStation::new);
    public static final RegistryObject<BlockUniversalSensor> UNIVERSAL_SENSOR = ModBlocks.register("universal_sensor", BlockUniversalSensor::new);
    public static final RegistryObject<BlockAerialInterface> AERIAL_INTERFACE = ModBlocks.register("aerial_interface", BlockAerialInterface::new);
    public static final RegistryObject<BlockElectrostaticCompressor> ELECTROSTATIC_COMPRESSOR = ModBlocks.register("electrostatic_compressor", BlockElectrostaticCompressor::new);
    public static final RegistryObject<BlockAphorismTile> APHORISM_TILE = ModBlocks.register("aphorism_tile", BlockAphorismTile::new, block -> () -> new BlockAphorismTile.ItemBlockAphorismTile((BlockAphorismTile)block.get()));
    public static final RegistryObject<BlockOmnidirectionalHopper> OMNIDIRECTIONAL_HOPPER = ModBlocks.register("omnidirectional_hopper", BlockOmnidirectionalHopper::new, block -> () -> new BlockOmnidirectionalHopper.ItemBlockOmnidirectionalHopper((Block)block.get()));
    public static final RegistryObject<BlockElevatorCaller> ELEVATOR_CALLER = ModBlocks.register("elevator_caller", BlockElevatorCaller::new);
    public static final RegistryObject<BlockProgrammer> PROGRAMMER = ModBlocks.register("programmer", BlockProgrammer::new);
    public static final RegistryObject<BlockCreativeCompressor> CREATIVE_COMPRESSOR = ModBlocks.register("creative_compressor", BlockCreativeCompressor::new, block -> () -> new BlockCreativeCompressor.ItemBlockCreativeCompressor((Block)block.get()));
    public static final RegistryObject<BlockLiquidCompressor> LIQUID_COMPRESSOR = ModBlocks.register("liquid_compressor", BlockLiquidCompressor::new);
    public static final RegistryObject<BlockAdvancedLiquidCompressor> ADVANCED_LIQUID_COMPRESSOR = ModBlocks.register("advanced_liquid_compressor", BlockAdvancedLiquidCompressor::new);
    public static final RegistryObject<BlockAirCompressor> AIR_COMPRESSOR = ModBlocks.register("air_compressor", BlockAirCompressor::new);
    public static final RegistryObject<BlockAdvancedAirCompressor> ADVANCED_AIR_COMPRESSOR = ModBlocks.register("advanced_air_compressor", BlockAdvancedAirCompressor::new);
    public static final RegistryObject<BlockLiquidHopper> LIQUID_HOPPER = ModBlocks.register("liquid_hopper", BlockLiquidHopper::new, block -> () -> new BlockLiquidHopper.ItemBlockLiquidHopper((Block)block.get()));
    public static final RegistryObject<BlockDroneRedstoneEmitter> DRONE_REDSTONE_EMITTER = ModBlocks.registerNoItem("drone_redstone_emitter", BlockDroneRedstoneEmitter::new);
    public static final RegistryObject<BlockHeatSink> HEAT_SINK = ModBlocks.register("heat_sink", BlockHeatSink::new);
    public static final RegistryObject<BlockVortexTube> VORTEX_TUBE = ModBlocks.register("vortex_tube", BlockVortexTube::new);
    public static final RegistryObject<BlockProgrammableController> PROGRAMMABLE_CONTROLLER = ModBlocks.register("programmable_controller", BlockProgrammableController::new);
    public static final RegistryObject<BlockGasLift> GAS_LIFT = ModBlocks.register("gas_lift", BlockGasLift::new);
    public static final RegistryObject<BlockRefineryController> REFINERY = ModBlocks.register("refinery", BlockRefineryController::new);
    public static final RegistryObject<BlockRefineryOutput> REFINERY_OUTPUT = ModBlocks.register("refinery_output", BlockRefineryOutput::new);
    public static final RegistryObject<BlockThermopneumaticProcessingPlant> THERMOPNEUMATIC_PROCESSING_PLANT = ModBlocks.register("thermopneumatic_processing_plant", BlockThermopneumaticProcessingPlant::new);
    public static final RegistryObject<BlockKeroseneLamp> KEROSENE_LAMP = ModBlocks.register("kerosene_lamp", BlockKeroseneLamp::new, block -> () -> new BlockKeroseneLamp.ItemBlockKeroseneLamp((Block)block.get()));
    public static final RegistryObject<BlockKeroseneLampLight> KEROSENE_LAMP_LIGHT = ModBlocks.registerNoItem("kerosene_lamp_light", BlockKeroseneLampLight::new);
    public static final RegistryObject<BlockSentryTurret> SENTRY_TURRET = ModBlocks.register("sentry_turret", BlockSentryTurret::new);
    public static final RegistryObject<BlockFluxCompressor> FLUX_COMPRESSOR = ModBlocks.register("flux_compressor", BlockFluxCompressor::new);
    public static final RegistryObject<BlockPneumaticDynamo> PNEUMATIC_DYNAMO = ModBlocks.register("pneumatic_dynamo", BlockPneumaticDynamo::new);
    public static final RegistryObject<BlockThermalCompressor> THERMAL_COMPRESSOR = ModBlocks.register("thermal_compressor", BlockThermalCompressor::new);
    public static final RegistryObject<BlockHeatPipe> HEAT_PIPE = ModBlocks.register("heat_pipe", BlockHeatPipe::new);
    public static final RegistryObject<BlockEtchingTank> ETCHING_TANK = ModBlocks.register("etching_tank", BlockEtchingTank::new);
    public static final RegistryObject<BlockFluidTank> TANK_SMALL = ModBlocks.register("small_tank", () -> new BlockFluidTank(BlockFluidTank.Size.SMALL), block -> () -> new BlockFluidTank.ItemBlockFluidTank((Block)block.get()));
    public static final RegistryObject<BlockFluidTank> TANK_MEDIUM = ModBlocks.register("medium_tank", () -> new BlockFluidTank(BlockFluidTank.Size.MEDIUM), block -> () -> new BlockFluidTank.ItemBlockFluidTank((Block)block.get()));
    public static final RegistryObject<BlockFluidTank> TANK_LARGE = ModBlocks.register("large_tank", () -> new BlockFluidTank(BlockFluidTank.Size.LARGE), block -> () -> new BlockFluidTank.ItemBlockFluidTank((Block)block.get()));
    public static final RegistryObject<BlockFluidTank> TANK_HUGE = ModBlocks.register("huge_tank", () -> new BlockFluidTank(BlockFluidTank.Size.HUGE), block -> () -> new BlockFluidTank.ItemBlockFluidTank((Block)block.get()));
    public static final RegistryObject<BlockReinforcedChest> REINFORCED_CHEST = ModBlocks.register("reinforced_chest", BlockReinforcedChest::new, block -> () -> new BlockReinforcedChest.ItemBlockReinforcedChest((BlockReinforcedChest)block.get()));
    public static final RegistryObject<BlockSmartChest> SMART_CHEST = ModBlocks.register("smart_chest", BlockSmartChest::new, block -> () -> new BlockSmartChest.ItemBlockBlockSmartChest((Block)block.get()));
    public static final RegistryObject<BlockTagWorkbench> TAG_WORKBENCH = ModBlocks.register("tag_workbench", BlockTagWorkbench::new);
    public static final RegistryObject<BlockDisplayTable> DISPLAY_TABLE = ModBlocks.register("display_table", BlockDisplayTable::new);
    public static final RegistryObject<BlockDroneInterface> DRONE_INTERFACE = ModBlocks.register("drone_interface", BlockDroneInterface::new);
    public static final RegistryObject<BlockThermalLagging> THERMAL_LAGGING = ModBlocks.register("thermal_lagging", BlockThermalLagging::new);
    public static final RegistryObject<BlockFluidMixer> FLUID_MIXER = ModBlocks.register("fluid_mixer", BlockFluidMixer::new);
    public static final RegistryObject<BlockVacuumTrap> VACUUM_TRAP = ModBlocks.register("vacuum_trap", BlockVacuumTrap::new, block -> () -> new BlockVacuumTrap.ItemBlockVacuumTrap((BlockVacuumTrap)block.get()));
    public static final RegistryObject<BlockSpawnerExtractor> SPAWNER_EXTRACTOR = ModBlocks.register("spawner_extractor", BlockSpawnerExtractor::new);
    public static final RegistryObject<BlockEmptySpawner> EMPTY_SPAWNER = ModBlocks.register("empty_spawner", BlockEmptySpawner::new);
    public static final RegistryObject<BlockPressurizedSpawner> PRESSURIZED_SPAWNER = ModBlocks.register("pressurized_spawner", BlockPressurizedSpawner::new);
    public static final List<RegistryObject<BlockPlasticBrick>> PLASTIC_BRICKS = new ArrayList<RegistryObject<BlockPlasticBrick>>();
    public static final List<RegistryObject<BlockWallLamp>> WALL_LAMPS = new ArrayList<RegistryObject<BlockWallLamp>>();
    public static final List<RegistryObject<BlockWallLamp>> WALL_LAMPS_INVERTED = new ArrayList<RegistryObject<BlockWallLamp>>();
    public static final RegistryObject<Block> REINFORCED_STONE;
    public static final RegistryObject<Block> REINFORCED_BRICKS;
    public static final RegistryObject<Block> REINFORCED_BRICK_TILE;
    public static final RegistryObject<Block> REINFORCED_BRICK_STAIRS;
    public static final RegistryObject<Block> REINFORCED_BRICK_SLAB;
    public static final RegistryObject<Block> REINFORCED_STONE_SLAB;
    public static final RegistryObject<Block> REINFORCED_BRICK_PILLAR;
    public static final RegistryObject<Block> REINFORCED_BRICK_WALL;
    public static final RegistryObject<BlockFluidEtchingAcid> ETCHING_ACID;
    public static final RegistryObject<FlowingFluidBlock> PLASTIC;
    public static final RegistryObject<FlowingFluidBlock> LUBRICANT;
    public static final RegistryObject<FlowingFluidBlock> OIL;
    public static final RegistryObject<FlowingFluidBlock> DIESEL;
    public static final RegistryObject<FlowingFluidBlock> KEROSENE;
    public static final RegistryObject<FlowingFluidBlock> GASOLINE;
    public static final RegistryObject<FlowingFluidBlock> LPG;
    public static final RegistryObject<FlowingFluidBlock> MEMORY_ESSENCE;
    public static final RegistryObject<FlowingFluidBlock> YEAST_CULTURE;
    public static final RegistryObject<FlowingFluidBlock> ETHANOL;
    public static final RegistryObject<FlowingFluidBlock> VEGETABLE_OIL;
    public static final RegistryObject<FlowingFluidBlock> BIODIESEL;

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup) {
        return ModBlocks.register(name, sup, ModBlocks::itemDefault);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Function<RegistryObject<T>, Supplier<? extends Item>> itemCreator) {
        RegistryObject<? extends T> ret = ModBlocks.registerNoItem(name, sup);
        ITEMS.register(name, itemCreator.apply(ret));
        return ret;
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<? extends T> sup) {
        return BLOCKS.register(name, sup);
    }

    private static Supplier<BlockItem> itemDefault(RegistryObject<? extends Block> block) {
        return ModBlocks.item(block, ModItems.ItemGroups.PNC_CREATIVE_TAB);
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, Supplier<Callable<ItemStackTileEntityRenderer>> renderMethod) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(ModItems.ItemGroups.PNC_CREATIVE_TAB).setISTER(renderMethod));
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, ItemGroup itemGroup) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(itemGroup));
    }

    public static AbstractBlock.Properties defaultProps() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.0f, 10.0f).func_200947_a(SoundType.field_185852_e);
    }

    public static AbstractBlock.Properties reinforcedStoneProps() {
        return AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151670_w).func_235861_h_().func_200948_a(3.0f, 1200.0f).func_200947_a(SoundType.field_185851_d);
    }

    private static AbstractBlock.Properties fluidProps() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e();
    }

    public static RegistryObject<BlockPlasticBrick> plasticBrick(DyeColor color) {
        return PLASTIC_BRICKS.get(color.func_196059_a());
    }

    public static RegistryObject<BlockWallLamp> wallLamp(DyeColor color, boolean inverted) {
        return inverted ? WALL_LAMPS_INVERTED.get(color.func_196059_a()) : WALL_LAMPS.get(color.func_196059_a());
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            PLASTIC_BRICKS.add(ModBlocks.register("plastic_brick_" + color.func_176762_d(), () -> new BlockPlasticBrick(color), block -> () -> new BlockPlasticBrick.ItemPlasticBrick((BlockPlasticBrick)block.get())));
            WALL_LAMPS.add(ModBlocks.register("wall_lamp_" + color.func_176762_d(), () -> new BlockWallLamp(color, false), block -> () -> new BlockWallLamp.ItemWallLamp((BlockWallLamp)block.get())));
            WALL_LAMPS_INVERTED.add(ModBlocks.register("wall_lamp_inverted_" + color.func_176762_d(), () -> new BlockWallLamp(color, true), block -> () -> new BlockWallLamp.ItemWallLamp((BlockWallLamp)block.get())));
        }
        REINFORCED_STONE = ModBlocks.register("reinforced_stone", () -> new Block(ModBlocks.reinforcedStoneProps()));
        REINFORCED_BRICKS = ModBlocks.register("reinforced_bricks", () -> new Block(ModBlocks.reinforcedStoneProps()));
        REINFORCED_BRICK_TILE = ModBlocks.register("reinforced_brick_tile", () -> new Block(ModBlocks.reinforcedStoneProps()));
        REINFORCED_BRICK_STAIRS = ModBlocks.register("reinforced_brick_stairs", () -> new StairsBlock(() -> ((Block)REINFORCED_BRICKS.get()).func_176223_P(), ModBlocks.reinforcedStoneProps()));
        REINFORCED_BRICK_SLAB = ModBlocks.register("reinforced_brick_slab", () -> new SlabBlock(ModBlocks.reinforcedStoneProps()));
        REINFORCED_STONE_SLAB = ModBlocks.register("reinforced_stone_slab", () -> new SlabBlock(ModBlocks.reinforcedStoneProps()));
        REINFORCED_BRICK_PILLAR = ModBlocks.register("reinforced_brick_pillar", () -> new RotatedPillarBlock(ModBlocks.reinforcedStoneProps()));
        REINFORCED_BRICK_WALL = ModBlocks.register("reinforced_brick_wall", () -> new WallBlock(ModBlocks.reinforcedStoneProps()));
        ETCHING_ACID = ModBlocks.registerNoItem("etching_acid", () -> new BlockFluidEtchingAcid(ModBlocks.fluidProps()));
        PLASTIC = ModBlocks.registerNoItem("plastic", () -> new FlowingFluidBlock(() -> (FlowingFluid)ModFluids.PLASTIC.get(), ModBlocks.fluidProps()));
        LUBRICANT = ModBlocks.registerNoItem("lubricant", () -> new FlowingFluidBlock(() -> (FlowingFluid)ModFluids.LUBRICANT.get(), ModBlocks.fluidProps()));
        OIL = ModBlocks.registerNoItem("oil", () -> new FlowingFluidBlock(() -> (FlowingFluid)ModFluids.OIL.get(), ModBlocks.fluidProps()));
        DIESEL = ModBlocks.registerNoItem("diesel", () -> new FlowingFluidBlock(() -> (FlowingFluid)ModFluids.DIESEL.get(), ModBlocks.fluidProps()));
        KEROSENE = ModBlocks.registerNoItem("kerosene", () -> new FlowingFluidBlock(() -> (FlowingFluid)ModFluids.KEROSENE.get(), ModBlocks.fluidProps()));
        GASOLINE = ModBlocks.registerNoItem("gasoline", () -> new FlowingFluidBlock(() -> (FlowingFluid)ModFluids.GASOLINE.get(), ModBlocks.fluidProps()));
        LPG = ModBlocks.registerNoItem("lpg", () -> new FlowingFluidBlock(() -> (FlowingFluid)ModFluids.LPG.get(), ModBlocks.fluidProps()));
        MEMORY_ESSENCE = ModBlocks.registerNoItem("memory_essence", () -> new FlowingFluidBlock(() -> (FlowingFluid)ModFluids.MEMORY_ESSENCE.get(), ModBlocks.fluidProps()));
        YEAST_CULTURE = ModBlocks.registerNoItem("yeast_culture", () -> new FlowingFluidBlock(() -> (FlowingFluid)ModFluids.YEAST_CULTURE.get(), ModBlocks.fluidProps()));
        ETHANOL = ModBlocks.registerNoItem("ethanol", () -> new FlowingFluidBlock(() -> (FlowingFluid)ModFluids.ETHANOL.get(), ModBlocks.fluidProps()));
        VEGETABLE_OIL = ModBlocks.registerNoItem("vegetable_oil", () -> new FlowingFluidBlock(() -> (FlowingFluid)ModFluids.VEGETABLE_OIL.get(), ModBlocks.fluidProps()));
        BIODIESEL = ModBlocks.registerNoItem("biodiesel", () -> new FlowingFluidBlock(() -> (FlowingFluid)ModFluids.BIODIESEL.get(), ModBlocks.fluidProps()));
    }
}

