/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.core;

import java.util.Locale;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCactusLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCropLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCrops;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerLeaves;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerTree;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

public class ModHarvestHandlers {
    public static final DeferredRegister<HarvestHandler> HARVEST_HANDLERS_DEFERRED = DeferredRegister.create(HarvestHandler.class, (String)"pneumaticcraft");
    public static final Supplier<IForgeRegistry<HarvestHandler>> HARVEST_HANDLERS = HARVEST_HANDLERS_DEFERRED.makeRegistry("harvest_handlers", () -> new RegistryBuilder().disableSaving().disableSync());
    public static final RegistryObject<HarvestHandler> CROPS = ModHarvestHandlers.register("crops", HarvestHandlerCrops::new);
    public static final RegistryObject<HarvestHandler> NETHER_WART = ModHarvestHandlers.register("nether_wart", () -> new HarvestHandlerCropLike(state -> state.func_177230_c() == Blocks.field_150388_bm, NetherWartBlock.field_176486_a, stack -> stack.func_77973_b() == Items.field_151075_bm));
    public static final RegistryObject<HarvestHandler> SWEET_BERRIES = ModHarvestHandlers.register("sweet_berries", () -> new HarvestHandlerCropLike(state -> state.func_177230_c() == Blocks.field_222434_lW, SweetBerryBushBlock.field_220125_a, stack -> stack.func_77973_b() == Items.field_222112_pR){

        @Override
        protected BlockState withMinAge(BlockState state) {
            return (BlockState)state.func_206870_a((Property)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(1));
        }
    });
    public static final RegistryObject<HarvestHandler> COCOA = ModHarvestHandlers.register("cocoa_beans", () -> new HarvestHandlerCropLike(state -> state.func_177230_c() == Blocks.field_150375_by, CocoaBlock.field_176501_a, stack -> stack.func_77973_b() == Items.field_196130_bo));
    public static final RegistryObject<HarvestHandler> CACTUS = ModHarvestHandlers.register("cactus_like", () -> new HarvestHandlerCactusLike(state -> state.func_177230_c() == Blocks.field_150434_aF || state.func_177230_c() == Blocks.field_196608_cF || state.func_177230_c() == Blocks.field_203215_jy));
    public static final RegistryObject<HarvestHandler> PUMPKIN = ModHarvestHandlers.register("pumpkin_like", () -> new HarvestHandler.SimpleHarvestHandler(Blocks.field_150423_aK, Blocks.field_150440_ba));
    public static final RegistryObject<HarvestHandler> LEAVES = ModHarvestHandlers.register("leaves", HarvestHandlerLeaves::new);
    public static final RegistryObject<HarvestHandler> TREES = ModHarvestHandlers.register("trees", HarvestHandlerTree::new);

    private static <T extends HarvestHandler> RegistryObject<T> register(String name, Supplier<T> sup) {
        return HARVEST_HANDLERS_DEFERRED.register(name, sup);
    }

    public static enum TreePart {
        LOG,
        LEAVES,
        SAPLING;


        public Block convert(Block in, TreePart to) {
            ResourceLocation rl = new ResourceLocation(in.getRegistryName().toString().replace("_" + this.toString().toLowerCase(Locale.ROOT), "_" + to.toString().toLowerCase(Locale.ROOT)));
            return (Block)ForgeRegistries.BLOCKS.getValue(rl);
        }
    }
}

