/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.projectile;

import net.minecraft.block.Block;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.WebBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityVortex
extends ThrowableEntity {
    private int hitCounter = 0;
    private float renderOffsetX = -3.4028235E38f;

    public EntityVortex(EntityType<? extends EntityVortex> type, World world) {
        super(type, world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.vortexBreakable(this.field_70170_p.func_180495_p(this.func_226268_ag_()).func_177230_c())) {
                this.handleVortexCollision(this.func_226268_ag_());
            } else if (this.vortexBreakable(this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c())) {
                this.handleVortexCollision(this.func_233580_cy_());
            }
        }
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.95));
        if (this.func_213322_ci().func_189985_c() < 0.1) {
            this.func_70106_y();
        }
    }

    public boolean hasRenderOffsetX() {
        return this.renderOffsetX > -3.4028235E38f;
    }

    public float getRenderOffsetX() {
        return this.renderOffsetX;
    }

    public void setRenderOffsetX(float renderOffsetX) {
        this.renderOffsetX = renderOffsetX;
    }

    private boolean tryCutPlants(BlockPos pos) {
        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
        if (this.vortexBreakable(block)) {
            this.field_70170_p.func_175655_b(pos, true);
            return true;
        }
        return false;
    }

    public float func_70185_h() {
        return 0.0f;
    }

    protected void func_70227_a(RayTraceResult rtr) {
        if (rtr.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)rtr).func_216348_a();
            entity.func_213317_d(entity.func_213322_ci().func_178787_e(this.func_213322_ci().func_72441_c(0.0, 0.4, 0.0)));
            ItemStack shears = new ItemStack((IItemProvider)Items.field_151097_aZ);
            if (entity instanceof LivingEntity) {
                PlayerEntity shooter;
                PlayerEntity playerEntity = shooter = this.func_234616_v_() instanceof PlayerEntity ? (PlayerEntity)this.func_234616_v_() : null;
                if (shooter != null) {
                    shears.func_77973_b().func_111207_a(shears, shooter, (LivingEntity)entity, Hand.MAIN_HAND);
                }
            }
        } else if (rtr.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = ((BlockRayTraceResult)rtr).func_216350_a();
            Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
            if (this.vortexBreakable(block)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.handleVortexCollision(pos);
                }
            } else {
                this.func_70106_y();
            }
        }
        ++this.hitCounter;
        if (this.hitCounter > 20) {
            this.func_70106_y();
        }
    }

    private void handleVortexCollision(BlockPos pos) {
        BlockPos.Mutable mPos = new BlockPos.Mutable(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (this.tryCutPlants(pos)) {
            int plantsCut = 1;
            for (int x = -2; x <= 2; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        mPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                        if (!this.tryCutPlants((BlockPos)mPos)) continue;
                        ++plantsCut;
                    }
                }
            }
            double mult = Math.pow(0.85, plantsCut);
            this.func_213317_d(this.func_213322_ci().func_186678_a(mult));
        }
    }

    private boolean vortexBreakable(Block block) {
        return block instanceof IPlantable || block instanceof LeavesBlock || block instanceof WebBlock;
    }

    protected void func_70088_a() {
    }
}

