/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.semiblock.EntitySemiblockBase;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.SyncedTemperature;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.machine.HeatFrameCoolingRecipeImpl;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityHeatFrame
extends EntitySemiblockBase {
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(EntityHeatFrame.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> TEMPERATURE = EntityDataManager.func_187226_a(EntityHeatFrame.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int MIN_COOKING_TEMP = 373;
    private static final byte IDLE = 0;
    private static final byte COOKING = 1;
    private static final byte COOLING = 2;
    private final IHeatExchangerLogic logic = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap;
    private int lastValidSlot;
    private int cookingProgress;
    private int coolingProgress;
    private final SyncedTemperature syncedTemperature = new SyncedTemperature(this.logic);

    public EntityHeatFrame(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.heatCap = LazyOptional.of(() -> this.logic);
    }

    public IHeatExchangerLogic getHeatExchangerLogic() {
        return this.logic;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
        this.field_70180_af.func_187214_a(TEMPERATURE, (Object)0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.HEAT_EXCHANGER_CAPABILITY) {
            return PNCCapabilities.HEAT_EXCHANGER_CAPABILITY.orEmpty(cap, this.heatCap);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canPlace(Direction facing) {
        return this.getCachedTileEntity() != null && this.getCachedTileEntity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent();
    }

    private void setStatus(byte status) {
        this.func_184212_Q().func_187227_b(STATUS, (Object)status);
    }

    private byte getStatus() {
        return (Byte)this.func_184212_Q().func_187225_a(STATUS);
    }

    private void setSyncedTemperature(int temperature) {
        this.func_184212_Q().func_187227_b(TEMPERATURE, (Object)temperature);
    }

    public int getSyncedTemperature() {
        return (Integer)this.func_184212_Q().func_187225_a(TEMPERATURE);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 1) {
            this.logic.initializeAmbientTemperature(this.field_70170_p, this.getBlockPos());
        }
        if (!this.getWorld().field_72995_K) {
            byte newStatus = 0;
            if (this.logic.getTemperature() > 373.0) {
                newStatus = this.doCooking();
            } else if (this.logic.getTemperature() < (double)HeatFrameCoolingRecipeImpl.getMaxThresholdTemp(this.getWorld())) {
                newStatus = this.doCooling();
            }
            this.setStatus(newStatus);
            if (newStatus == 0) {
                double delta = this.logic.getTemperature() - this.logic.getAmbientTemperature();
                if (delta > 1.0) {
                    this.logic.addHeat(-0.1);
                } else if (delta < -1.0) {
                    this.logic.addHeat(0.1);
                }
            }
            this.syncedTemperature.tick();
            this.setSyncedTemperature(this.syncedTemperature.getSyncedTemp());
        } else if ((this.field_70173_aa & 3) == 0) {
            byte status = this.getStatus();
            switch (status) {
                case 1: {
                    ClientUtils.emitParticles(this.field_70170_p, this.getBlockPos(), (IParticleData)(this.field_70170_p.field_73012_v.nextInt(4) == 0 ? ParticleTypes.field_197631_x : ParticleTypes.field_197601_L));
                    break;
                }
                case 2: {
                    ClientUtils.emitParticles(this.field_70170_p, this.getBlockPos(), (IParticleData)ParticleTypes.field_197602_M);
                }
            }
        }
    }

    private byte doCooking() {
        byte newStatus = 0;
        if (this.cookingProgress < 100) {
            int progress = Math.max(0, ((int)this.logic.getTemperature() - 343) / 30);
            progress = Math.min(5, progress);
            this.logic.addHeat(-progress);
            this.cookingProgress += progress;
            newStatus = 1;
        }
        if (this.cookingProgress >= 100) {
            IOHelper.getInventoryForTE(this.getCachedTileEntity()).ifPresent(handler -> {
                if (!this.tryCookSlot((IItemHandler)handler, this.lastValidSlot)) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if (!this.tryCookSlot((IItemHandler)handler, i)) continue;
                        this.cookingProgress -= 100;
                        break;
                    }
                } else {
                    this.cookingProgress -= 100;
                }
            });
        }
        return newStatus;
    }

    private boolean tryCookSlot(IItemHandler handler, int slot) {
        ItemStack stack = handler.getStackInSlot(slot);
        if (!stack.func_190926_b()) {
            Inventory inv = new Inventory(1);
            inv.func_70299_a(0, stack);
            return this.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)inv, this.field_70170_p).map(recipe -> {
                ItemStack remainder;
                ItemStack result = recipe.func_77571_b().func_77946_l();
                if (!result.func_190926_b() && (remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)result, (boolean)true)).func_190926_b()) {
                    handler.extractItem(slot, 1, false);
                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)result, (boolean)false);
                    this.lastValidSlot = slot;
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private byte doCooling() {
        int newStatus = 0;
        if (this.coolingProgress < 100) {
            int progress = Math.max(0, ((int)this.logic.getTemperature() - 243) / 30);
            progress = 6 - Math.min(5, progress);
            this.logic.addHeat(progress);
            this.coolingProgress += progress;
            newStatus = 2;
        }
        if (this.coolingProgress >= 100) {
            IOHelper.getInventoryForTE(this.getCachedTileEntity()).ifPresent(handler -> {
                if (!this.tryCoolSlot((IItemHandler)handler, this.lastValidSlot)) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if (!this.tryCoolSlot((IItemHandler)handler, i)) continue;
                        this.coolingProgress -= 100;
                        break;
                    }
                } else {
                    this.coolingProgress -= 100;
                }
            });
        }
        return (byte)newStatus;
    }

    private boolean tryCoolSlot(IItemHandler handler, int slot) {
        ItemStack stack = handler.getStackInSlot(slot);
        if (stack.func_190926_b()) {
            return false;
        }
        HeatFrameCoolingRecipe recipe = PneumaticCraftRecipeType.HEAT_FRAME_COOLING.findFirst(this.field_70170_p, r -> r.matches(stack));
        if (recipe != null) {
            boolean extractedOK;
            if (recipe.getInput() instanceof FluidIngredient) {
                if (stack.func_190916_E() != 1) {
                    return false;
                }
                extractedOK = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fluidHandler -> {
                    int toDrain = ((FluidIngredient)recipe.getInput()).getAmount();
                    if (fluidHandler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE).getAmount() == toDrain) {
                        ItemStack containerStack = fluidHandler.getContainer().func_77946_l();
                        handler.extractItem(slot, 1, false);
                        handler.insertItem(slot, containerStack, false);
                        return true;
                    }
                    return false;
                }).orElse(false);
            } else {
                boolean bl = extractedOK = handler.extractItem(slot, 1, false).func_190916_E() == 1;
            }
            if (extractedOK) {
                ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)recipe.getOutput(), (int)recipe.calculateOutputQuantity(this.logic.getTemperature()));
                ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)result, (boolean)false);
                this.lastValidSlot = slot;
                return true;
            }
            return extractedOK;
        }
        return false;
    }

    @Override
    protected void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.logic.deserializeNBT(tag.func_74775_l("heatExchanger"));
        this.cookingProgress = tag.func_74762_e("cookingProgress");
        this.coolingProgress = tag.func_74762_e("coolingProgress");
    }

    @Override
    public CompoundNBT serializeNBT(CompoundNBT tag) {
        tag.func_218657_a("heatExchanger", (INBT)this.logic.serializeNBT());
        tag.func_74768_a("cookingProgress", this.cookingProgress);
        tag.func_74768_a("coolingProgress", this.coolingProgress);
        return super.serializeNBT(tag);
    }

    @Override
    public void addTooltip(List<ITextComponent> curInfo, PlayerEntity player, CompoundNBT tag, boolean extended) {
        int cool;
        int cook;
        if (!this.field_70170_p.field_72995_K) {
            cook = this.cookingProgress;
            cool = this.coolingProgress;
        } else {
            this.logic.deserializeNBT(tag.func_74775_l("heatExchanger"));
            cook = tag.func_74762_e("cookingProgress");
            cool = tag.func_74762_e("coolingProgress");
        }
        if (this.getStatus() != 1 && cook >= 100) {
            cook = 0;
        }
        if (this.getStatus() != 2 && cool >= 100) {
            cool = 0;
        }
        curInfo.add(HeatUtil.formatHeatString(this.logic.getTemperatureAsInt()));
        curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.waila.heatFrame.cooking", cook).func_240699_a_(TextFormatting.GRAY));
        curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.waila.heatFrame.cooling", cool).func_240699_a_(TextFormatting.GRAY));
    }
}

