/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import me.desht.pneumaticcraft.api.drone.SpecialVariableRetrievalEvent;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DroneSpecialVariableHandler {
    private static final Map<String, BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos>> DISPATCH_MAP = new HashMap<String, BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos>>();
    private static final BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos> MISSING = (event, extraParam) -> BlockPos.field_177992_a;

    @SubscribeEvent
    public void onSpecialVariableRetrieving(SpecialVariableRetrievalEvent.CoordinateVariable.Drone event) {
        String[] s = event.specialVarName.split("=", 2);
        String extra = s.length > 1 ? s[1] : "";
        event.setCoordinate(DISPATCH_MAP.getOrDefault(s[0], MISSING).apply(event, extra));
    }

    private static BlockPos getPosForPlayer(PlayerEntity player) {
        return player == null ? BlockPos.field_177992_a : player.func_233580_cy_().func_177972_a(Direction.UP);
    }

    static {
        DISPATCH_MAP.put("drone_pos", (event, extra) -> new BlockPos(event.drone.getDronePos()));
        DISPATCH_MAP.put("controller_pos", (event, extra) -> event.drone.getControllerPos());
        DISPATCH_MAP.put("owner_pos", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer(event.drone.getOwner()));
        DISPATCH_MAP.put("player_pos", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer(PneumaticCraftUtils.getPlayerFromName(extra)));
        DISPATCH_MAP.put("owner", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer(event.drone.getOwner()));
        DISPATCH_MAP.put("player", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer(PneumaticCraftUtils.getPlayerFromName(extra)));
        DISPATCH_MAP.put("drone", (event, extra) -> new BlockPos(event.drone.getDronePos()).func_177972_a(Direction.UP));
    }
}

