/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.ArrayList;
import me.desht.pneumaticcraft.api.drone.AmadronRetrievalEvent;
import me.desht.pneumaticcraft.api.drone.DroneSuicideEvent;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.entity.living.EntityAmadrone;
import me.desht.pneumaticcraft.common.item.ItemAmadronTablet;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronStockUpdate;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.GlobalPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;

public class EventHandlerAmadron {
    @SubscribeEvent
    public void onDroneSuicide(DroneSuicideEvent event) {
        if (event.drone instanceof EntityAmadrone) {
            EntityAmadrone drone = (EntityAmadrone)event.drone;
            AmadronOffer offer = AmadronOfferManager.getInstance().getOffer(drone.getHandlingOffer());
            if (offer != null) {
                int requiredCount = offer.getInput().getAmount() * drone.getOfferTimes();
                switch (offer.getInput().getType()) {
                    case ITEM: {
                        int i;
                        for (i = 0; i < drone.getInv().getSlots(); ++i) {
                            requiredCount -= drone.getInv().getStackInSlot(i).func_190916_E();
                        }
                        if (requiredCount <= 0) {
                            for (i = 0; i < drone.getInv().getSlots(); ++i) {
                                drone.getInv().setStackInSlot(i, ItemStack.field_190927_a);
                            }
                            MinecraftForge.EVENT_BUS.post((Event)new AmadronRetrievalEvent(event.drone));
                            break;
                        }
                        this.onAmadronFailure(drone, offer);
                        break;
                    }
                    case FLUID: {
                        if (drone.getFluidTank().getFluidAmount() >= requiredCount) {
                            MinecraftForge.EVENT_BUS.post((Event)new AmadronRetrievalEvent(event.drone));
                            break;
                        }
                        this.onAmadronFailure(drone, offer);
                    }
                }
            }
        }
    }

    private void onAmadronFailure(EntityAmadrone drone, AmadronOffer offer) {
        if (offer instanceof AmadronPlayerOffer || offer.getMaxStock() >= 0) {
            offer.addStock(drone.getOfferTimes());
            if (offer instanceof AmadronPlayerOffer) {
                AmadronPlayerOffers.save();
            }
            NetworkHandler.sendNonLocal(new PacketAmadronStockUpdate(offer.func_199560_c(), offer.getStock()));
        }
    }

    @SubscribeEvent
    public void onAmadronSuccess(AmadronRetrievalEvent event) {
        EntityAmadrone drone = (EntityAmadrone)event.drone;
        AmadronOffer offer = AmadronOfferManager.getInstance().getOffer(drone.getHandlingOffer());
        AmadronPlayerOffer playerOffer = this.getPlayerOffer(offer);
        if (playerOffer == null) {
            this.doDelivery(drone, offer);
        } else {
            if (drone.getAmadronAction() == EntityAmadrone.AmadronAction.TAKING_PAYMENT) {
                if (offer instanceof AmadronPlayerOffer) {
                    ((AmadronPlayerOffer)offer).addPayment(drone.getOfferTimes());
                }
                playerOffer.onTrade(drone.getOfferTimes(), drone.getBuyingPlayer());
                this.doDelivery(drone, offer);
            } else if (drone.getAmadronAction() == EntityAmadrone.AmadronAction.RESTOCKING) {
                playerOffer.addStock(drone.getOfferTimes());
                NetworkHandler.sendNonLocal(new PacketAmadronStockUpdate(playerOffer.func_199560_c(), playerOffer.getStock()));
                playerOffer.notifyRestock();
            }
            AmadronPlayerOffers.save();
        }
    }

    private void doDelivery(EntityAmadrone drone, AmadronOffer offer) {
        ItemStack usedTablet = drone.getUsedTablet();
        switch (offer.getOutput().getType()) {
            case ITEM: {
                ItemStack stack;
                ItemStack offeringItems = offer.getOutput().getItem();
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int producedItems = offeringItems.func_190916_E() * drone.getOfferTimes(); producedItems > 0; producedItems -= stack.func_190916_E()) {
                    stack = offeringItems.func_77946_l();
                    stack.func_190920_e(Math.min(producedItems, stack.func_77976_d()));
                    stacks.add(stack);
                }
                GlobalPos pos = ItemAmadronTablet.getItemProvidingLocation(usedTablet);
                if (pos == null) break;
                DroneRegistry.getInstance().deliverItemsAmazonStyle(pos, stacks.toArray(new ItemStack[0]));
                break;
            }
            case FLUID: {
                FluidStack offeringFluid = offer.getOutput().getFluid().copy();
                offeringFluid.setAmount(offeringFluid.getAmount() * drone.getOfferTimes());
                GlobalPos fpos = ItemAmadronTablet.getFluidProvidingLocation(usedTablet);
                if (fpos == null) break;
                DroneRegistry.getInstance().deliverFluidAmazonStyle(fpos, offeringFluid);
            }
        }
    }

    private AmadronPlayerOffer getPlayerOffer(AmadronOffer offer) {
        AmadronOffer o = AmadronOfferManager.getInstance().getOffer(AmadronPlayerOffer.getReversedId(offer.func_199560_c()));
        return o instanceof AmadronPlayerOffer ? (AmadronPlayerOffer)o : null;
    }
}

