/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.fluid;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.crafting.recipe.FuelQualityRecipe;
import me.desht.pneumaticcraft.api.fuel.IFuelRegistry;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Validate;

public enum FuelRegistry implements IFuelRegistry
{
    INSTANCE;

    private static final FuelRecord MISSING_FUEL_ENTRY;
    private final Map<ITag<Fluid>, FuelRecord> fuelTags = new ConcurrentHashMap<ITag<Fluid>, FuelRecord>();
    private final Map<Fluid, FuelRecord> cachedFuels = new HashMap<Fluid, FuelRecord>();
    private final Map<Fluid, FuelRecord> hotFluids = new HashMap<Fluid, FuelRecord>();

    public static FuelRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerFuel(ITag<Fluid> fluidTag, int mLPerBucket, float burnRateMultiplier) {
        Validate.notNull(fluidTag);
        Validate.isTrue((mLPerBucket >= 0 ? 1 : 0) != 0, (String)"mlPerBucket can't be < 0!", (Object[])new Object[0]);
        Validate.isTrue((burnRateMultiplier > 0.0f ? 1 : 0) != 0, (String)"burnRate can't be <= 0!", (Object[])new Object[0]);
        if (this.fuelTags.containsKey(fluidTag)) {
            Log.info("Overriding liquid fuel tag entry %s with a fuel value of %d (previous value %d)", fluidTag, mLPerBucket, this.fuelTags.get(fluidTag).mLperBucket);
        }
        this.fuelTags.put(fluidTag, new FuelRecord(mLPerBucket, burnRateMultiplier));
        Log.info("Registering liquid fuel tag entry '%s': %d mL air/bucket, burn rate %f", fluidTag, mLPerBucket, Float.valueOf(burnRateMultiplier));
    }

    public void registerHotFluid(Fluid fluid, int mLPerBucket, float burnRateMultiplier) {
        this.hotFluids.put(fluid, new FuelRecord(mLPerBucket, burnRateMultiplier));
    }

    @Override
    public int getFuelValue(World world, Fluid fluid) {
        return this.cachedFuels.computeIfAbsent((Fluid)fluid, (Function<Fluid, FuelRecord>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getFuelValue$0(net.minecraft.world.World net.minecraft.fluid.Fluid net.minecraft.fluid.Fluid ), (Lnet/minecraft/fluid/Fluid;)Lme/desht/pneumaticcraft/common/fluid/FuelRegistry$FuelRecord;)((FuelRegistry)this, (World)world, (Fluid)fluid)).mLperBucket;
    }

    @Override
    public float getBurnRateMultiplier(World world, Fluid fluid) {
        return this.cachedFuels.computeIfAbsent((Fluid)fluid, (Function<Fluid, FuelRecord>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBurnRateMultiplier$1(net.minecraft.world.World net.minecraft.fluid.Fluid net.minecraft.fluid.Fluid ), (Lnet/minecraft/fluid/Fluid;)Lme/desht/pneumaticcraft/common/fluid/FuelRegistry$FuelRecord;)((FuelRegistry)this, (World)world, (Fluid)fluid)).burnRateMultiplier;
    }

    @Override
    public Collection<Fluid> registeredFuels(World world) {
        HashSet<Fluid> res = new HashSet<Fluid>(this.hotFluids.keySet());
        for (FuelQualityRecipe fuelQualityRecipe : PneumaticCraftRecipeType.FUEL_QUALITY.getRecipes(world).values()) {
            res.addAll(fuelQualityRecipe.getFuel().getFluidStacks().stream().map(FluidStack::getFluid).filter(f -> f.func_207193_c(f.func_207188_f())).collect(Collectors.toList()));
        }
        this.fuelTags.forEach((tag, entry) -> {
            if (entry.mLperBucket > 0) {
                List l = tag.func_230236_b_().stream().filter(f -> f.func_207193_c(f.func_207188_f())).collect(Collectors.toList());
                res.addAll(l);
            }
        });
        return res;
    }

    public void clearCachedFuelFluids() {
        this.cachedFuels.clear();
    }

    private FuelRecord findEntry(World world, Fluid fluid) {
        FuelRecord fe = this.hotFluids.get(fluid);
        if (fe != null) {
            return fe;
        }
        for (FuelQualityRecipe fuelQualityRecipe : PneumaticCraftRecipeType.FUEL_QUALITY.getRecipes(world).values()) {
            if (!fuelQualityRecipe.matchesFluid(fluid)) continue;
            return new FuelRecord(fuelQualityRecipe.getAirPerBucket(), fuelQualityRecipe.getBurnRate());
        }
        for (Map.Entry entry : this.fuelTags.entrySet()) {
            if (!((ITag)entry.getKey()).func_230235_a_((Object)fluid)) continue;
            return (FuelRecord)entry.getValue();
        }
        return MISSING_FUEL_ENTRY;
    }

    private /* synthetic */ FuelRecord lambda$getBurnRateMultiplier$1(World world, Fluid fluid, Fluid k) {
        return this.findEntry(world, fluid);
    }

    private /* synthetic */ FuelRecord lambda$getFuelValue$0(World world, Fluid fluid, Fluid k) {
        return this.findEntry(world, fluid);
    }

    static {
        MISSING_FUEL_ENTRY = new FuelRecord(0, 1.0f);
    }

    private static class FuelRecord {
        final int mLperBucket;
        final float burnRateMultiplier;

        private FuelRecord(int mLperBucket, float burnRateMultiplier) {
            this.mLperBucket = mLperBucket;
            this.burnRateMultiplier = burnRateMultiplier;
        }
    }
}

