/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class HackableMobDisarm
implements IHackableEntity {
    @Override
    public ResourceLocation getHackableId() {
        return PneumaticCraftUtils.RL("mob_disarm");
    }

    @Override
    public boolean canHack(Entity entity, PlayerEntity player) {
        return entity instanceof MobEntity && Arrays.stream(EquipmentSlotType.values()).anyMatch(slot -> !((MobEntity)entity).func_184582_a(slot).func_190926_b());
    }

    @Override
    public void addHackInfo(Entity entity, List<ITextComponent> curInfo, PlayerEntity player) {
        curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.disarm", new Object[0]));
    }

    @Override
    public void addPostHackInfo(Entity entity, List<ITextComponent> curInfo, PlayerEntity player) {
        curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.disarmed", new Object[0]));
    }

    @Override
    public int getHackTime(Entity entity, PlayerEntity player) {
        return 60;
    }

    @Override
    public void onHackFinished(Entity entity, PlayerEntity player) {
        if (!entity.field_70170_p.field_72995_K) {
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                if (!this.doDisarm((MobEntity)entity, slot, player.func_70681_au())) continue;
                return;
            }
        }
    }

    @Override
    public boolean afterHackTick(Entity entity) {
        return false;
    }

    private boolean doDisarm(MobEntity entity, EquipmentSlotType slot, Random rand) {
        if (entity.func_184582_a(slot).func_190926_b()) {
            return false;
        }
        float[] dropChances = slot.func_188453_a() == EquipmentSlotType.Group.ARMOR ? entity.field_184655_bs : entity.field_82174_bp;
        int slotIdx = slot.func_188454_b();
        boolean noDamage = dropChances[slotIdx] > 1.0f;
        ItemStack stack = entity.func_184582_a(slot);
        if (!stack.func_190926_b() && rand.nextFloat() < dropChances[slotIdx]) {
            if (!noDamage && stack.func_77984_f()) {
                int k = Math.max(stack.func_77958_k() - 25, 1);
                int l = stack.func_77958_k() - rand.nextInt(rand.nextInt(k) + 1);
                stack.func_196085_b(MathHelper.func_76125_a((int)l, (int)1, (int)k));
            }
            entity.func_70099_a(stack, 0.0f);
        }
        entity.func_184201_a(slot, ItemStack.field_190927_a);
        return true;
    }
}

