/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.api.heat.HeatRegistrationEvent;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.other.HeatPropertiesRecipeImpl;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public enum BlockHeatProperties implements Iterable<HeatPropertiesRecipe>
{
    INSTANCE;

    private final ArrayListMultimap<Block, HeatPropertiesRecipe> customHeatEntries = ArrayListMultimap.create();

    public static BlockHeatProperties getInstance() {
        return INSTANCE;
    }

    public HeatPropertiesRecipe getCustomHeatEntry(World world, BlockState state) {
        if (this.customHeatEntries.isEmpty()) {
            this.populateCustomHeatEntries(world);
        }
        return this.customHeatEntries.get((Object)state.func_177230_c()).stream().filter(entry -> entry.matchState(state)).findFirst().orElse(null);
    }

    public Collection<HeatPropertiesRecipe> getAllEntries(World world) {
        if (this.customHeatEntries.isEmpty()) {
            this.populateCustomHeatEntries(world);
        }
        return this.customHeatEntries.values();
    }

    public void clear() {
        this.customHeatEntries.clear();
    }

    public void register(Block block, HeatPropertiesRecipe entry) {
        this.customHeatEntries.put((Object)block, (Object)entry);
    }

    private void populateCustomHeatEntries(World world) {
        PneumaticCraftRecipeType.HEAT_PROPERTIES.getRecipes(world).forEach((? super K key, ? super V recipe) -> this.customHeatEntries.put((Object)recipe.getBlock(), recipe));
        MinecraftForge.EVENT_BUS.post((Event)new HeatRegistrationEvent(HeatExchangerManager.getInstance()));
        this.registerDefaultFluidValues();
    }

    private void registerDefaultFluidValues() {
        for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
            BlockState state;
            if (fluid == Fluids.field_204541_a || !((state = fluid.func_207188_f().func_206883_i()).func_177230_c() instanceof FlowingFluidBlock) || this.customHeatEntries.containsKey((Object)state.func_177230_c()) || BlockHeatProperties.getInstance().getOrCreateCustomFluidEntry(fluid)) continue;
            Log.warning("unable to build custom heat entry for fluid %s (block %s) ", fluid.getRegistryName(), state.func_177230_c().getRegistryName());
        }
    }

    private boolean getOrCreateCustomFluidEntry(Fluid fluid) {
        BlockState state = fluid.func_207188_f().func_206883_i();
        if (!(state.func_177230_c() instanceof FlowingFluidBlock)) {
            return false;
        }
        List entry = this.customHeatEntries.get((Object)state.func_177230_c());
        if (entry.isEmpty()) {
            this.customHeatEntries.put((Object)state.func_177230_c(), (Object)this.buildDefaultFluidEntry(state.func_177230_c(), fluid));
        }
        return true;
    }

    private HeatPropertiesRecipe buildDefaultFluidEntry(Block block, Fluid fluid) {
        BlockState transformColdFlowing;
        BlockState transformCold;
        BlockState transformHotFlowing;
        BlockState transformHot;
        int temperature = fluid.getAttributes().getTemperature();
        if (temperature >= Fluids.field_204547_b.getAttributes().getTemperature()) {
            transformHot = null;
            transformHotFlowing = null;
            transformCold = Blocks.field_150343_Z.func_176223_P();
            transformColdFlowing = Blocks.field_150347_e.func_176223_P();
        } else if (temperature <= 273) {
            transformHot = Blocks.field_196604_cC.func_176223_P();
            transformHotFlowing = Blocks.field_150433_aE.func_176223_P();
            transformCold = Blocks.field_205164_gk.func_176223_P();
            transformColdFlowing = Blocks.field_150433_aE.func_176223_P();
        } else {
            transformHot = Blocks.field_150350_a.func_176223_P();
            transformHotFlowing = Blocks.field_150350_a.func_176223_P();
            transformCold = Blocks.field_150432_aD.func_176223_P();
            transformColdFlowing = Blocks.field_150433_aE.func_176223_P();
        }
        return new HeatPropertiesRecipeImpl(block.getRegistryName(), block, transformHot, transformHotFlowing, transformCold, transformColdFlowing, PNCConfig.Common.Heat.defaultFluidHeatCapacity, temperature, PNCConfig.Common.Heat.defaultFluidThermalResistance, Collections.emptyMap(), "");
    }

    @Override
    public Iterator<HeatPropertiesRecipe> iterator() {
        return this.customHeatEntries.values().iterator();
    }
}

