/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface IPressurizableItem {
    public int getBaseVolume();

    default public int getAir(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null ? tag.func_74762_e("pneumaticcraft:air") : 0;
    }

    default public int getUpgradedVolume(ItemStack stack) {
        int nUpgrades = UpgradableItemUtils.getUpgrades(stack, EnumUpgrade.VOLUME);
        int vol0 = ApplicableUpgradesDB.getInstance().getUpgradedVolume(this.getBaseVolume(), nUpgrades);
        return ItemRegistry.getInstance().getUpgradedVolume(stack, vol0);
    }

    default public float getPressure(ItemStack stack) {
        return (float)this.getAir(stack) / (float)this.getUpgradedVolume(stack);
    }
}

