/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadron;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemAmadronTablet
extends ItemPressurizable
implements IPositionProvider {
    public ItemAmadronTablet() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            ItemAmadronTablet.openGui(playerIn, handIn);
        }
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos pos;
        Direction facing = ctx.func_196000_l();
        PlayerEntity player = ctx.func_195999_j();
        World worldIn = ctx.func_195991_k();
        TileEntity te = worldIn.func_175625_s(pos = ctx.func_195995_a());
        if (te == null) {
            return ActionResultType.PASS;
        }
        if (te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing).isPresent()) {
            if (!worldIn.field_72995_K) {
                ItemAmadronTablet.setFluidProvidingLocation(player.func_184586_b(ctx.func_221531_n()), GlobalPosHelper.makeGlobalPos(worldIn, pos));
            } else {
                ctx.func_195999_j().func_184185_a((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
            }
        } else if (te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).isPresent()) {
            if (!worldIn.field_72995_K) {
                ItemAmadronTablet.setItemProvidingLocation(player.func_184586_b(ctx.func_221531_n()), GlobalPosHelper.makeGlobalPos(worldIn, pos));
            } else {
                ctx.func_195999_j().func_184185_a((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
            }
        } else {
            return ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> infoList, ITooltipFlag flag) {
        super.func_77624_a(stack, worldIn, infoList, flag);
        GlobalPos gPos = ItemAmadronTablet.getItemProvidingLocation(stack);
        if (gPos != null) {
            infoList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.amadronTablet.itemLocation", GlobalPosHelper.prettyPrint(gPos)).func_240699_a_(TextFormatting.YELLOW));
        } else {
            infoList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.amadronTablet.selectItemLocation", new Object[0]));
        }
        gPos = ItemAmadronTablet.getFluidProvidingLocation(stack);
        if (gPos != null) {
            infoList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.amadronTablet.fluidLocation", GlobalPosHelper.prettyPrint(gPos)).func_240699_a_(TextFormatting.YELLOW));
        } else {
            infoList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.amadronTablet.selectFluidLocation", new Object[0]));
        }
    }

    public static LazyOptional<IItemHandler> getItemCapability(ItemStack tablet) {
        GlobalPos pos = ItemAmadronTablet.getItemProvidingLocation(tablet);
        if (pos != null) {
            TileEntity te = GlobalPosHelper.getTileEntity(pos);
            for (Direction dir : DirectionUtil.VALUES) {
                LazyOptional<IItemHandler> lazy = IOHelper.getInventoryForTE(te, dir);
                if (!lazy.isPresent()) continue;
                return lazy;
            }
        }
        return LazyOptional.empty();
    }

    public static GlobalPos getItemProvidingLocation(ItemStack tablet) {
        return tablet.func_77942_o() && tablet.func_77978_p().func_74764_b("itemPos") ? GlobalPosHelper.fromNBT(tablet.func_77978_p().func_74775_l("itemPos")) : null;
    }

    private static void setItemProvidingLocation(ItemStack tablet, GlobalPos globalPos) {
        NBTUtils.setCompoundTag(tablet, "itemPos", (INBT)GlobalPosHelper.toNBT(globalPos));
    }

    public static LazyOptional<IFluidHandler> getFluidCapability(ItemStack tablet) {
        GlobalPos pos = ItemAmadronTablet.getFluidProvidingLocation(tablet);
        if (pos != null) {
            TileEntity te = GlobalPosHelper.getTileEntity(pos);
            for (Direction dir : DirectionUtil.VALUES) {
                LazyOptional<IFluidHandler> lazy = IOHelper.getFluidHandlerForTE(te, dir);
                if (!lazy.isPresent()) continue;
                return lazy;
            }
        }
        return LazyOptional.empty();
    }

    public static GlobalPos getFluidProvidingLocation(ItemStack tablet) {
        return tablet.func_77942_o() && tablet.func_77978_p().func_74764_b("liquidPos") ? GlobalPosHelper.fromNBT(tablet.func_77978_p().func_74775_l("liquidPos")) : null;
    }

    private static void setFluidProvidingLocation(ItemStack tablet, GlobalPos globalPos) {
        NBTUtils.setCompoundTag(tablet, "liquidPos", (INBT)GlobalPosHelper.toNBT(globalPos));
    }

    public static Map<ResourceLocation, Integer> loadShoppingCart(ItemStack tablet) {
        HashMap<ResourceLocation, Integer> offers = new HashMap<ResourceLocation, Integer>();
        CompoundNBT subTag = tablet.func_179543_a("shoppingCart");
        if (subTag != null) {
            for (String key : subTag.func_150296_c()) {
                offers.put(new ResourceLocation(key), subTag.func_74762_e(key));
            }
        }
        return offers;
    }

    public static void saveShoppingCart(ItemStack tablet, Map<ResourceLocation, Integer> cart) {
        CompoundNBT subTag = new CompoundNBT();
        cart.forEach((key, value) -> subTag.func_74768_a(key.toString(), value.intValue()));
        NBTUtils.setCompoundTag(tablet, "shoppingCart", (INBT)subTag);
    }

    @Override
    public List<BlockPos> getStoredPositions(World world, @Nonnull ItemStack stack) {
        GlobalPos gp1 = ItemAmadronTablet.getItemProvidingLocation(stack);
        GlobalPos gp2 = ItemAmadronTablet.getFluidProvidingLocation(stack);
        return Arrays.asList(gp1 == null ? null : gp1.func_218180_b(), gp2 == null ? null : gp2.func_218180_b());
    }

    @Override
    public int getRenderColor(int index) {
        switch (index) {
            case 0: {
                return -1868543730;
            }
            case 1: {
                return -1878998848;
            }
        }
        return -1;
    }

    public static void openGui(final PlayerEntity playerIn, final Hand handIn) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return playerIn.func_184586_b(handIn).func_200301_q();
            }

            @Nullable
            public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new ContainerAmadron(windowId, playerInventory, handIn);
            }
        }, buf -> buf.writeBoolean(handIn == Hand.MAIN_HAND));
    }
}

