/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.block.BlockAssemblyController;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.assembly.ProgramDrill;
import me.desht.pneumaticcraft.common.recipes.assembly.ProgramDrillLaser;
import me.desht.pneumaticcraft.common.recipes.assembly.ProgramLaser;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.GuiConstants;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemAssemblyProgram
extends Item {
    private static final AssemblyProgram[] PROGRAMS = new AssemblyProgram[AssemblyRecipe.AssemblyProgramType.values().length];
    private final AssemblyRecipe.AssemblyProgramType programType;

    public ItemAssemblyProgram(AssemblyRecipe.AssemblyProgramType programType) {
        super(ModItems.defaultProps());
        this.programType = programType;
    }

    public AssemblyRecipe.AssemblyProgramType getProgramType() {
        return this.programType;
    }

    public AssemblyProgram getProgram() {
        return PROGRAMS[this.programType.ordinal()];
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> infoList, ITooltipFlag par4) {
        infoList.add((ITextComponent)new StringTextComponent("Required Machines:"));
        infoList.add((ITextComponent)GuiConstants.bullet().func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate(((BlockAssemblyController)ModBlocks.ASSEMBLY_CONTROLLER.get()).func_149739_a(), new Object[0])));
        Arrays.stream(this.getProgram().getRequiredMachines()).map(machine -> GuiConstants.bullet().func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate(machine.getMachineBlock().func_149739_a(), new Object[0]))).forEach(infoList::add);
    }

    public static ItemAssemblyProgram fromProgramType(AssemblyRecipe.AssemblyProgramType program) {
        return PROGRAMS[program.ordinal()].getItem();
    }

    public static AssemblyProgram getProgram(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemAssemblyProgram ? ((ItemAssemblyProgram)stack.func_77973_b()).getProgram() : null;
    }

    static {
        ItemAssemblyProgram.PROGRAMS[AssemblyRecipe.AssemblyProgramType.DRILL.ordinal()] = new ProgramDrill();
        ItemAssemblyProgram.PROGRAMS[AssemblyRecipe.AssemblyProgramType.LASER.ordinal()] = new ProgramLaser();
        ItemAssemblyProgram.PROGRAMS[AssemblyRecipe.AssemblyProgramType.DRILL_LASER.ordinal()] = new ProgramDrillLaser();
    }
}

