/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationUpgradeManager;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ItemDrone
extends ItemPressurizable
implements IChargeableContainerProvider,
IProgrammable,
IUpgradeAcceptor {
    private final BiFunction<World, PlayerEntity, EntityDrone> droneCreator;
    private final boolean programmable;

    public ItemDrone(BiFunction<World, PlayerEntity, EntityDrone> droneCreator, boolean programmable) {
        super(120000, 12000);
        this.droneCreator = droneCreator;
        this.programmable = programmable;
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        if (world instanceof IServerWorld) {
            BlockState state;
            ItemStack iStack = ctx.func_195999_j().func_184586_b(ctx.func_221531_n());
            if (iStack.func_77973_b() == ModItems.LOGISTICS_DRONE.get()) {
                AdvancementTriggers.LOGISTICS_DRONE_DEPLOYED.trigger((ServerPlayerEntity)ctx.func_195999_j());
            }
            BlockPos placePos = (state = world.func_180495_p(pos)).func_196952_d((IBlockReader)world, pos).func_197766_b() ? pos : pos.func_177972_a(ctx.func_196000_l());
            this.spawnDrone(ctx.func_195999_j(), world, pos, ctx.func_196000_l(), placePos, iStack);
            iStack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.func_130014_f_().field_72995_K && stack.func_77942_o() && stack.func_77978_p().func_74764_b("pneumaticcraft:progWidgets")) {
            entity.func_174873_u();
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Tank")) {
            FluidTank fluidTank = new FluidTank(16000);
            fluidTank.readFromNBT(stack.func_77978_p().func_74775_l("Tank"));
            FluidStack fluidStack = fluidTank.getFluid();
            if (!fluidStack.isEmpty()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.tooltip.fluid").func_240702_b_(fluidStack.getAmount() + "mB ").func_230529_a_(fluidStack.getDisplayName()).func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    public void spawnDrone(PlayerEntity player, World world, BlockPos clickPos, Direction facing, BlockPos placePos, ItemStack iStack) {
        EntityDrone drone = this.droneCreator.apply(world, player);
        drone.func_70107_b((double)placePos.func_177958_n() + 0.5, (double)placePos.func_177956_o() + 0.5, (double)placePos.func_177952_p() + 0.5);
        drone.readFromItemStack(iStack);
        world.func_217376_c((Entity)drone);
        if (drone.addProgram(clickPos, facing, placePos, iStack, drone.progWidgets)) {
            TileEntityProgrammer.updatePuzzleConnections(drone.progWidgets);
        }
        if (world instanceof IServerWorld) {
            drone.func_213386_a((IServerWorld)world, world.func_175649_E(placePos), SpawnReason.TRIGGERED, new ILivingEntityData(){}, null);
        }
    }

    @Override
    public boolean canProgram(ItemStack stack) {
        return this.programmable;
    }

    @Override
    public boolean usesPieces(ItemStack stack) {
        return true;
    }

    @Override
    public boolean showProgramTooltip() {
        return true;
    }

    @Override
    public Map<EnumUpgrade, Integer> getApplicableUpgrades() {
        return ApplicableUpgradesDB.getInstance().getApplicableUpgrades(this);
    }

    @Override
    public String getUpgradeAcceptorTranslationKey() {
        return this.func_77658_a();
    }

    @Override
    public INamedContainerProvider getContainerProvider(TileEntityChargingStation te) {
        return new IChargeableContainerProvider.Provider(te, (ContainerType<? extends ContainerChargingStationUpgradeManager>)((ContainerType)ModContainers.CHARGING_DRONE.get()));
    }
}

