/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.LingeringPotionItem;
import net.minecraft.item.SplashPotionItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemGunAmmoStandard
extends ItemGunAmmo {
    private static final String NBT_POTION = "potion";

    @Override
    public int getMaxDamage(ItemStack stack) {
        return PNCConfig.Common.Minigun.standardAmmoCartridgeSize;
    }

    @Nonnull
    private static ItemStack getPotion(ItemStack ammo) {
        if (ammo.func_77978_p() != null && ammo.func_77978_p().func_74764_b(NBT_POTION)) {
            return ItemStack.func_199557_a((CompoundNBT)ammo.func_77978_p().func_74775_l(NBT_POTION));
        }
        return ItemStack.field_190927_a;
    }

    public static void setPotion(ItemStack ammo, ItemStack potion) {
        CompoundNBT tag = new CompoundNBT();
        potion.func_77955_b(tag);
        NBTUtils.setCompoundTag(ammo, NBT_POTION, (INBT)tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_POTION);
    }

    @Override
    public int getAmmoCost(ItemStack ammoStack) {
        ItemStack potion = ItemGunAmmoStandard.getPotion(ammoStack);
        return potion.func_190926_b() ? 1 : ItemGunAmmoStandard.getPotionAmmoCost(potion.func_77973_b());
    }

    @Override
    public int getAmmoColor(ItemStack ammo) {
        return 0xFFFF00;
    }

    @Override
    public float getAirUsageMultiplier(Minigun minigun, ItemStack ammoStack) {
        if (minigun.getUpgrades(EnumUpgrade.DISPENSER) > 0 && !ItemGunAmmoStandard.getPotion(ammoStack).func_190926_b()) {
            return (float)minigun.getUpgrades(EnumUpgrade.DISPENSER) + 1.0f;
        }
        return 1.0f;
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> infoList, ITooltipFlag extraInfo) {
        super.func_77624_a(stack, world, infoList, extraInfo);
        ItemStack potion = ItemGunAmmoStandard.getPotion(stack);
        if (!potion.func_190926_b()) {
            ArrayList potionInfo = new ArrayList();
            potion.func_77973_b().func_77624_a(potion, world, potionInfo, extraInfo);
            String extra = "";
            if (potion.func_77973_b() instanceof SplashPotionItem) {
                extra = " " + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.gunAmmo.splash", (Object[])new Object[0]);
            } else if (potion.func_77973_b() instanceof LingeringPotionItem) {
                extra = " " + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.gunAmmo.lingering", (Object[])new Object[0]);
            }
            infoList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gunAmmo", new Object[0]).func_240702_b_(" ").func_230529_a_((ITextComponent)potionInfo.get(0)).func_240702_b_(extra));
        } else {
            infoList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gunAmmo.combineWithPotion", new Object[0]));
        }
    }

    @Override
    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        ItemStack potion = ItemGunAmmoStandard.getPotion(ammo);
        if (!potion.func_190926_b() && target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            PlayerEntity shooter = minigun.getPlayer();
            if (minigun.dispenserWeightedPercentage(PNCConfig.Common.Minigun.potionProcChance, 0.25f)) {
                if (potion.func_77973_b() == Items.field_151068_bn) {
                    List effects = PotionUtils.func_185189_a((ItemStack)potion);
                    for (EffectInstance effect : effects) {
                        entity.func_195064_c(new EffectInstance(effect));
                    }
                    entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187825_fO, SoundCategory.PLAYERS, 1.0f, 1.0f);
                } else if (potion.func_77973_b() == Items.field_185155_bH || potion.func_77973_b() == Items.field_185156_bI) {
                    PotionEntity entityPotion = new PotionEntity(shooter.field_70170_p, (LivingEntity)shooter);
                    entityPotion.func_213884_b(potion);
                    entityPotion.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                    shooter.field_70170_p.func_217376_c((Entity)entityPotion);
                }
            }
            return ItemGunAmmoStandard.getPotionAmmoCost(potion.func_77973_b());
        }
        return super.onTargetHit(minigun, ammo, target);
    }

    @Override
    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockRayTraceResult brtr) {
        ItemStack potion = ItemGunAmmoStandard.getPotion(ammo);
        if (potion.func_77973_b() == Items.field_185155_bH || potion.func_77973_b() == Items.field_185156_bI) {
            PlayerEntity shooter = minigun.getPlayer();
            int chance = PNCConfig.Common.Minigun.potionProcChance + minigun.getUpgrades(EnumUpgrade.DISPENSER) * 2;
            if (shooter.field_70170_p.field_73012_v.nextInt(100) < chance) {
                PotionEntity entityPotion = new PotionEntity(shooter.field_70170_p, (LivingEntity)shooter);
                entityPotion.func_213884_b(potion);
                BlockPos pos2 = brtr.func_216350_a().func_177972_a(brtr.func_216354_b());
                entityPotion.func_70107_b((double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5);
                shooter.field_70170_p.func_217376_c((Entity)entityPotion);
            }
            return ItemGunAmmoStandard.getPotionAmmoCost(potion.func_77973_b());
        }
        return super.onBlockHit(minigun, ammo, brtr);
    }

    private static int getPotionAmmoCost(Item item) {
        if (item == Items.field_185156_bI) {
            return 6;
        }
        if (item == Items.field_185155_bH) {
            return 3;
        }
        if (item == Items.field_151068_bn) {
            return 1;
        }
        throw new IllegalArgumentException("Item " + item + " is not a potion!");
    }
}

