/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.render.RenderItemMinigun;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationUpgradeManager;
import me.desht.pneumaticcraft.common.inventory.ContainerMinigunMagazine;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.minigun.MinigunPlayerTracker;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemMinigun
extends ItemPressurizable
implements IChargeableContainerProvider,
IUpgradeAcceptor,
IFOVModifierItem,
IInventoryItem,
IShiftScrollable {
    public static final int MAGAZINE_SIZE = 4;
    private static final String NBT_MAGAZINE = "Magazine";
    public static final String NBT_LOCKED_SLOT = "LockedSlot";

    public ItemMinigun() {
        super(ModItems.toolProps().setISTER(() -> RenderItemMinigun::new), 30000, 3000);
    }

    public static MagazineHandler getMagazine(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemMinigun) {
            return new MagazineHandler(stack);
        }
        return null;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean currentItem) {
        super.func_77663_a(stack, world, entity, slot, currentItem);
        PlayerEntity player = (PlayerEntity)entity;
        Minigun minigun = this.getMinigun(stack, player);
        if (!currentItem) {
            minigun.setMinigunSpeed(0.0f);
            minigun.setMinigunActivated(false);
            minigun.setMinigunTriggerTimeOut(0);
        } else {
            minigun.update(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        }
        if (!world.field_72995_K && slot >= 0 && slot <= 8) {
            this.handleAmmoRepair(stack, world, minigun);
        }
    }

    private void handleAmmoRepair(ItemStack stack, World world, Minigun minigun) {
        if (minigun.getPlayer().field_71070_bA instanceof ContainerMinigunMagazine) {
            return;
        }
        int itemLife = minigun.getUpgrades(EnumUpgrade.ITEM_LIFE);
        if (itemLife > 0) {
            MagazineHandler handler = ItemMinigun.getMagazine(stack);
            boolean repaired = false;
            float pressure = minigun.getAirCapability().map(IAirHandler::getPressure).orElse(Float.valueOf(0.0f)).floatValue();
            for (int i = 0; i < handler.getSlots() && pressure > 0.25f; ++i) {
                ItemStack ammo = handler.getStackInSlot(i);
                if (!(ammo.func_77973_b() instanceof ItemGunAmmo) || ammo.func_77952_i() <= 0 || world.func_82737_E() % (475L - (long)itemLife * 75L) != 0L) continue;
                ammo.func_196085_b(ammo.func_77952_i() - 1);
                minigun.getAirCapability().ifPresent(h -> h.addAir(-(50 * itemLife)));
                pressure = minigun.getAirCapability().map(IAirHandler::getPressure).orElse(Float.valueOf(0.0f)).floatValue();
                repaired = true;
            }
            if (repaired) {
                handler.save();
            }
        }
    }

    private Minigun getMinigun(ItemStack stack, PlayerEntity player, ItemStack ammo) {
        return new MinigunItem(player, stack).setAmmoStack(ammo).setAirHandler((LazyOptional<? extends IAirHandler>)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY), 20).setWorld(player.field_70170_p);
    }

    public Minigun getMinigun(ItemStack stack, PlayerEntity player) {
        return this.getMinigun(stack, player, ItemMinigun.getMagazine(stack).getAmmo());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, final Hand handIn) {
        final ItemStack stack = player.func_184586_b(handIn);
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K && stack.func_190916_E() == 1) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return stack.func_200301_q();
                    }

                    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                        return new ContainerMinigunMagazine(i, playerInventory, handIn);
                    }
                }, buf -> ContainerPneumaticBase.putHand(buf, handIn));
            }
            return ActionResult.func_226249_b_((Object)stack);
        }
        MagazineHandler magazineHandler = ItemMinigun.getMagazine(stack);
        ItemStack ammo = magazineHandler.getAmmo();
        if (!ammo.func_190926_b()) {
            player.func_184598_c(handIn);
            return ActionResult.func_233538_a_((Object)stack, (boolean)world.field_72995_K);
        }
        if (player.field_70170_p.field_72995_K) {
            player.func_184185_a(SoundEvents.field_187556_aj, 1.0f, 1.0f);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.message.minigun.outOfAmmo"), true);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        MagazineHandler magazineHandler = ItemMinigun.getMagazine(stack);
        ItemStack ammo = magazineHandler.getAmmo();
        if (!ammo.func_190926_b()) {
            boolean usedUpAmmo;
            int prevDamage = ammo.func_77952_i();
            Minigun minigun = this.getMinigun(stack, player, ammo);
            boolean bl = usedUpAmmo = minigun.tryFireMinigun(null) && minigun.getUpgrades(EnumUpgrade.ITEM_LIFE) == 0;
            if (usedUpAmmo) {
                ammo.func_190920_e(0);
            }
            if (usedUpAmmo || ammo.func_77952_i() != prevDamage) {
                magazineHandler.save();
            }
        } else {
            if (player.field_70170_p.field_72995_K) {
                player.func_184185_a(SoundEvents.field_187556_aj, 1.0f, 1.0f);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.message.minigun.outOfAmmo"), true);
            }
            player.func_184597_cx();
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    public Map<EnumUpgrade, Integer> getApplicableUpgrades() {
        return ApplicableUpgradesDB.getInstance().getApplicableUpgrades(this);
    }

    @Override
    public String getUpgradeAcceptorTranslationKey() {
        return this.func_77658_a();
    }

    @Override
    public float getFOVModifier(ItemStack stack, PlayerEntity player, EquipmentSlotType slot) {
        Minigun minigun = this.getMinigun(stack, player);
        int trackers = minigun.getUpgrades(EnumUpgrade.ENTITY_TRACKER);
        if (!minigun.isMinigunActivated() || trackers == 0) {
            return 1.0f;
        }
        return 1.0f - (float)trackers * minigun.getMinigunSpeed() / 2.0f;
    }

    @Override
    public void getStacksInItem(ItemStack stack, List<ItemStack> curStacks) {
        MagazineHandler handler = ItemMinigun.getMagazine(stack);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            curStacks.add(handler.getStackInSlot(i));
        }
    }

    @Override
    public ITextComponent getInventoryHeader() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gunAmmo.loaded", new Object[0]).func_240699_a_(TextFormatting.GREEN);
    }

    @Override
    public INamedContainerProvider getContainerProvider(TileEntityChargingStation te) {
        return new IChargeableContainerProvider.Provider(te, (ContainerType<? extends ContainerChargingStationUpgradeManager>)((ContainerType)ModContainers.CHARGING_MINIGUN.get()));
    }

    @Override
    public void onShiftScrolled(PlayerEntity player, boolean forward, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemMinigun) {
            MagazineHandler handler = ItemMinigun.getMagazine(stack);
            int newSlot = Math.max(0, ItemMinigun.getLockedSlot(stack));
            for (int i = 0; i < 3; ++i) {
                if ((newSlot += forward ? 1 : -1) < 0) {
                    newSlot = 3;
                } else if (newSlot >= 4) {
                    newSlot = 0;
                }
                if (!(handler.getStackInSlot(newSlot).func_77973_b() instanceof ItemGunAmmo)) continue;
                NBTUtils.setInteger(stack, NBT_LOCKED_SLOT, newSlot);
                return;
            }
        }
    }

    public static int getLockedSlot(ItemStack stack) {
        if (NBTUtils.hasTag(stack, NBT_LOCKED_SLOT)) {
            int slot = NBTUtils.getInteger(stack, NBT_LOCKED_SLOT);
            if (slot >= 0 && slot < 4) {
                return slot;
            }
            Log.warning("removed out of range saved ammo slot: " + slot, new Object[0]);
            NBTUtils.removeTag(stack, NBT_LOCKED_SLOT);
        }
        return -1;
    }

    private static class MinigunItem
    extends Minigun {
        private final ItemStack minigunStack;
        private final MinigunPlayerTracker tracker;

        MinigunItem(PlayerEntity player, ItemStack stack) {
            super(player, false);
            this.tracker = MinigunPlayerTracker.getInstance(player);
            this.minigunStack = stack;
        }

        @Override
        public boolean isMinigunActivated() {
            return this.tracker.isActivated();
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            this.tracker.setActivated(activated);
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            if (!ammo.func_190926_b()) {
                this.tracker.setAmmoColor(this.getAmmoColor(ammo));
            } else {
                this.tracker.setAmmoColor(0);
            }
        }

        @Override
        public int getAmmoColor() {
            return this.tracker.getAmmoColor();
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            if (!this.player.field_70170_p.field_72995_K) {
                NetworkHandler.sendToAllTracking(new PacketPlaySound(soundName, SoundCategory.PLAYERS, this.player.func_233580_cy_(), volume, pitch, false), this.player.field_70170_p, this.player.func_233580_cy_());
            }
        }

        @Override
        public float getMinigunSpeed() {
            return this.tracker.getRotationSpeed();
        }

        @Override
        public void setMinigunSpeed(float minigunSpeed) {
            this.tracker.setRotationSpeed(minigunSpeed);
        }

        @Override
        public int getMinigunTriggerTimeOut() {
            return this.tracker.getTriggerTimeout();
        }

        @Override
        public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
            this.tracker.setTriggerTimeout(minigunTriggerTimeOut);
        }

        @Override
        public float getMinigunRotation() {
            return this.tracker.getBarrelRotation();
        }

        @Override
        public void setMinigunRotation(float minigunRotation) {
            this.tracker.setBarrelRotation(minigunRotation);
        }

        @Override
        public float getOldMinigunRotation() {
            return this.tracker.getPrevBarrelRotation();
        }

        @Override
        public void setOldMinigunRotation(float oldMinigunRotation) {
            this.tracker.setPrevBarrelRotation(oldMinigunRotation);
        }

        @Override
        public int getUpgrades(EnumUpgrade upgrade) {
            return Math.min(ApplicableUpgradesDB.getInstance().getMaxUpgrades(this.minigunStack.func_77973_b(), upgrade), UpgradableItemUtils.getUpgrades(this.minigunStack, upgrade));
        }
    }

    public static class MagazineHandler
    extends BaseItemStackHandler {
        private final ItemStack gunStack;

        MagazineHandler(ItemStack gunStack) {
            super(4);
            this.gunStack = gunStack;
            if (gunStack.func_77942_o() && gunStack.func_77978_p().func_74764_b(ItemMinigun.NBT_MAGAZINE)) {
                this.deserializeNBT(gunStack.func_77978_p().func_74775_l(ItemMinigun.NBT_MAGAZINE));
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() instanceof ItemGunAmmo;
        }

        public ItemStack getAmmo() {
            int slot = ItemMinigun.getLockedSlot(this.gunStack);
            if (slot >= 0) {
                return this.getStackInSlot(slot);
            }
            for (int i = 0; i < 4; ++i) {
                if (!(this.getStackInSlot(i).func_77973_b() instanceof ItemGunAmmo)) continue;
                return this.getStackInSlot(i);
            }
            return ItemStack.field_190927_a;
        }

        public void save() {
            if (!this.gunStack.func_190926_b()) {
                NBTUtils.setCompoundTag(this.gunStack, ItemMinigun.NBT_MAGAZINE, (INBT)this.serializeNBT());
            }
        }
    }
}

