/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.ICustomDurabilityBar;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.capabilities.AirHandlerItemStack;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.EntityProgrammableController;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.entity.living.EntityDroneBase;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationUpgradeManager;
import me.desht.pneumaticcraft.common.item.CompressedIronArmorMaterial;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.IPressurizableItem;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.recipes.special.OneProbeCrafting;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammableController;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemPneumaticArmor
extends ArmorItem
implements IChargeableContainerProvider,
IUpgradeAcceptor,
IFOVModifierItem,
ICustomDurabilityBar,
IPressurizableItem,
IDyeableArmorItem,
ColorHandlers.ITintableItem {
    private static final UUID[] PNEUMATIC_ARMOR_MODIFIERS = new UUID[]{UUID.fromString("4a6bf01d-2e83-4b13-aaf0-a4c05958ea3c"), UUID.fromString("ad78a169-0409-47fb-8ca2-126b19196b56"), UUID.fromString("87bf456d-7360-407d-8592-5a2583eb948c"), UUID.fromString("e836e6c9-355e-49f2-87fc-331fadfdd642")};
    private static final IArmorMaterial PNEUMATIC_ARMOR_MATERIAL = new CompressedIronArmorMaterial(0.2f);
    private static final int[] ARMOR_VOLUMES = new int[]{12000, 12000, 28000, 12000};
    public static final String NBT_SEARCH_ITEM = "SearchStack";
    public static final String NBT_COORD_TRACKER = "CoordTracker";
    public static final String NBT_ENTITY_FILTER = "entityFilter";
    public static final String NBT_JUMP_BOOST = "jumpBoost";
    public static final String NBT_SPEED_BOOST = "speedBoost";
    public static final String NBT_BUILDER_MODE = "JetBootsBuilderMode";
    public static final String NBT_JET_BOOTS_POWER = "JetBootsPower";
    public static final String NBT_FLIGHT_STABILIZERS = "JetBootsStabilizers";
    public static final int DEFAULT_PRIMARY_COLOR = -6908266;
    public static final int DEFAULT_SECONDARY_COLOR = -4144960;
    public static final int DEFAULT_EYEPIECE_COLOR = -16733696;

    public ItemPneumaticArmor(EquipmentSlotType equipmentSlotIn) {
        super(PNEUMATIC_ARMOR_MATERIAL, equipmentSlotIn, ModItems.defaultProps());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new AirHandlerItemStack(stack, 10.0f);
    }

    public static boolean isPlayerWearingAnyPneumaticArmor(PlayerEntity player) {
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            if (!ItemPneumaticArmor.isPneumaticArmorPiece(player, slot)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPneumaticArmorPiece(PlayerEntity player, EquipmentSlotType slot) {
        return player.func_184582_a(slot).func_77973_b() instanceof ItemPneumaticArmor;
    }

    @Override
    public int getBaseVolume() {
        return ARMOR_VOLUMES[this.field_77881_a.func_188454_b()];
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        String s = slot == EquipmentSlotType.LEGS ? "pneumaticcraft:textures/armor/pneumatic_2" : "pneumaticcraft:textures/armor/pneumatic_1";
        return type == null ? s + ".png" : s + "_" + type + ".png";
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.field_77881_a == EquipmentSlotType.HEAD && worldIn != null) {
            this.addHelmetInformation(stack, worldIn, tooltip, flagIn);
        }
    }

    private void addHelmetInformation(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        BlockPos pos;
        ItemStack searchStack;
        Item searchedItem;
        if (OneProbeCrafting.isOneProbeEnabled(stack)) {
            tooltip.add((ITextComponent)new StringTextComponent("The One Probe installed").func_240699_a_(TextFormatting.BLUE));
        }
        if ((searchedItem = ItemPneumaticArmor.getSearchedItem(stack)) != null && !(searchStack = new ItemStack((IItemProvider)searchedItem)).func_190926_b()) {
            tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.search", new Object[0]).func_240702_b_(": ").func_230529_a_(searchStack.func_200301_q()).func_240699_a_(TextFormatting.YELLOW));
        }
        if ((pos = ItemPneumaticArmor.getCoordTrackerPos(stack, worldIn)) != null) {
            tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.coordinate_tracker", new Object[0]).func_240702_b_(": ").func_240702_b_(PneumaticCraftUtils.posToString(pos)).func_240699_a_(TextFormatting.YELLOW));
        }
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @Override
    public Map<EnumUpgrade, Integer> getApplicableUpgrades() {
        return ApplicableUpgradesDB.getInstance().getApplicableUpgrades((Item)this);
    }

    @Override
    public String getUpgradeAcceptorTranslationKey() {
        return this.func_77658_a();
    }

    public boolean func_77636_d(ItemStack stack) {
        return PNCConfig.Client.Armor.showEnchantGlint && super.func_77636_d(stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create((Multimap)super.getAttributeModifiers(equipmentSlot, stack));
        if (equipmentSlot == this.field_77881_a) {
            int upgrades = UpgradableItemUtils.getUpgrades(stack, EnumUpgrade.ARMOR);
            multimap.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(PNEUMATIC_ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Pneumatic Armor modifier boost", (double)upgrades / 2.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(PNEUMATIC_ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Pneumatic Armor toughness boost", (double)upgrades, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        return ItemPressurizable.roundedPressure(stack);
    }

    public static int getIntData(ItemStack stack, String key, int def) {
        if (stack.func_77973_b() instanceof ItemPneumaticArmor && stack.func_77942_o() && stack.func_77978_p().func_150297_b(key, 3)) {
            return stack.func_77978_p().func_74762_e(key);
        }
        return def;
    }

    public static int getIntData(ItemStack stack, String key, int def, int min, int max) {
        if (stack.func_77973_b() instanceof ItemPneumaticArmor && stack.func_77942_o() && stack.func_77978_p().func_150297_b(key, 3)) {
            return MathHelper.func_76125_a((int)stack.func_77978_p().func_74762_e(key), (int)min, (int)max);
        }
        return def;
    }

    public static boolean getBooleanData(ItemStack stack, String key, boolean def) {
        if (stack.func_77973_b() instanceof ItemPneumaticArmor && stack.func_77942_o() && stack.func_77978_p().func_150297_b(key, 1)) {
            return stack.func_77978_p().func_74771_c(key) == 1;
        }
        return def;
    }

    public static Item getSearchedItem(ItemStack helmetStack) {
        if (helmetStack.func_190926_b() || !NBTUtils.hasTag(helmetStack, NBT_SEARCH_ITEM)) {
            return null;
        }
        String itemName = NBTUtils.getString(helmetStack, NBT_SEARCH_ITEM);
        return itemName == null || itemName.isEmpty() ? null : (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
    }

    public static void setSearchedItem(ItemStack helmetStack, Item searchedItem) {
        if (helmetStack.func_77973_b() instanceof ItemPneumaticArmor) {
            NBTUtils.setString(helmetStack, NBT_SEARCH_ITEM, searchedItem.getRegistryName().toString());
        }
    }

    public static BlockPos getCoordTrackerPos(ItemStack helmetStack, World world) {
        if (helmetStack.func_190926_b() || !NBTUtils.hasTag(helmetStack, NBT_COORD_TRACKER)) {
            return null;
        }
        CompoundNBT tag = NBTUtils.getCompoundTag(helmetStack, NBT_COORD_TRACKER);
        GlobalPos gPos = GlobalPosHelper.fromNBT(tag);
        if (gPos.func_218180_b().func_177956_o() < 0 || !GlobalPosHelper.isSameWorld(gPos, world)) {
            return null;
        }
        return gPos.func_218180_b();
    }

    public static void setCoordTrackerPos(ItemStack helmetStack, GlobalPos gPos) {
        NBTUtils.setCompoundTag(helmetStack, NBT_COORD_TRACKER, (INBT)GlobalPosHelper.toNBT(gPos));
    }

    public static String getEntityFilter(ItemStack helmetStack) {
        if (helmetStack.func_190926_b() || !NBTUtils.hasTag(helmetStack, NBT_ENTITY_FILTER)) {
            return "";
        }
        return NBTUtils.getString(helmetStack, NBT_ENTITY_FILTER);
    }

    public static boolean isPlayerDebuggingDrone(PlayerEntity player, EntityDroneBase e) {
        ItemStack helmet = player.func_184582_a(EquipmentSlotType.HEAD);
        if (helmet.func_77973_b() != ModItems.PNEUMATIC_HELMET.get()) {
            return false;
        }
        if (e instanceof EntityDrone) {
            return NBTUtils.getInteger(helmet, "debuggingDrone") == e.func_145782_y();
        }
        if (e instanceof EntityProgrammableController) {
            CompoundNBT tag = helmet.func_179543_a("debuggingPC");
            return tag != null && NBTUtil.func_186861_c((CompoundNBT)tag).equals((Object)((EntityProgrammableController)e).getControllerPos());
        }
        return false;
    }

    public static boolean isPlayerDebuggingDrone(PlayerEntity player, IDroneBase e) {
        ItemStack helmet = player.func_184582_a(EquipmentSlotType.HEAD);
        if (helmet.func_77973_b() != ModItems.PNEUMATIC_HELMET.get()) {
            return false;
        }
        if (e instanceof EntityDrone) {
            return NBTUtils.getInteger(helmet, "debuggingDrone") == ((EntityDrone)e).func_145782_y();
        }
        if (e instanceof TileEntityProgrammableController) {
            CompoundNBT tag = helmet.func_179543_a("debuggingPC");
            return tag != null && NBTUtil.func_186861_c((CompoundNBT)tag).equals((Object)((TileEntityProgrammableController)e).func_174877_v());
        }
        return false;
    }

    public static IDroneBase getDebuggedDrone() {
        ItemStack helmet = ClientUtils.getClientPlayer().func_184582_a(EquipmentSlotType.HEAD);
        if (helmet.func_77973_b() == ModItems.PNEUMATIC_HELMET.get() && helmet.func_77942_o()) {
            TileEntity te;
            Entity e;
            int id;
            CompoundNBT tag = helmet.func_77978_p();
            if (tag.func_74764_b("debuggingDrone") && (id = tag.func_74762_e("debuggingDrone")) > 0 && (e = ClientUtils.getClientWorld().func_73045_a(id)) instanceof IDroneBase) {
                return (IDroneBase)e;
            }
            if (tag.func_74764_b("debuggingPC") && (te = ClientUtils.getClientWorld().func_175625_s(NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("debuggingPC")))) instanceof IDroneBase) {
                return (IDroneBase)te;
            }
        }
        return null;
    }

    @Override
    public float getFOVModifier(ItemStack stack, PlayerEntity player, EquipmentSlotType slot) {
        CommonArmorHandler handler;
        double boost;
        if (slot == EquipmentSlotType.LEGS && PNCConfig.Client.Armor.leggingsFOVFactor > 0.0 && (boost = (handler = CommonArmorHandler.getHandlerForPlayer()).getSpeedBoostFromLegs()) > 0.0) {
            return 1.0f + (float)(boost * 2.0 * PNCConfig.Client.Armor.leggingsFOVFactor);
        }
        return 1.0f;
    }

    @Override
    public INamedContainerProvider getContainerProvider(TileEntityChargingStation te) {
        return new IChargeableContainerProvider.Provider(te, (ContainerType<? extends ContainerChargingStationUpgradeManager>)((ContainerType)ModContainers.CHARGING_ARMOR.get()));
    }

    @Override
    public boolean shouldShowCustomDurabilityBar(ItemStack stack) {
        return ItemPressurizable.shouldShowPressureDurability(stack);
    }

    @Override
    public int getCustomDurabilityColour(ItemStack stack) {
        return ItemPressurizable.getPressureDurabilityColor(stack);
    }

    @Override
    public float getCustomDurability(ItemStack stack) {
        return ((Float)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> Float.valueOf(h.getPressure() / h.maxPressure())).orElseThrow(RuntimeException::new)).floatValue();
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        switch (tintIndex) {
            case 0: {
                return this.func_200886_f(stack);
            }
            case 1: {
                return this.getSecondaryColor(stack);
            }
            case 2: {
                return stack.func_77973_b() == ModItems.PNEUMATIC_HELMET.get() ? this.getEyepieceColor(stack) : -1;
            }
        }
        return -1;
    }

    public int func_200886_f(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("display");
        return nbt != null && nbt.func_150297_b("color", 99) ? nbt.func_74762_e("color") : -6908266;
    }

    public int getSecondaryColor(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("display");
        return nbt != null && nbt.func_150297_b("color2", 99) ? nbt.func_74762_e("color2") : -4144960;
    }

    public void setSecondaryColor(ItemStack stack, int color) {
        stack.func_190925_c("display").func_74768_a("color2", color);
    }

    public int getEyepieceColor(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("display");
        return nbt != null && nbt.func_150297_b("color_eye", 99) ? nbt.func_74762_e("color_eye") : -16733696;
    }

    public void setEyepieceColor(ItemStack stack, int color) {
        stack.func_190925_c("display").func_74768_a("color_eye", color);
    }
}

