/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.minigun;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public abstract class Minigun {
    public static final float MAX_GUN_SPEED = 0.4f;
    private static final float MAX_GUN_YAW_CHANGE = 10.0f;
    private static final float MAX_GUN_PITCH_CHANGE = 10.0f;
    private final boolean requiresTarget;
    private float minigunSpeed;
    private int minigunTriggerTimeOut;
    private final Random rand = ThreadLocalRandom.current();
    private float minigunRotation;
    private float oldMinigunRotation;
    public float minigunYaw;
    public float oldMinigunYaw;
    public float minigunPitch;
    public float oldMinigunPitch;
    private boolean sweeping;
    private boolean returning;
    private float sweepingProgress;
    private boolean gunAimedAtTarget;
    private LazyOptional<? extends IAirHandler> airCapability = LazyOptional.empty();
    private int airUsage;
    private ItemStack ammoStack = ItemStack.field_190927_a;
    protected final PlayerEntity player;
    protected World world;
    private LivingEntity attackTarget;
    private float idleYaw;

    public Minigun(PlayerEntity player, boolean requiresTarget) {
        this.player = player;
        this.requiresTarget = requiresTarget;
    }

    public Minigun setAirHandler(LazyOptional<? extends IAirHandler> airHandler, int airUsage) {
        this.airCapability = airHandler;
        this.airUsage = airUsage;
        return this;
    }

    public Minigun setAmmoStack(@Nonnull ItemStack ammoStack) {
        this.ammoStack = ammoStack;
        return this;
    }

    @Nonnull
    public ItemStack getAmmoStack() {
        return this.ammoStack;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public Minigun setWorld(World world) {
        this.world = world;
        return this;
    }

    public World getWorld() {
        return this.world;
    }

    public Minigun setAttackTarget(LivingEntity entity) {
        this.attackTarget = entity;
        return this;
    }

    public boolean isValid() {
        return true;
    }

    public abstract boolean isMinigunActivated();

    public abstract void setMinigunActivated(boolean var1);

    public abstract void setAmmoColorStack(@Nonnull ItemStack var1);

    public abstract int getAmmoColor();

    public abstract void playSound(SoundEvent var1, float var2, float var3);

    protected int getAmmoColor(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemGunAmmo ? ((ItemGunAmmo)stack.func_77973_b()).getAmmoColor(stack) : -13553359;
    }

    public LazyOptional<? extends IAirHandler> getAirCapability() {
        return this.airCapability;
    }

    public Object getSoundSource() {
        return this.player;
    }

    public float getMinigunSpeed() {
        return this.minigunSpeed;
    }

    public void setMinigunSpeed(float minigunSpeed) {
        this.minigunSpeed = minigunSpeed;
    }

    public int getMinigunTriggerTimeOut() {
        return this.minigunTriggerTimeOut;
    }

    public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
        this.minigunTriggerTimeOut = minigunTriggerTimeOut;
    }

    public float getMinigunRotation() {
        return this.minigunRotation;
    }

    public void setMinigunRotation(float minigunRotation) {
        this.minigunRotation = minigunRotation;
    }

    public float getOldMinigunRotation() {
        return this.oldMinigunRotation;
    }

    public void setOldMinigunRotation(float oldMinigunRotation) {
        this.oldMinigunRotation = oldMinigunRotation;
    }

    public LivingEntity getAttackTarget() {
        return this.attackTarget;
    }

    public void setSweeping(boolean sweeping) {
        this.sweeping = sweeping;
    }

    public boolean isSweeping() {
        return this.sweeping;
    }

    public boolean isReturning() {
        return this.returning;
    }

    public void setReturning(boolean returning) {
        this.returning = returning;
    }

    public void setIdleYaw(float idleYaw) {
        this.idleYaw = Minigun.clampYaw(idleYaw);
    }

    public boolean isGunAimedAtTarget() {
        return !this.requiresTarget || this.gunAimedAtTarget;
    }

    public boolean tryFireMinigun(Entity target) {
        boolean lastShotOfAmmo = false;
        if (!this.ammoStack.func_190926_b() && this.ammoStack.func_77952_i() < this.ammoStack.func_77958_k() && this.airCapability.map(h -> h.getPressure() > 0.0f).orElse(true).booleanValue()) {
            this.setMinigunTriggerTimeOut(10);
            if (!(this.world.field_72995_K || this.getMinigunSpeed() != 0.4f || this.requiresTarget && !this.gunAimedAtTarget)) {
                RayTraceResult rtr = null;
                ItemGunAmmo ammoItem = (ItemGunAmmo)this.ammoStack.func_77973_b();
                if (!this.requiresTarget) {
                    rtr = RayTraceUtils.getMouseOverServer((LivingEntity)this.player, this.getRange());
                    target = rtr instanceof EntityRayTraceResult ? ((EntityRayTraceResult)rtr).func_216348_a() : null;
                }
                this.airCapability.ifPresent(airHandler -> {
                    int usage = (int)Math.ceil((float)this.airUsage * ammoItem.getAirUsageMultiplier(this, this.ammoStack));
                    usage += this.getUpgrades(EnumUpgrade.RANGE);
                    if (this.getUpgrades(EnumUpgrade.SPEED) > 0) {
                        usage *= this.getUpgrades(EnumUpgrade.SPEED) + 1;
                    }
                    airHandler.addAir(-usage);
                });
                int roundsUsed = 1;
                if (target != null) {
                    if (this.getUpgrades(EnumUpgrade.SECURITY) == 0 || !this.securityProtectedTarget(target)) {
                        roundsUsed = ammoItem.onTargetHit(this, this.ammoStack, target);
                    }
                } else if (rtr != null && rtr.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockRayTraceResult brtr = (BlockRayTraceResult)rtr;
                    roundsUsed = ammoItem.onBlockHit(this, this.ammoStack, brtr);
                }
                int ammoCost = roundsUsed * ammoItem.getAmmoCost(this.ammoStack);
                lastShotOfAmmo = this.ammoStack.func_96631_a(ammoCost, this.rand, this.player instanceof ServerPlayerEntity ? (ServerPlayerEntity)this.player : null);
            }
        }
        return lastShotOfAmmo;
    }

    private boolean securityProtectedTarget(Entity target) {
        if (target instanceof TameableEntity) {
            return ((TameableEntity)target).func_70902_q() != null;
        }
        if (target instanceof EntityDrone) {
            return ((EntityDrone)target).getOwner().func_110124_au().equals(this.getPlayer().func_110124_au());
        }
        return target instanceof PlayerEntity;
    }

    public void update(double posX, double posY, double posZ) {
        this.setOldMinigunRotation(this.getMinigunRotation());
        this.oldMinigunYaw = this.minigunYaw;
        this.oldMinigunPitch = this.minigunPitch;
        if (this.attackTarget != null && !this.attackTarget.func_70089_S()) {
            this.attackTarget = null;
        }
        this.setMinigunActivated(this.getMinigunTriggerTimeOut() > 0);
        this.setAmmoColorStack(this.ammoStack);
        if (this.isMinigunActivated()) {
            this.setMinigunTriggerTimeOut(this.getMinigunTriggerTimeOut() - 1);
            if (this.getMinigunSpeed() == 0.0f) {
                this.playSound((SoundEvent)ModSounds.HUD_INIT.get(), 3.0f, 0.9f);
            }
            float speedBonus = (float)this.getUpgrades(EnumUpgrade.SPEED) * 0.0033f;
            float lastSpeed = this.getMinigunSpeed();
            this.setMinigunSpeed(Math.min(this.getMinigunSpeed() + 0.01f + speedBonus, 0.4f));
            if (!this.world.field_72995_K && this.getMinigunSpeed() > lastSpeed && this.getMinigunSpeed() >= 0.4f) {
                NetworkHandler.sendToAllTracking(new PacketPlayMovingSound(MovingSounds.Sound.MINIGUN, this.getSoundSource()), this.player.field_70170_p, new BlockPos(posX, posY, posZ));
            }
        } else {
            this.setMinigunSpeed(Math.max(0.0f, this.getMinigunSpeed() - 0.003f));
        }
        this.setMinigunRotation(this.getMinigunRotation() + this.getMinigunSpeed());
        if (this.attackTarget != null) {
            double deltaX = posX - this.attackTarget.func_226277_ct_();
            double deltaY = posY - (this.attackTarget.func_226278_cu_() + (double)(this.attackTarget.func_213302_cg() / 2.0f));
            double deltaZ = posZ - this.attackTarget.func_226281_cx_();
            float targetYaw = (float)Minigun.clampYaw(180.0 - Math.toDegrees(Math.atan2(deltaX, deltaZ)));
            float targetPitch = (float)Math.toDegrees(Math.atan(deltaY / PneumaticCraftUtils.distBetween(0.0, 0.0, deltaX, deltaZ)));
            this.minigunYaw = this.minigunPitch < -80.0f || this.minigunPitch > 80.0f ? targetYaw : this.moveToward(this.minigunYaw, targetYaw, 10.0f, true);
            this.minigunPitch = this.moveToward(this.minigunPitch, targetPitch, 10.0f, false);
            this.gunAimedAtTarget = PneumaticCraftUtils.epsilonEquals(this.minigunYaw, targetYaw) && PneumaticCraftUtils.epsilonEquals(this.minigunPitch, targetPitch);
        } else if (this.isReturning()) {
            this.minigunYaw = this.moveToward(this.minigunYaw, this.idleYaw, 10.0f, true);
            this.minigunPitch = this.moveToward(this.minigunPitch, 0.0f, 10.0f, false);
            if (PneumaticCraftUtils.epsilonEquals(this.minigunYaw, this.idleYaw)) {
                this.setReturning(false);
            }
            this.sweepingProgress = 0.0f;
        } else if (this.isSweeping()) {
            this.minigunYaw = Minigun.clampYaw(this.idleYaw + MathHelper.func_76126_a((float)this.sweepingProgress) * 22.0f);
            this.minigunPitch = this.moveToward(this.minigunPitch, 0.0f, 10.0f, false);
            this.sweepingProgress += 0.05f;
        }
    }

    private float moveToward(float val, float target, float amount, boolean yaw) {
        if (yaw && Math.abs(val - target) > 180.0f) {
            amount = -amount;
        }
        val = val > target ? Math.max(val - amount, target) : Math.min(val + amount, target);
        return yaw ? Minigun.clampYaw(val) : val;
    }

    public int getUpgrades(EnumUpgrade upgrade) {
        return 0;
    }

    public double getRange() {
        double mul = this.getAmmoStack().func_77973_b() instanceof ItemGunAmmo ? (double)((ItemGunAmmo)this.ammoStack.func_77973_b()).getRangeMultiplier(this.ammoStack) : 1.0;
        return (double)(PNCConfig.Common.Minigun.baseRange + 5 * this.getUpgrades(EnumUpgrade.RANGE)) * mul;
    }

    public boolean dispenserWeightedPercentage(int basePct) {
        return this.dispenserWeightedPercentage(basePct, 0.1f);
    }

    public boolean dispenserWeightedPercentage(int basePct, float dispenserWeight) {
        return (float)this.getWorld().field_73012_v.nextInt(100) < (float)basePct * (1.0f + (float)this.getUpgrades(EnumUpgrade.DISPENSER) * dispenserWeight);
    }

    public static float clampYaw(float yaw) {
        while (yaw > 180.0f) {
            yaw -= 360.0f;
        }
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        return yaw;
    }

    public static double clampYaw(double yaw) {
        while (yaw > 180.0) {
            yaw -= 360.0;
        }
        while (yaw < -180.0) {
            yaw += 360.0;
        }
        return yaw;
    }
}

