/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.event.HackTickHandler;
import me.desht.pneumaticcraft.common.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketHackingEntityFinish {
    private final int entityId;

    public PacketHackingEntityFinish(Entity entity) {
        this.entityId = entity.func_145782_y();
    }

    public PacketHackingEntityFinish(PacketBuffer buffer) {
        this.entityId = buffer.readInt();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.entityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IHackableEntity hackableEntity;
            PlayerEntity player = ClientUtils.getClientPlayer();
            Entity entity = player.field_70170_p.func_73045_a(this.entityId);
            if (entity != null && (hackableEntity = HackableHandler.getHackableForEntity(entity, player)) != null) {
                hackableEntity.onHackFinished(entity, player);
                HackTickHandler.instance().trackEntity(entity, hackableEntity);
                CommonArmorHandler.getHandlerForPlayer(player).setHackedEntity(null);
                player.func_184185_a((SoundEvent)ModSounds.HELMET_HACK_FINISH.get(), 1.0f, 1.0f);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

