/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketPlayMovingSound {
    private final MovingSounds.Sound sound;
    private final BlockPos pos;
    private final int entityId;
    private final SourceType sourceType;

    public PacketPlayMovingSound(MovingSounds.Sound sound, Object soundSource) {
        this.sound = sound;
        if (soundSource instanceof Entity) {
            this.sourceType = SourceType.ENTITY;
            this.entityId = ((Entity)soundSource).func_145782_y();
            this.pos = null;
        } else if (soundSource instanceof TileEntity) {
            this.sourceType = SourceType.STATIC_POS;
            this.pos = ((TileEntity)soundSource).func_174877_v();
            this.entityId = -1;
        } else if (soundSource instanceof BlockPos) {
            this.sourceType = SourceType.STATIC_POS;
            this.pos = new BlockPos((Vector3i)((BlockPos)soundSource));
            this.entityId = -1;
        } else {
            throw new IllegalArgumentException("invalid sound source: " + soundSource);
        }
    }

    public PacketPlayMovingSound(PacketBuffer buffer) {
        this.sound = MovingSounds.Sound.values()[buffer.readByte()];
        this.sourceType = SourceType.values()[buffer.readByte()];
        if (this.sourceType == SourceType.ENTITY) {
            this.entityId = buffer.readInt();
            this.pos = null;
        } else if (this.sourceType == SourceType.STATIC_POS) {
            this.pos = buffer.func_179259_c();
            this.entityId = -1;
        } else {
            throw new IllegalArgumentException("invalid sound source: " + (Object)((Object)this.sourceType));
        }
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeByte(this.sound.ordinal());
        buffer.writeByte(this.sourceType.ordinal());
        if (this.sourceType == SourceType.ENTITY) {
            buffer.writeInt(this.entityId);
        } else if (this.sourceType == SourceType.STATIC_POS) {
            buffer.func_179255_a(this.pos);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (this.sourceType == SourceType.ENTITY) {
                Entity e = ClientUtils.getClientWorld().func_73045_a(this.entityId);
                if (e != null) {
                    MovingSounds.playMovingSound(this.sound, e, new Object[0]);
                }
            } else if (this.sourceType == SourceType.STATIC_POS) {
                MovingSounds.playMovingSound(this.sound, this.pos, new Object[0]);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    static enum SourceType {
        ENTITY,
        STATIC_POS;

    }
}

