/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.item.DyeColor;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSpawnIndicatorParticles {
    private final BlockPos pos0;
    private final int dyeColor;
    private final List<ByteOffset> offsets = new ArrayList<ByteOffset>();

    public PacketSpawnIndicatorParticles(List<BlockPos> posList, DyeColor dyeColor) {
        this.pos0 = posList.get(0);
        this.dyeColor = dyeColor.getColorValue();
        for (int i = 1; i < posList.size(); ++i) {
            BlockPos off = posList.get(i).func_177973_b((Vector3i)this.pos0);
            if (off.func_177958_n() < -128 || off.func_177958_n() > 127 || off.func_177956_o() < -128 || off.func_177956_o() > 127 || off.func_177952_p() < -128 || off.func_177952_p() > 127) continue;
            this.offsets.add(new ByteOffset(off.func_177958_n(), off.func_177956_o(), off.func_177952_p()));
        }
    }

    public PacketSpawnIndicatorParticles(PacketBuffer buffer) {
        this.pos0 = buffer.func_179259_c();
        int nOffsets = buffer.func_150792_a();
        for (int i = 0; i < nOffsets; ++i) {
            this.offsets.add(new ByteOffset(buffer.readByte(), buffer.readByte(), buffer.readByte()));
        }
        this.dyeColor = buffer.readInt();
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos0);
        buffer.func_150787_b(this.offsets.size());
        for (ByteOffset offset : this.offsets) {
            buffer.writeByte((int)offset.x);
            buffer.writeByte((int)offset.y);
            buffer.writeByte((int)offset.z);
        }
        buffer.writeInt(this.dyeColor);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world = ClientUtils.getClientWorld();
            int r = this.dyeColor >> 16 & 0xFF;
            int g = this.dyeColor >> 8 & 0xFF;
            int b = this.dyeColor & 0xFF;
            RedstoneParticleData particle = new RedstoneParticleData((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
            world.func_195594_a((IParticleData)particle, (double)this.pos0.func_177958_n() + 0.5, (double)this.pos0.func_177956_o() + 0.5, (double)this.pos0.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            for (ByteOffset offset : this.offsets) {
                world.func_195594_a((IParticleData)particle, (double)(this.pos0.func_177958_n() + offset.x) + 0.5, (double)(this.pos0.func_177956_o() + offset.y) + 0.5, (double)(this.pos0.func_177952_p() + offset.z) + 0.5, 0.0, 0.0, 0.0);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static class ByteOffset {
        private final byte x;
        private final byte y;
        private final byte z;

        private ByteOffset(int x, int y, int z) {
            this.x = (byte)x;
            this.y = (byte)y;
            this.z = (byte)z;
        }
    }
}

