/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateArmorColors {
    private final int[][] cols = new int[4][2];
    private final int eyepiece;

    public PacketUpdateArmorColors() {
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            ItemStack stack = ClientUtils.getClientPlayer().func_184582_a(slot);
            if (!(stack.func_77973_b() instanceof ItemPneumaticArmor)) continue;
            this.cols[slot.func_188454_b()][0] = ((ItemPneumaticArmor)stack.func_77973_b()).func_200886_f(stack);
            this.cols[slot.func_188454_b()][1] = ((ItemPneumaticArmor)stack.func_77973_b()).getSecondaryColor(stack);
        }
        ItemStack stack = ClientUtils.getClientPlayer().func_184582_a(EquipmentSlotType.HEAD);
        this.eyepiece = stack.func_77973_b() instanceof ItemPneumaticArmor ? ((ItemPneumaticArmor)stack.func_77973_b()).getEyepieceColor(stack) : 0;
    }

    public PacketUpdateArmorColors(PacketBuffer buffer) {
        for (int i = 0; i < 4; ++i) {
            this.cols[i][0] = buffer.readInt();
            this.cols[i][1] = buffer.readInt();
        }
        this.eyepiece = buffer.readInt();
    }

    public void toBytes(PacketBuffer buffer) {
        for (int i = 0; i < 4; ++i) {
            buffer.writeInt(this.cols[i][0]);
            buffer.writeInt(this.cols[i][1]);
        }
        buffer.writeInt(this.eyepiece);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                    ItemStack stack = player.func_184582_a(slot);
                    if (!(stack.func_77973_b() instanceof ItemPneumaticArmor)) continue;
                    ((ItemPneumaticArmor)stack.func_77973_b()).func_200885_a(stack, this.cols[slot.func_188454_b()][0]);
                    ((ItemPneumaticArmor)stack.func_77973_b()).setSecondaryColor(stack, this.cols[slot.func_188454_b()][1]);
                }
                ItemStack stack = player.func_184582_a(EquipmentSlotType.HEAD);
                if (stack.func_77973_b() instanceof ItemPneumaticArmor) {
                    ((ItemPneumaticArmor)stack.func_77973_b()).setEyepieceColor(stack, this.eyepiece);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

