/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Calendar;
import java.util.Locale;
import me.desht.pneumaticcraft.common.core.ModParticleTypes;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class AirParticleData
implements IParticleData {
    public static final AirParticleData NORMAL = new AirParticleData(0.1f);
    public static final AirParticleData DENSE = new AirParticleData(0.3f);
    public static final IParticleData.IDeserializer<AirParticleData> DESERIALIZER = new IParticleData.IDeserializer<AirParticleData>(){

        public AirParticleData deserialize(ParticleType<AirParticleData> particleType, StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            float alpha = stringReader.readFloat();
            return new AirParticleData(alpha);
        }

        public AirParticleData read(ParticleType<AirParticleData> particleType, PacketBuffer packetBuffer) {
            return new AirParticleData(packetBuffer.readFloat());
        }
    };
    static final Codec<AirParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("alpha").forGetter(d -> Float.valueOf(d.alpha))).apply((Applicative)instance, AirParticleData::new));
    private static boolean checkDate;
    private static boolean useAlt;
    private final float alpha;

    public AirParticleData(float alpha) {
        this.alpha = alpha;
    }

    public ParticleType<?> func_197554_b() {
        return this.useAltParticles() ? (ParticleType)ModParticleTypes.AIR_PARTICLE_2.get() : (ParticleType)ModParticleTypes.AIR_PARTICLE.get();
    }

    public void func_197553_a(PacketBuffer packetBuffer) {
        packetBuffer.writeFloat(this.alpha);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %f", this.func_197554_b().getRegistryName(), Float.valueOf(this.alpha));
    }

    public float getAlpha() {
        return useAlt ? this.alpha * 2.0f : this.alpha;
    }

    private boolean useAltParticles() {
        if (!checkDate) {
            Calendar calendar = Calendar.getInstance();
            useAlt = calendar.get(2) == 2 && calendar.get(5) >= 31 || calendar.get(2) == 3 && calendar.get(5) <= 2;
            checkDate = true;
        }
        return useAlt;
    }
}

