/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.AirConHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.BlockTrackerHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ChargingHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ChestplateLauncherHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoordTrackerHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoreComponentsHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.DroneDebugHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.EntityTrackerHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.HackHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.JetBootsHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.JumpBoostHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.KickHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.MagnetHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.NightVisionHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ReachDistanceHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ScubaHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.SearchHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.SpeedBoostHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.StepAssistHandler;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Validate;

public enum ArmorUpgradeRegistry {
    INSTANCE;

    private static final String UPGRADE_PREFIX = "pneumaticcraft.armor.upgrade.";
    private final List<List<IArmorUpgradeHandler>> upgradeHandlers;
    private final Object2IntMap<IArmorUpgradeHandler> indexMap;
    private final Map<ResourceLocation, ArmorUpgradeEntry> byID = new HashMap<ResourceLocation, ArmorUpgradeEntry>();
    public static final EquipmentSlotType[] ARMOR_SLOTS;
    public final IArmorUpgradeHandler coreComponentsHandler;
    public final IArmorUpgradeHandler blockTrackerHandler;
    public final IArmorUpgradeHandler entityTrackerHandler;
    public final IArmorUpgradeHandler searchHandler;
    public final IArmorUpgradeHandler coordTrackerHandler;
    public final IArmorUpgradeHandler droneDebugHandler;
    public final IArmorUpgradeHandler nightVisionHandler;
    public final IArmorUpgradeHandler scubaHandler;
    public final IArmorUpgradeHandler hackHandler;
    public final IArmorUpgradeHandler magnetHandler;
    public final IArmorUpgradeHandler chargingHandler;
    public final IArmorUpgradeHandler chestplateLauncherHandler;
    public final IArmorUpgradeHandler airConHandler;
    public final IArmorUpgradeHandler reachDistanceHandler;
    public final IArmorUpgradeHandler runSpeedHandler;
    public final IArmorUpgradeHandler jumpBoostHandler;
    public final IArmorUpgradeHandler jetBootsHandler;
    public final IArmorUpgradeHandler stepAssistHandler;
    public final IArmorUpgradeHandler kickHandler;

    public static ArmorUpgradeRegistry getInstance() {
        return INSTANCE;
    }

    private ArmorUpgradeRegistry() {
        this.upgradeHandlers = new ArrayList<List<IArmorUpgradeHandler>>(4);
        for (int i = 0; i < 4; ++i) {
            this.upgradeHandlers.add(new ArrayList());
        }
        this.indexMap = new Object2IntOpenHashMap(30);
        this.indexMap.defaultReturnValue(-1);
        this.coreComponentsHandler = this.registerUpgradeHandler(new CoreComponentsHandler());
        this.blockTrackerHandler = this.registerUpgradeHandler(new BlockTrackerHandler());
        this.entityTrackerHandler = this.registerUpgradeHandler(new EntityTrackerHandler());
        this.searchHandler = this.registerUpgradeHandler(new SearchHandler());
        this.coordTrackerHandler = this.registerUpgradeHandler(new CoordTrackerHandler());
        this.droneDebugHandler = this.registerUpgradeHandler(new DroneDebugHandler());
        this.nightVisionHandler = this.registerUpgradeHandler(new NightVisionHandler());
        this.scubaHandler = this.registerUpgradeHandler(new ScubaHandler());
        this.hackHandler = this.registerUpgradeHandler(new HackHandler());
        this.magnetHandler = this.registerUpgradeHandler(new MagnetHandler());
        this.chargingHandler = this.registerUpgradeHandler(new ChargingHandler());
        this.chestplateLauncherHandler = this.registerUpgradeHandler(new ChestplateLauncherHandler());
        this.airConHandler = this.registerUpgradeHandler(new AirConHandler());
        this.reachDistanceHandler = this.registerUpgradeHandler(new ReachDistanceHandler());
        this.runSpeedHandler = this.registerUpgradeHandler(new SpeedBoostHandler());
        this.jumpBoostHandler = this.registerUpgradeHandler(new JumpBoostHandler());
        this.jetBootsHandler = this.registerUpgradeHandler(new JetBootsHandler());
        this.stepAssistHandler = this.registerUpgradeHandler(new StepAssistHandler());
        this.kickHandler = this.registerUpgradeHandler(new KickHandler());
    }

    public static void init() {
    }

    public static String getStringKey(ResourceLocation id) {
        return IArmorUpgradeHandler.getStringKey(id);
    }

    IArmorUpgradeHandler registerUpgradeHandler(IArmorUpgradeHandler handler) {
        List<IArmorUpgradeHandler> l = this.upgradeHandlers.get(handler.getEquipmentSlot().func_188454_b());
        this.indexMap.put((Object)handler, l.size());
        this.byID.put(handler.getID(), new ArmorUpgradeEntry(handler, l.size()));
        l.add(handler);
        return handler;
    }

    public List<IArmorUpgradeHandler> getHandlersForSlot(EquipmentSlotType slotType) {
        return this.upgradeHandlers.get(slotType.func_188454_b());
    }

    public int getIndexForHandler(IArmorUpgradeHandler handler) {
        int idx = this.indexMap.getInt((Object)handler);
        Validate.isTrue((idx >= 0 ? 1 : 0) != 0, (String)("unknown handler: " + handler), (Object[])new Object[0]);
        return idx;
    }

    public ArmorUpgradeEntry getUpgradeEntry(ResourceLocation upgradeID) {
        if (upgradeID == null) {
            return null;
        }
        return this.byID.get(upgradeID);
    }

    public Stream<ArmorUpgradeEntry> entries() {
        return this.byID.values().stream();
    }

    static {
        ARMOR_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    }

    public static class ArmorUpgradeEntry {
        final IArmorUpgradeHandler handler;
        final int index;

        public ArmorUpgradeEntry(IArmorUpgradeHandler handler, int index) {
            this.handler = handler;
            this.index = index;
        }

        public IArmorUpgradeHandler getHandler() {
            return this.handler;
        }

        public int getIndex() {
            return this.index;
        }

        public EquipmentSlotType getSlot() {
            return this.handler.getEquipmentSlot();
        }
    }
}

