/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.config.subconfig.ProgWidgetConfig;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ProgWidget
implements IProgWidget {
    static final TranslationTextComponent ALL_TEXT = PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.all", new Object[0]);
    static final TranslationTextComponent NONE_TEXT = PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.none", new Object[0]);
    private final ProgWidgetType<?> type;
    private int x;
    private int y;
    private IProgWidget[] connectedParameters;
    private IProgWidget outputStepConnection;
    private IProgWidget parent;

    public ProgWidget(ProgWidgetType<?> type) {
        this.type = type;
        if (!this.getParameters().isEmpty()) {
            this.connectedParameters = new IProgWidget[this.getParameters().size() * 2];
        }
    }

    @Override
    public ProgWidgetType<?> getType() {
        return this.type;
    }

    @Override
    public ResourceLocation getTypeID() {
        return this.getType().getRegistryName();
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate(this.getTranslationKey(), new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.DARK_AQUA, TextFormatting.UNDERLINE}));
        if (this.freeToUse()) {
            curTooltip.add((ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.progWidget.comment.tooltip.freeToUse"));
        }
    }

    @Override
    public List<ITextComponent> getExtraStringInfo() {
        return Collections.emptyList();
    }

    @Override
    public void addWarnings(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        if (this instanceof IVariableWidget) {
            HashSet<String> variables = new HashSet<String>();
            ((IVariableWidget)((Object)this)).addVariables(variables);
            for (String variable : variables) {
                if (variable.equals("") || variable.startsWith("#") || variable.startsWith("$") || this.isVariableSetAnywhere(widgets, variable)) continue;
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.warning.variableNeverSet", variable));
            }
        }
    }

    private boolean isVariableSetAnywhere(List<IProgWidget> widgets, String variable) {
        if (variable.equals("")) {
            return true;
        }
        for (IProgWidget widget : widgets) {
            if (!(widget instanceof IVariableSetWidget)) continue;
            HashSet<String> variables = new HashSet<String>();
            ((IVariableSetWidget)((Object)widget)).addVariables(variables);
            if (!variables.contains(variable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        if (!this.hasStepInput() && this.hasStepOutput() && this.outputStepConnection == null) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.noPieceConnected", new Object[0]));
        }
    }

    @Override
    public boolean isAvailable() {
        return !ProgWidgetConfig.INSTANCE.isWidgetBlacklisted(this.getType());
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return 30;
    }

    @Override
    public int getHeight() {
        return !this.getParameters().isEmpty() ? this.getParameters().size() * 22 : 22;
    }

    @Override
    public void setParent(IProgWidget widget) {
        this.parent = widget;
    }

    @Override
    public IProgWidget getParent() {
        return this.parent;
    }

    @Override
    public Pair<Float, Float> getMaxUV() {
        int width = this.getWidth() + (this.getParameters().isEmpty() ? 0 : 10);
        int height = this.getHeight() + (this.hasStepOutput() ? 10 : 0);
        int textureSize = this.getTextureSize();
        float u = (float)width / (float)textureSize;
        float v = (float)height / (float)textureSize;
        return new ImmutablePair((Object)Float.valueOf(u), (Object)Float.valueOf(v));
    }

    @Override
    public int getTextureSize() {
        int textureSize;
        int width = this.getWidth() + (this.getParameters().isEmpty() ? 0 : 10);
        int height = this.getHeight() + (this.hasStepOutput() ? 10 : 0);
        int maxSize = Math.max(width, height);
        for (textureSize = 1; textureSize < maxSize; textureSize *= 2) {
        }
        return textureSize;
    }

    @Override
    public boolean hasStepOutput() {
        return this.hasStepInput();
    }

    @Override
    public Goal getWidgetTargetAI(IDroneBase drone, IProgWidget widget) {
        return null;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return null;
    }

    @Override
    public void setParameter(int index, IProgWidget parm) {
        int index2;
        int n = index2 = index >= this.getParameters().size() ? index - this.getParameters().size() : index;
        if (this.connectedParameters != null && (parm == null || parm.getType() == this.getParameters().get(index2))) {
            this.connectedParameters[index] = parm;
        }
    }

    @Override
    public boolean canSetParameter(int index) {
        if (this.connectedParameters != null) {
            return this.hasBlacklist() || index < this.connectedParameters.length / 2;
        }
        return false;
    }

    protected boolean hasBlacklist() {
        return true;
    }

    @Override
    public IProgWidget[] getConnectedParameters() {
        return this.connectedParameters;
    }

    @Override
    public void setOutputWidget(IProgWidget widget) {
        this.outputStepConnection = widget;
    }

    @Override
    public IProgWidget getOutputWidget() {
        return this.outputStepConnection;
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        return this.outputStepConnection;
    }

    @Override
    public IProgWidget copy() {
        IProgWidget copy = IProgWidget.create(this.getType());
        CompoundNBT tag = new CompoundNBT();
        this.writeToNBT(tag);
        copy.readFromNBT(tag);
        return copy;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        tag.func_74778_a("name", this.getTypeID().toString());
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        this.x = tag.func_74762_e("x");
        this.y = tag.func_74762_e("y");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        buf.func_192572_a(this.getTypeID());
        buf.func_150787_b(this.x);
        buf.func_150787_b(this.y);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        this.x = buf.func_150792_a();
        this.y = buf.func_150792_a();
    }

    static <T extends IProgWidget> List<T> getConnectedWidgetList(IProgWidget widget, int parameterIndex, ProgWidgetType<T> type) {
        ProgWidget.validateType(widget, parameterIndex, type);
        IProgWidget connectingWidget = widget.getConnectedParameters()[parameterIndex];
        if (connectingWidget != null) {
            ArrayList<T> list = new ArrayList<T>();
            while (connectingWidget != null) {
                list.add(type.cast(connectingWidget));
                connectingWidget = connectingWidget.getConnectedParameters()[0];
            }
            return list;
        }
        return null;
    }

    private static <T extends IProgWidget> void validateType(IProgWidget widget, int parameterIndex, ProgWidgetType<T> type) {
        int l = widget.getParameters().size();
        if (parameterIndex >= l) {
            parameterIndex -= l;
        }
        if (type != widget.getParameters().get(parameterIndex)) {
            throw new IllegalArgumentException(String.format("invalid type %s for parameter %d (expected %s)", new Object[]{type, parameterIndex, widget.getParameters().get(parameterIndex)}));
        }
    }

    public static IProgWidget fromPacket(PacketBuffer buf) {
        ResourceLocation typeID = buf.func_192575_l();
        ProgWidgetType type = (ProgWidgetType)ModProgWidgets.PROG_WIDGETS.get().getValue(typeID);
        if (type != null) {
            IProgWidget newWidget = IProgWidget.create(type);
            newWidget.readFromPacket(buf);
            return newWidget;
        }
        throw new IllegalStateException("unknown widget type found: " + typeID);
    }

    @Override
    public boolean canBeRunByComputers(IDroneBase drone, IProgWidget widget) {
        return this.getWidgetAI(drone, widget) != null;
    }

    ITextComponent varAsTextComponent(String var) {
        return var.isEmpty() ? StringTextComponent.field_240750_d_ : new StringTextComponent("\"" + var + "\"");
    }
}

