/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableProvider;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTooBigException;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeBox;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeCylinder;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeGrid;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeLine;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypePyramid;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeRandom;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeSphere;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeWall;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.Entity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ProgWidgetArea
extends ProgWidget
implements IAreaProvider,
IVariableWidget {
    public int x1;
    public int y1;
    public int z1;
    public int x2;
    public int y2;
    public int z2;
    private String coord1Variable = "";
    private String coord2Variable = "";
    private DroneAIManager aiManager;
    private IVariableProvider variableProvider;
    public AreaType type = new AreaTypeBox();
    private static final Map<String, Supplier<? extends AreaType>> areaTypes = new LinkedHashMap<String, Supplier<? extends AreaType>>();
    private static final Map<Class<? extends AreaType>, String> typeToIDs = new HashMap<Class<? extends AreaType>, String>();

    public ProgWidgetArea() {
        super((ProgWidgetType)ModProgWidgets.AREA.get());
    }

    private static <T extends AreaType> void register(String id, Class<T> clazz, Supplier<T> creator) {
        if (areaTypes.containsKey(id)) {
            throw new IllegalStateException("Area type " + clazz + " could not be registered, duplicate id: " + id);
        }
        areaTypes.put(id, creator);
        typeToIDs.put(clazz, id);
    }

    public static List<AreaType> getAllAreaTypes() {
        return areaTypes.values().stream().map(Supplier::get).collect(Collectors.toList());
    }

    public static ProgWidgetArea fromPosition(BlockPos p1) {
        return ProgWidgetArea.fromPositions(p1, p1);
    }

    public static ProgWidgetArea fromPosition(BlockPos p1, int expand) {
        return ProgWidgetArea.fromPosition(p1, expand, expand, expand);
    }

    public static ProgWidgetArea fromPosition(BlockPos p1, int expandX, int expandY, int expandZ) {
        int x = expandX / 2;
        int y = expandY / 2;
        int z = expandZ / 2;
        return ProgWidgetArea.fromPositions(p1.func_177982_a(-x, -y, -z), p1.func_177982_a(x, y, z));
    }

    public static ProgWidgetArea fromPositions(BlockPos p1, BlockPos p2) {
        ProgWidgetArea area = new ProgWidgetArea();
        area.setP1(p1);
        area.setP2(p2);
        return area;
    }

    @Override
    public List<ITextComponent> getExtraStringInfo() {
        ArrayList<ITextComponent> res = new ArrayList<ITextComponent>();
        if (!this.coord1Variable.isEmpty()) {
            res.add((ITextComponent)new StringTextComponent("\"" + this.coord1Variable + "\""));
        } else if (this.x1 != 0 && this.y1 != 0 && this.z1 != 0) {
            res.add((ITextComponent)new StringTextComponent(String.format("%d, %d, %d", this.x1, this.y1, this.z1)));
        }
        if (!this.coord2Variable.isEmpty()) {
            res.add((ITextComponent)new StringTextComponent("\"" + this.coord2Variable + "\""));
            res.add((ITextComponent)new StringTextComponent(this.type.toString()));
        } else if (this.x2 != 0 && this.y2 != 0 && this.z2 != 0) {
            res.add((ITextComponent)new StringTextComponent(String.format("%d, %d, %d", this.x2, this.y2, this.z2)));
            res.add((ITextComponent)new StringTextComponent(this.type.toString()));
        }
        return res;
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        String c1 = this.coord1Variable.equals("") ? (this.x1 != 0 || this.y1 != 0 || this.z1 != 0 ? String.format("P1: [ %d, %d, %d ]", this.x1, this.y1, this.z1) : null) : "P1: var \"" + this.coord1Variable + "\"";
        String c2 = this.coord2Variable.equals("") ? (this.x2 != 0 || this.y2 != 0 || this.z2 != 0 ? String.format("P2: [ %d, %d, %d ]", this.x2, this.y2, this.z2) : null) : "P2: var \"" + this.coord2Variable + "\"";
        if (c1 != null) {
            curTooltip.add((ITextComponent)new StringTextComponent(c1));
        }
        if (c2 != null) {
            curTooltip.add((ITextComponent)new StringTextComponent(c2));
            this.addAreaTypeTooltip(curTooltip);
        }
    }

    public void addAreaTypeTooltip(List<ITextComponent> curTooltip) {
        curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.type", new Object[0]).func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate(this.type.getTranslationKey(), new Object[0]).func_240699_a_(TextFormatting.YELLOW)));
        ArrayList<AreaType.AreaTypeWidget> widgets = new ArrayList<AreaType.AreaTypeWidget>();
        this.type.addUIWidgets(widgets);
        for (AreaType.AreaTypeWidget widget : widgets) {
            curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate(widget.title, new Object[0]).func_240702_b_(" ").func_230529_a_((ITextComponent)new StringTextComponent(widget.getCurValue()).func_240699_a_(TextFormatting.YELLOW)));
        }
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.coord1Variable.equals("") && this.coord2Variable.equals("") && this.x1 == 0 && this.y1 == 0 && this.z1 == 0 && this.x2 == 0 && this.y2 == 0 && this.z2 == 0) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.noArea", new Object[0]));
        }
        if (!(this.type instanceof AreaTypeBox)) {
            IProgWidget p = this;
            while ((p = p.getParent()) != null) {
                ProgWidgetType<?> type = p.getType();
                if (type != ModProgWidgets.ENTITY_ATTACK.get() && type != ModProgWidgets.ENTITY_IMPORT.get() && type != ModProgWidgets.ENTITY_RIGHT_CLICK.get() && type != ModProgWidgets.CONDITION_ENTITY.get() && type != ModProgWidgets.PICKUP_ITEM.get()) continue;
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.onlyAreaTypeBox", PneumaticCraftUtils.xlate(p.getTranslationKey(), new Object[0])));
                break;
            }
        }
    }

    public void setP1(BlockPos p) {
        this.x1 = p.func_177958_n();
        this.y1 = p.func_177956_o();
        this.z1 = p.func_177952_p();
    }

    public void setP2(BlockPos p) {
        this.x2 = p.func_177958_n();
        this.y2 = p.func_177956_o();
        this.z2 = p.func_177952_p();
    }

    private BlockPos[] getAreaPoints() {
        BlockPos c2;
        BlockPos c1;
        if (this.coord1Variable.equals("")) {
            c1 = this.x1 != 0 || this.y1 != 0 || this.z1 != 0 ? new BlockPos(this.x1, this.y1, this.z1) : null;
        } else {
            BlockPos blockPos = c1 = this.variableProvider != null ? this.variableProvider.getCoordinate(this.coord1Variable) : null;
        }
        if (this.coord2Variable.equals("")) {
            c2 = this.x2 != 0 || this.y2 != 0 || this.z2 != 0 ? new BlockPos(this.x2, this.y2, this.z2) : null;
        } else {
            BlockPos blockPos = c2 = this.variableProvider != null ? this.variableProvider.getCoordinate(this.coord2Variable) : null;
        }
        if (c1 == null && c2 == null) {
            return new BlockPos[]{null, null};
        }
        if (c1 == null) {
            return new BlockPos[]{c2, null};
        }
        if (c2 == null) {
            return new BlockPos[]{c1, null};
        }
        return new BlockPos[]{c1, c2};
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return (ProgWidgetType)ModProgWidgets.AREA.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)ModProgWidgets.AREA.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_AREA;
    }

    @Override
    public void getArea(Set<BlockPos> area) {
        this.getArea(area, this.type);
    }

    public void getArea(Set<BlockPos> area, AreaType areaType) {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        BlockPos[] areaPoints = this.getAreaPoints();
        if (areaPoints[0] == null && areaPoints[1] == null) {
            return;
        }
        if (areaPoints[1] != null) {
            minX = Math.min(areaPoints[0].func_177958_n(), areaPoints[1].func_177958_n());
            minY = Math.min(areaPoints[0].func_177956_o(), areaPoints[1].func_177956_o());
            minZ = Math.min(areaPoints[0].func_177952_p(), areaPoints[1].func_177952_p());
            maxX = Math.max(areaPoints[0].func_177958_n(), areaPoints[1].func_177958_n());
            maxY = Math.max(areaPoints[0].func_177956_o(), areaPoints[1].func_177956_o());
            maxZ = Math.max(areaPoints[0].func_177952_p(), areaPoints[1].func_177952_p());
        } else {
            minX = maxX = areaPoints[0].func_177958_n();
            minY = maxY = areaPoints[0].func_177956_o();
            minZ = maxZ = areaPoints[0].func_177952_p();
        }
        int size = (maxX - minX) * (maxY - minY) * (maxZ - minZ);
        int maxSize = PNCConfig.Common.General.maxProgrammingArea;
        if (size > maxSize && this.aiManager != null) {
            IDroneBase drone = this.aiManager.getDrone();
            Log.warning(String.format("Drone @ %s (DIM %s) was killed due to excessively large area (%d > %d). See 'I:maxProgrammingArea' in config.", drone.getDronePos().toString(), drone.world().func_234923_W_().func_240901_a_().toString(), size, maxSize), new Object[0]);
            drone.overload("areaTooLarge", maxSize);
            return;
        }
        Consumer<BlockPos> addFunc = p -> {
            if (p.func_177956_o() >= 0 && p.func_177956_o() < 256 && area.add((BlockPos)p) && area.size() > maxSize) {
                throw new AreaTooBigException();
            }
        };
        BlockPos p1 = areaPoints[0];
        BlockPos p2 = areaPoints[1] != null ? areaPoints[1] : p1;
        try {
            areaType.addArea(addFunc, p1, p2, minX, minY, minZ, maxX, maxY, maxZ);
        }
        catch (AreaTooBigException areaTooBigException) {
            // empty catch block
        }
    }

    private AxisAlignedBB getAABB() {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        BlockPos[] areaPoints = this.getAreaPoints();
        if (areaPoints[0] == null) {
            return null;
        }
        if (areaPoints[1] != null) {
            minX = Math.min(areaPoints[0].func_177958_n(), areaPoints[1].func_177958_n());
            minY = Math.min(areaPoints[0].func_177956_o(), areaPoints[1].func_177956_o());
            minZ = Math.min(areaPoints[0].func_177952_p(), areaPoints[1].func_177952_p());
            maxX = Math.max(areaPoints[0].func_177958_n(), areaPoints[1].func_177958_n());
            maxY = Math.max(areaPoints[0].func_177956_o(), areaPoints[1].func_177956_o());
            maxZ = Math.max(areaPoints[0].func_177952_p(), areaPoints[1].func_177952_p());
        } else {
            minX = maxX = areaPoints[0].func_177958_n();
            minY = maxY = areaPoints[0].func_177956_o();
            minZ = maxZ = areaPoints[0].func_177952_p();
        }
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    List<Entity> getEntitiesWithinArea(World world, Predicate<? super Entity> predicate) {
        AxisAlignedBB aabb = this.getAABB();
        return aabb != null ? world.func_175674_a(null, aabb, predicate) : new ArrayList<Entity>();
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeInt(this.x1);
        buf.writeInt(this.y1);
        buf.writeInt(this.z1);
        buf.writeInt(this.x2);
        buf.writeInt(this.y2);
        buf.writeInt(this.z2);
        buf.func_180714_a(typeToIDs.get(this.type.getClass()));
        this.type.writeToPacket(buf);
        buf.func_180714_a(this.coord1Variable);
        buf.func_180714_a(this.coord2Variable);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.x1 = buf.readInt();
        this.y1 = buf.readInt();
        this.z1 = buf.readInt();
        this.x2 = buf.readInt();
        this.y2 = buf.readInt();
        this.z2 = buf.readInt();
        this.type = ProgWidgetArea.createType(buf.func_150789_c(32));
        this.type.readFromPacket(buf);
        this.coord1Variable = buf.func_150789_c(256);
        this.coord2Variable = buf.func_150789_c(256);
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("x1", this.x1);
        tag.func_74768_a("y1", this.y1);
        tag.func_74768_a("z1", this.z1);
        tag.func_74768_a("x2", this.x2);
        tag.func_74768_a("y2", this.y2);
        tag.func_74768_a("z2", this.z2);
        String typeId = typeToIDs.get(this.type.getClass());
        if (typeId == null) {
            Log.error("No type id for area type " + this.type + "! Substituting Box.", new Object[0]);
            typeId = "box";
        } else {
            this.type.writeToNBT(tag);
        }
        tag.func_74778_a("type", typeId);
        tag.func_74778_a("coord1Variable", this.coord1Variable);
        tag.func_74778_a("coord2Variable", this.coord2Variable);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.x1 = tag.func_74762_e("x1");
        this.y1 = tag.func_74762_e("y1");
        this.z1 = tag.func_74762_e("z1");
        this.x2 = tag.func_74762_e("x2");
        this.y2 = tag.func_74762_e("y2");
        this.z2 = tag.func_74762_e("z2");
        this.type = ProgWidgetArea.createType(tag.func_74779_i("type"));
        this.type.readFromNBT(tag);
        this.coord1Variable = tag.func_74779_i("coord1Variable");
        this.coord2Variable = tag.func_74779_i("coord2Variable");
    }

    public static AreaType createType(String id) {
        Supplier<? extends AreaType> creator = areaTypes.get(id);
        if (creator != null) {
            return creator.get();
        }
        Log.error("No Area type found for id '" + id + "'! Substituting Box!", new Object[0]);
        return new AreaTypeBox();
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GREEN;
    }

    public String getCoord1Variable() {
        return this.coord1Variable;
    }

    public void setCoord1Variable(String coord1Variable) {
        this.coord1Variable = coord1Variable;
    }

    public String getCoord2Variable() {
        return this.coord2Variable;
    }

    public void setCoord2Variable(String coord2Variable) {
        this.coord2Variable = coord2Variable;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
        this.variableProvider = aiManager;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.coord1Variable);
        variables.add(this.coord2Variable);
    }

    public void setVariableProvider(IVariableProvider provider) {
        this.variableProvider = provider;
    }

    static {
        ProgWidgetArea.register("box", AreaTypeBox.class, AreaTypeBox::new);
        ProgWidgetArea.register("sphere", AreaTypeSphere.class, AreaTypeSphere::new);
        ProgWidgetArea.register("line", AreaTypeLine.class, AreaTypeLine::new);
        ProgWidgetArea.register("wall", AreaTypeWall.class, AreaTypeWall::new);
        ProgWidgetArea.register("cylinder", AreaTypeCylinder.class, AreaTypeCylinder::new);
        ProgWidgetArea.register("pyramid", AreaTypePyramid.class, AreaTypePyramid::new);
        ProgWidgetArea.register("grid", AreaTypeGrid.class, AreaTypeGrid::new);
        ProgWidgetArea.register("random", AreaTypeRandom.class, AreaTypeRandom::new);
    }
}

