/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IJump;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetJump;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public abstract class ProgWidgetCondition
extends ProgWidgetInventoryBase
implements ICondition,
IJump,
IVariableSetWidget {
    private DroneAIBlockCondition evaluator;
    private boolean isAndFunction;
    private ICondition.Operator operator = ICondition.Operator.GE;
    private String measureVar = "";

    public ProgWidgetCondition(ProgWidgetType<?> type) {
        super(type);
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        this.evaluator = this.getEvaluator(drone, widget);
        return this.evaluator;
    }

    protected abstract DroneAIBlockCondition getEvaluator(IDroneBase var1, IProgWidget var2);

    @Override
    public String getMeasureVar() {
        return this.measureVar;
    }

    @Override
    public void setMeasureVar(String measureVar) {
        this.measureVar = measureVar;
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.measureVar.isEmpty()) {
            curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.measure", new Object[0]).func_240702_b_(this.measureVar));
        }
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.measureVar.isEmpty() && this.getConnectedParameters()[this.getParameters().size() - 1] == null && this.getConnectedParameters()[this.getParameters().size() * 2 - 1] == null) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.error.noFlowControl", new Object[0]));
        }
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        if (this.evaluator != null) {
            boolean evaluation = this.evaluate(drone, this);
            if (evaluation) {
                drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.condition.evaluatedTrue");
            } else {
                drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.condition.evaluatedFalse");
            }
            return ProgWidgetJump.jumpToLabel(drone, allWidgets, this, evaluation);
        }
        Log.error("Shouldn't be happening! ProgWidgetCondition", new Object[0]);
        return super.getOutputWidget(drone, allWidgets);
    }

    @Override
    public boolean evaluate(IDroneBase drone, IProgWidget widget) {
        return this.evaluator.getResult();
    }

    @Override
    public boolean isAndFunction() {
        return this.isAndFunction;
    }

    @Override
    public void setAndFunction(boolean isAndFunction) {
        this.isAndFunction = isAndFunction;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.MEDIUM;
    }

    @Override
    public List<String> getPossibleJumpLocations() {
        IProgWidget widget = this.getConnectedParameters()[this.getParameters().size() - 1];
        ProgWidgetText textWidget = widget != null ? (ProgWidgetText)widget : null;
        IProgWidget widget2 = this.getConnectedParameters()[this.getParameters().size() * 2 - 1];
        ProgWidgetText textWidget2 = widget2 != null ? (ProgWidgetText)widget2 : null;
        ArrayList<String> locations = new ArrayList<String>();
        if (textWidget != null) {
            locations.add(textWidget.string);
        }
        if (textWidget2 != null) {
            locations.add(textWidget2.string);
        }
        return locations;
    }

    @Override
    public int getRequiredCount() {
        return this.getCount();
    }

    @Override
    public void setRequiredCount(int count) {
        this.setCount(count);
    }

    @Override
    public ICondition.Operator getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("isAndFunction", this.isAndFunction);
        tag.func_74774_a("operator", (byte)this.operator.ordinal());
        if (!this.measureVar.isEmpty()) {
            tag.func_74778_a("measureVar", this.measureVar);
        }
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.isAndFunction = tag.func_74767_n("isAndFunction");
        this.operator = ICondition.Operator.values()[tag.func_74771_c("operator")];
        this.measureVar = tag.func_74779_i("measureVar");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.isAndFunction);
        buf.writeByte(this.operator.ordinal());
        buf.func_211400_a(this.measureVar, 64);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.isAndFunction = buf.readBoolean();
        this.operator = ICondition.Operator.values()[buf.readByte()];
        this.measureVar = buf.func_150789_c(64);
    }

    @Override
    protected boolean isUsingSides() {
        return false;
    }

    @Override
    public List<ITextComponent> getExtraStringInfo() {
        IFormattableTextComponent anyAll = PneumaticCraftUtils.xlate(this.isAndFunction() ? "pneumaticcraft.gui.progWidget.condition.all" : "pneumaticcraft.gui.progWidget.condition.any", new Object[0]).func_240702_b_(" " + this.getOperator().toString() + " " + this.getRequiredCount());
        return this.measureVar.isEmpty() ? Collections.singletonList(anyAll) : ImmutableList.of((Object)anyAll, (Object)this.varAsTextComponent(this.measureVar));
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.CYAN;
    }

    @Override
    public void addVariables(Set<String> variables) {
        super.addVariables(variables);
        if (!this.getMeasureVar().isEmpty()) {
            variables.add(this.getMeasureVar());
        }
    }

    @Override
    public String getVariable() {
        return this.getMeasureVar();
    }

    @Override
    public void setVariable(String variable) {
        this.setMeasureVar(variable);
    }
}

