/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetConditionBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public abstract class ProgWidgetDroneCondition
extends ProgWidgetConditionBase
implements ICondition,
IVariableSetWidget {
    private boolean isAndFunction;
    private ICondition.Operator operator = ICondition.Operator.GE;
    private int requiredCount = 1;
    private String measureVar = "";

    public ProgWidgetDroneCondition(ProgWidgetType<?> type) {
        super(type);
    }

    @Override
    public boolean isAndFunction() {
        return this.isAndFunction;
    }

    @Override
    public void setAndFunction(boolean isAndFunction) {
        this.isAndFunction = isAndFunction;
    }

    @Override
    public boolean evaluate(IDroneBase drone, IProgWidget widget) {
        return this.getOperator().evaluate(this.getCount(drone, widget), this.getRequiredCount());
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.measureVar.isEmpty()) {
            curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.measure", new Object[0]).func_240702_b_(this.measureVar));
        }
    }

    protected abstract int getCount(IDroneBase var1, IProgWidget var2);

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        if (widget instanceof ProgWidgetDroneCondition) {
            return null;
        }
        return new Goal(){

            public boolean func_75250_a() {
                return false;
            }
        };
    }

    @Override
    public int getRequiredCount() {
        return this.requiredCount;
    }

    @Override
    public void setRequiredCount(int count) {
        this.requiredCount = count;
    }

    @Override
    public ICondition.Operator getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public String getMeasureVar() {
        return this.measureVar;
    }

    @Override
    public void setMeasureVar(String measureVar) {
        this.measureVar = measureVar;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("isAndFunction", this.isAndFunction);
        tag.func_74774_a("operator", (byte)this.operator.ordinal());
        tag.func_74768_a("requiredCount", this.requiredCount);
        if (!this.measureVar.isEmpty()) {
            tag.func_74778_a("measureVar", this.measureVar);
        }
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.isAndFunction = tag.func_74767_n("isAndFunction");
        this.operator = ICondition.Operator.values()[tag.func_74771_c("operator")];
        this.requiredCount = tag.func_74762_e("requiredCount");
        this.measureVar = tag.func_74779_i("measureVar");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.isAndFunction);
        buf.writeByte(this.operator.ordinal());
        buf.func_150787_b(this.requiredCount);
        buf.func_211400_a(this.measureVar, 64);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.isAndFunction = buf.readBoolean();
        this.operator = ICondition.Operator.values()[buf.readByte()];
        this.requiredCount = buf.func_150792_a();
        this.measureVar = buf.func_150789_c(64);
    }

    @Override
    public List<ITextComponent> getExtraStringInfo() {
        IFormattableTextComponent anyAll = PneumaticCraftUtils.xlate(this.isAndFunction() ? "pneumaticcraft.gui.progWidget.condition.all" : "pneumaticcraft.gui.progWidget.condition.any", new Object[0]).func_240702_b_(" " + this.getOperator().toString() + " " + this.getRequiredCount());
        return this.measureVar.isEmpty() ? Collections.singletonList(anyAll) : ImmutableList.of((Object)anyAll, (Object)this.varAsTextComponent(this.measureVar));
    }

    @Override
    public void addVariables(Set<String> variables) {
        if (!this.getMeasureVar().isEmpty()) {
            variables.add(this.getMeasureVar());
        }
    }

    @Override
    public String getVariable() {
        return this.getMeasureVar();
    }

    @Override
    public void setVariable(String variable) {
        this.setMeasureVar(variable);
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
    }
}

