/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.amadron;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AmadronOffer
extends AmadronRecipe {
    protected final AmadronTradeResource input;
    protected final AmadronTradeResource output;
    private final boolean isStaticOffer;
    private final int tradeLevel;
    final int maxStock;
    int inStock;
    private boolean isVillagerTrade = false;

    public AmadronOffer(ResourceLocation id, @Nonnull AmadronTradeResource input, @Nonnull AmadronTradeResource output, boolean isStaticOffer, int tradeLevel, int maxStock, int inStock) {
        super(id);
        this.input = input.validate();
        this.output = output.validate();
        this.isStaticOffer = isStaticOffer;
        this.tradeLevel = tradeLevel;
        this.maxStock = maxStock;
        this.inStock = inStock;
    }

    public AmadronOffer(ResourceLocation id, @Nonnull AmadronTradeResource input, @Nonnull AmadronTradeResource output, boolean isStaticOffer, int tradeLevel, int maxStock) {
        this(id, input, output, isStaticOffer, tradeLevel, maxStock, maxStock);
    }

    public AmadronOffer(ResourceLocation id, @Nonnull AmadronTradeResource input, @Nonnull AmadronTradeResource output, boolean isStaticOffer, int tradeLevel) {
        this(id, input, output, isStaticOffer, tradeLevel, -1);
    }

    @Override
    public AmadronTradeResource getInput() {
        return this.input;
    }

    @Override
    public AmadronTradeResource getOutput() {
        return this.output;
    }

    @Override
    public boolean isStaticOffer() {
        return this.isStaticOffer;
    }

    @Override
    public int getTradeLevel() {
        return this.tradeLevel;
    }

    public AmadronOffer setVillagerTrade() {
        this.isVillagerTrade = true;
        return this;
    }

    public boolean equivalentTo(AmadronPlayerOffer offer) {
        return this.input.equivalentTo(offer.getInput()) && this.output.equivalentTo(offer.getOutput());
    }

    @Override
    public String getVendor() {
        return PneumaticCraftUtils.xlate(this.isVillagerTrade ? "pneumaticcraft.gui.amadron.villager" : "pneumaticcraft.gui.amadron", new Object[0]).getString();
    }

    @Override
    public int getStock() {
        return this.inStock;
    }

    public void setStock(int inStock) {
        this.inStock = inStock;
    }

    public void addStock(int stockIncr) {
        this.inStock += stockIncr;
        if (this.inStock < 0) {
            Log.warning("in-stock for " + this + " dropped to " + this.inStock + "? shouldn't happen!", new Object[0]);
            this.inStock = 0;
        }
    }

    public AmadronOffer resetStock() {
        if (this.maxStock > 0) {
            this.inStock = this.maxStock;
        }
        return this;
    }

    public boolean passesQuery(String query) {
        String queryLow = query.toLowerCase();
        return this.getInput().getName().toLowerCase().contains(queryLow) || this.getOutput().getName().toLowerCase().contains(queryLow) || this.getVendor().toLowerCase().contains(queryLow);
    }

    public void onTrade(int tradingAmount, String buyingPlayer) {
    }

    public boolean isRemovableBy(PlayerEntity player) {
        return false;
    }

    @Override
    public void write(PacketBuffer buf) {
        this.input.writeToBuf(buf);
        this.output.writeToBuf(buf);
        buf.writeBoolean(this.isStaticOffer);
        buf.writeByte(this.tradeLevel);
        buf.func_150787_b(this.maxStock);
        buf.func_150787_b(this.inStock);
    }

    public static AmadronOffer offerFromBuf(ResourceLocation id, PacketBuffer buf) {
        AmadronOffer offer = new AmadronOffer(id, AmadronTradeResource.fromPacketBuf(buf), AmadronTradeResource.fromPacketBuf(buf), buf.readBoolean(), buf.readByte(), buf.func_150792_a(), buf.func_150792_a());
        return offer;
    }

    public JsonObject toJson(JsonObject json) {
        json.addProperty("id", this.func_199560_c().toString());
        json.add("input", (JsonElement)this.input.toJson());
        json.add("output", (JsonElement)this.output.toJson());
        json.addProperty("static", Boolean.valueOf(this.isStaticOffer));
        json.addProperty("level", (Number)this.tradeLevel);
        if (this.maxStock > 0) {
            json.addProperty("maxStock", (Number)this.maxStock);
        }
        return json;
    }

    public static AmadronOffer fromJson(ResourceLocation id, JsonObject json) throws CommandSyntaxException {
        return new AmadronOffer(id, AmadronTradeResource.fromJson(json.getAsJsonObject("input")), AmadronTradeResource.fromJson(json.getAsJsonObject("output")), JSONUtils.func_151209_a((JsonObject)json, (String)"static", (boolean)true), JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1), JSONUtils.func_151208_a((JsonObject)json, (String)"maxStock", (int)-1));
    }

    public String toString() {
        return String.format("[id = %s, in = %s, out = %s, level = %d, maxStock = %d]", this.func_199560_c().toString(), this.input.toString(), this.output.toString(), this.tradeLevel, this.maxStock);
    }

    public ITextComponent getDescription() {
        return new StringTextComponent(String.format("[%s -> %s]", this.input.toString(), this.output.toString()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AmadronOffer)) {
            return false;
        }
        AmadronOffer that = (AmadronOffer)o;
        return this.input.equals(that.input) && this.output.equals(that.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.AMADRON_OFFERS.get();
    }

    public IRecipeType<?> func_222127_g() {
        return PneumaticCraftRecipeType.AMADRON_OFFERS;
    }

    public int getMaxStock() {
        return this.maxStock;
    }

    public static class Serializer<T extends AmadronRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            try {
                int max = JSONUtils.func_151208_a((JsonObject)json, (String)"maxStock", (int)-1);
                return this.factory.create(recipeId, AmadronTradeResource.fromJson(json.getAsJsonObject("input")), AmadronTradeResource.fromJson(json.getAsJsonObject("output")), JSONUtils.func_151209_a((JsonObject)json, (String)"static", (boolean)true), JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1), max, max);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException(e.getMessage());
            }
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            return this.factory.create(recipeId, AmadronTradeResource.fromPacketBuf(buffer), AmadronTradeResource.fromPacketBuf(buffer), buffer.readBoolean(), buffer.readByte(), buffer.func_150792_a(), buffer.func_150792_a());
        }

        public void write(PacketBuffer buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends AmadronRecipe> {
            public T create(ResourceLocation var1, AmadronTradeResource var2, AmadronTradeResource var3, boolean var4, int var5, int var6, int var7);
        }
    }
}

