/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.amadron;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.entity.living.EntityAmadrone;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadron;
import me.desht.pneumaticcraft.common.item.ItemAmadronTablet;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncAmadronOffers;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;

public enum AmadronOfferManager {
    INSTANCE;

    private final List<AmadronOffer> staticOffers = new ArrayList<AmadronOffer>();
    private final Map<Integer, List<AmadronOffer>> periodicOffers = new HashMap<Integer, List<AmadronOffer>>();
    private final Map<String, List<AmadronOffer>> villagerTrades = new HashMap<String, List<AmadronOffer>>();
    private final List<VillagerProfession> validProfessions = new ArrayList<VillagerProfession>();
    private final Map<ResourceLocation, AmadronOffer> allOffers = new HashMap<ResourceLocation, AmadronOffer>();
    private final Map<ResourceLocation, AmadronOffer> activeOffers = new LinkedHashMap<ResourceLocation, AmadronOffer>();
    private boolean rebuildRequired = true;

    public static AmadronOfferManager getInstance() {
        return INSTANCE;
    }

    public AmadronOffer getOffer(ResourceLocation offerId) {
        return this.allOffers.get(offerId);
    }

    public Collection<AmadronOffer> getActiveOffers() {
        return this.activeOffers.values();
    }

    public boolean addPlayerOffer(AmadronPlayerOffer offer) {
        if (this.hasSimilarPlayerOffer(offer)) {
            return false;
        }
        if (offer.input.isEmpty() || offer.output.isEmpty()) {
            return false;
        }
        this.getPlayerOffers().put(offer.func_199560_c(), offer);
        this.addOffer(this.activeOffers, offer);
        this.addOffer(this.allOffers, offer);
        this.addOffer(this.allOffers, offer.getReversedOffer());
        NetworkHandler.sendNonLocal(new PacketSyncAmadronOffers(true));
        this.saveAll();
        return true;
    }

    public boolean removePlayerOffer(AmadronPlayerOffer offer) {
        if (this.getPlayerOffers().remove(offer.func_199560_c()) != null) {
            this.activeOffers.remove(offer.func_199560_c());
            this.allOffers.remove(offer.func_199560_c());
            this.allOffers.remove(AmadronPlayerOffer.getReversedId(offer.func_199560_c()));
            NetworkHandler.sendNonLocal(new PacketSyncAmadronOffers(true));
            this.saveAll();
            return true;
        }
        return false;
    }

    public boolean hasSimilarPlayerOffer(AmadronPlayerOffer offer) {
        for (AmadronPlayerOffer existing : this.getPlayerOffers().values()) {
            if (!existing.equivalentTo(offer)) continue;
            return true;
        }
        return false;
    }

    private Map<ResourceLocation, AmadronPlayerOffer> getPlayerOffers() {
        return AmadronPlayerOffers.INSTANCE.getPlayerOffers();
    }

    public void syncOffers(Collection<AmadronOffer> newOffers, boolean notifyPlayer) {
        this.activeOffers.clear();
        newOffers.forEach(offer -> this.addOffer(this.activeOffers, offer));
        Log.debug("Received " + this.activeOffers.size() + " active Amadron offers from server", new Object[0]);
        if (notifyPlayer && PNCConfig.Client.notifyAmadronOfferUpdates) {
            this.maybeNotifyPlayerOfUpdates(ClientUtils.getClientPlayer());
        }
    }

    private void maybeNotifyPlayerOfUpdates(PlayerEntity player) {
        CombinedInvWrapper inv = new CombinedInvWrapper(new IItemHandlerModifiable[]{new PlayerMainInvWrapper(player.field_71071_by), new PlayerOffhandInvWrapper(player.field_71071_by)});
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!(inv.getStackInSlot(i).func_77973_b() instanceof ItemAmadronTablet)) continue;
            player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.offersUpdated", new Object[0]), false);
            break;
        }
    }

    void maybeNotifyLocalPlayerOfUpdates() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && !server.func_71262_S()) {
            for (PlayerEntity player : server.func_184103_al().func_181057_v()) {
                if (!server.func_213199_b(player.func_146103_bH())) continue;
                this.maybeNotifyPlayerOfUpdates(player);
                break;
            }
        }
    }

    public void updateStock(ResourceLocation id, int stock) {
        AmadronOffer offer = this.activeOffers.get(id);
        if (offer != null) {
            offer.setStock(stock);
        }
    }

    public int countPlayerOffers(UUID playerId) {
        int count = 0;
        for (AmadronOffer offer : this.activeOffers.values()) {
            if (!(offer instanceof AmadronPlayerOffer) || !((AmadronPlayerOffer)offer).getPlayerId().equals(playerId)) continue;
            ++count;
        }
        return count;
    }

    public void tryRestockPlayerOffers() {
        boolean needSave = false;
        for (AmadronPlayerOffer offer : this.getPlayerOffers().values()) {
            EntityAmadrone drone;
            AmadronPlayerOffer reversed = offer.getReversedOffer();
            TileEntity provider = offer.getProvidingTileEntity();
            int possiblePickups = 0;
            switch (offer.getOutput().getType()) {
                case ITEM: {
                    possiblePickups = offer.getOutput().countTradesInInventory(IOHelper.getInventoryForTE(provider));
                    break;
                }
                case FLUID: {
                    possiblePickups = offer.getOutput().countTradesInTank(IOHelper.getFluidHandlerForTE(provider));
                }
            }
            if (possiblePickups > 0 && (drone = ContainerAmadron.retrieveOrderItems(null, offer.getReversedOffer(), possiblePickups, offer.getProvidingPos(), offer.getProvidingPos())) != null) {
                drone.setHandlingOffer(reversed.func_199560_c(), possiblePickups, ItemStack.field_190927_a, "Restock", EntityAmadrone.AmadronAction.RESTOCKING);
            }
            if (!offer.payout()) continue;
            needSave = true;
        }
        if (needSave) {
            this.saveAll();
        }
    }

    public void saveAll() {
        AmadronPlayerOffers.save();
    }

    private <T extends AmadronOffer> void addOffer(Map<ResourceLocation, T> map, T offer) {
        map.put(offer.func_199560_c(), offer);
    }

    public void compileActiveOffersList() {
        this.activeOffers.clear();
        this.allOffers.clear();
        this.staticOffers.forEach(offer -> {
            this.addOffer(this.activeOffers, offer);
            this.addOffer(this.allOffers, offer);
        });
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int s1 = this.allOffers.size();
        this.periodicOffers.values().forEach(offers -> offers.forEach(offer -> this.addOffer(this.allOffers, offer)));
        int nPeriodics = this.allOffers.size() - s1;
        for (int i = 0; i < Math.min(nPeriodics, PNCConfig.Common.Amadron.numPeriodicOffers); ++i) {
            AmadronOffer offer2 = this.pickRandomPeriodicTrade(rand);
            if (offer2 == null) continue;
            this.addOffer(this.activeOffers, offer2);
        }
        int s2 = this.allOffers.size();
        this.villagerTrades.values().forEach(offers -> offers.forEach(offer -> this.addOffer(this.allOffers, offer)));
        int nVillager = this.allOffers.size() - s2;
        if (!this.validProfessions.isEmpty()) {
            for (int i = 0; i < Math.min(nVillager, PNCConfig.Common.Amadron.numVillagerOffers); ++i) {
                int profIdx = ((Random)rand).nextInt(this.validProfessions.size());
                AmadronOffer offer3 = this.pickRandomVillagerTrade(this.validProfessions.get(profIdx), rand);
                if (offer3 == null) continue;
                this.addOffer(this.activeOffers, offer3);
            }
        }
        this.addPlayerOffers();
        this.activeOffers.values().forEach(AmadronOffer::resetStock);
        NetworkHandler.sendNonLocal(new PacketSyncAmadronOffers(true));
        this.maybeNotifyLocalPlayerOfUpdates();
        Log.debug(this.activeOffers.size() + " active Amadron offers to sync to clients", new Object[0]);
    }

    public void addPlayerOffers() {
        this.getPlayerOffers().forEach((id, playerOffer) -> {
            this.addOffer(this.activeOffers, playerOffer);
            this.addOffer(this.allOffers, playerOffer);
            this.addOffer(this.allOffers, playerOffer.getReversedOffer());
        });
    }

    private AmadronOffer pickRandomPeriodicTrade(Random rand) {
        int level = this.getWeightedTradeLevel(rand);
        do {
            List<AmadronOffer> offers;
            if ((offers = this.periodicOffers.get(level)) == null || offers.isEmpty()) continue;
            int idx = rand.nextInt(offers.size());
            return offers.get(idx);
        } while (--level > 0);
        Log.debug("Amadron: no periodic offers of level %d or lower", level);
        return null;
    }

    private AmadronOffer pickRandomVillagerTrade(VillagerProfession profession, Random rand) {
        int level = this.getWeightedTradeLevel(rand);
        do {
            String key;
            List<AmadronOffer> offers;
            if ((offers = this.villagerTrades.get(key = profession.toString() + "_" + level)) == null || offers.isEmpty()) continue;
            int idx = rand.nextInt(offers.size());
            return offers.get(idx);
        } while (--level > 0);
        Log.warning("Amadron: failed to find any trades for profession %s ?", profession.toString());
        return null;
    }

    private int getWeightedTradeLevel(Random rand) {
        int n = rand.nextInt(100);
        if (n < 50) {
            return 1;
        }
        if (n < 75) {
            return 2;
        }
        if (n < 90) {
            return 3;
        }
        if (n < 97) {
            return 4;
        }
        return 5;
    }

    private void setupVillagerTrades() {
        if (this.villagerTrades.isEmpty()) {
            HashSet validSet = new HashSet();
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            VillagerTrades.field_221239_a.forEach((profession, tradeMap) -> tradeMap.forEach((level, trades) -> IntStream.range(0, ((VillagerTrades.ITrade[])trades).length).forEach(i -> {
                try {
                    String key = profession.toString() + "_" + level;
                    MerchantOffer offer = trades[i].func_221182_a(null, rand);
                    ResourceLocation offerId = new ResourceLocation(profession.toString() + "_" + level + "_" + i);
                    this.villagerTrades.computeIfAbsent(key, k -> new ArrayList()).add(new AmadronOffer(offerId, AmadronTradeResource.of(offer.func_222218_a()), AmadronTradeResource.of(offer.func_222200_d()), false, (int)level, offer.func_222214_i()).setVillagerTrade());
                    validSet.add(profession);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            })));
            this.validProfessions.addAll(validSet);
        }
    }

    public void rebuildRequired() {
        this.rebuildRequired = true;
    }

    public void maybeRebuildActiveOffers(World world) {
        if (this.rebuildRequired) {
            Log.debug("Rebuilding Amadron offer list", new Object[0]);
            this.staticOffers.clear();
            this.periodicOffers.clear();
            PneumaticCraftRecipeType.AMADRON_OFFERS.getRecipes(world).values().forEach(offer -> {
                if (offer.isStaticOffer()) {
                    this.staticOffers.add((AmadronOffer)offer);
                } else {
                    this.periodicOffers.computeIfAbsent(offer.getTradeLevel(), l -> new ArrayList()).add(offer);
                }
            });
            this.setupVillagerTrades();
            this.compileActiveOffersList();
            this.rebuildRequired = false;
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class EventListener {
        @SubscribeEvent
        public static void serverLogin(PlayerEvent.PlayerLoggedInEvent evt) {
            NetworkHandler.sendNonLocal((ServerPlayerEntity)evt.getPlayer(), new PacketSyncAmadronOffers(false));
        }
    }
}

