/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public class AssemblyRecipeImpl
extends AssemblyRecipe {
    private final Ingredient input;
    private final ItemStack output;
    private final AssemblyRecipe.AssemblyProgramType program;

    public AssemblyRecipeImpl(ResourceLocation id, @Nonnull Ingredient input, @Nonnull ItemStack output, AssemblyRecipe.AssemblyProgramType program) {
        super(id);
        this.input = input;
        this.output = output;
        this.program = program;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getInputAmount() {
        return this.input.func_193365_a().length > 0 ? this.input.func_193365_a()[0].func_190916_E() : 0;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public AssemblyRecipe.AssemblyProgramType getProgramType() {
        return this.program;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack) && stack.func_190916_E() >= this.getInputAmount();
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.func_199564_a(buffer);
        buffer.func_150788_a(this.output);
        buffer.func_150787_b(this.program.ordinal());
    }

    public IRecipeSerializer<?> func_199559_b() {
        switch (this.getProgramType()) {
            case LASER: {
                return (IRecipeSerializer)ModRecipes.ASSEMBLY_LASER.get();
            }
            case DRILL: {
                return (IRecipeSerializer)ModRecipes.ASSEMBLY_DRILL.get();
            }
        }
        throw new IllegalStateException("invalid program type: " + (Object)((Object)this.getProgramType()));
    }

    public IRecipeType<?> func_222127_g() {
        switch (this.getProgramType()) {
            case DRILL: {
                return PneumaticCraftRecipeType.ASSEMBLY_DRILL;
            }
            case LASER: {
                return PneumaticCraftRecipeType.ASSEMBLY_LASER;
            }
            case DRILL_LASER: {
                return PneumaticCraftRecipeType.ASSEMBLY_DRILL_LASER;
            }
        }
        throw new IllegalStateException("invalid program type: " + (Object)((Object)this.getProgramType()));
    }

    public static Map<ResourceLocation, AssemblyRecipeImpl> calculateAssemblyChain(Collection<AssemblyRecipe> drillRecipes, Collection<AssemblyRecipe> laserRecipes) {
        HashMap<ResourceLocation, AssemblyRecipeImpl> drillLaser = new HashMap<ResourceLocation, AssemblyRecipeImpl>();
        for (AssemblyRecipe r1 : drillRecipes) {
            for (AssemblyRecipe r2 : laserRecipes) {
                if (!r2.getInput().test(r1.getOutput()) || r1.getOutput().func_190916_E() % r2.getInputAmount() != 0 || r2.getOutput().func_77976_d() < r2.getOutput().func_190916_E() * (r1.getOutput().func_190916_E() / r2.getInputAmount())) continue;
                ItemStack output = r2.getOutput().func_77946_l();
                output.func_190920_e(output.func_190916_E() * (r1.getOutput().func_190916_E() / r2.getInputAmount()));
                ResourceLocation id = PneumaticCraftUtils.RL(r1.func_199560_c().func_110623_a() + "_" + r2.func_199560_c().func_110623_a());
                drillLaser.put(id, new AssemblyRecipeImpl(id, r1.getInput(), output, AssemblyRecipe.AssemblyProgramType.DRILL_LASER));
            }
        }
        return drillLaser;
    }

    public static class Serializer<T extends AssemblyRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("input"));
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            String program = JSONUtils.func_151200_h((JsonObject)json, (String)"program").toUpperCase(Locale.ROOT);
            try {
                AssemblyRecipe.AssemblyProgramType programType = AssemblyRecipe.AssemblyProgramType.valueOf(program);
                Validate.isTrue((programType != AssemblyRecipe.AssemblyProgramType.DRILL_LASER ? 1 : 0) != 0, (String)"'drill_laser' may not be used in recipe JSON!", (Object[])new Object[0]);
                return this.factory.create(recipeId, input, result, programType);
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(e.getMessage());
            }
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack out = buffer.func_150791_c();
            AssemblyRecipe.AssemblyProgramType program = AssemblyRecipe.AssemblyProgramType.values()[buffer.func_150792_a()];
            return this.factory.create(recipeId, input, out, program);
        }

        public void write(PacketBuffer buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends AssemblyRecipe> {
            public T create(ResourceLocation var1, @Nonnull Ingredient var2, @Nonnull ItemStack var3, AssemblyRecipe.AssemblyProgramType var4);
        }
    }
}

