/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.other;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.FuelQualityRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FuelQualityRecipeImpl
extends FuelQualityRecipe {
    private final FluidIngredient fuel;
    private final int airPerBucket;
    private final float burnRate;

    public FuelQualityRecipeImpl(ResourceLocation id, FluidIngredient fuel, int airPerBucket, float burnRate) {
        super(id);
        this.fuel = fuel;
        this.airPerBucket = airPerBucket;
        this.burnRate = burnRate;
    }

    @Override
    public boolean matchesFluid(Fluid inputFluid) {
        return this.fuel.testFluid(inputFluid);
    }

    @Override
    public FluidIngredient getFuel() {
        return this.fuel;
    }

    @Override
    public int getAirPerBucket() {
        return this.airPerBucket;
    }

    @Override
    public float getBurnRate() {
        return this.burnRate;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.fuel.func_199564_a(buffer);
        buffer.writeInt(this.airPerBucket);
        buffer.writeFloat(this.burnRate);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.FUEL_QUALITY.get();
    }

    public IRecipeType<?> func_222127_g() {
        return PneumaticCraftRecipeType.FUEL_QUALITY;
    }

    public static class Serializer<T extends FuelQualityRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            Ingredient fluidInput = FluidIngredient.func_199802_a((JsonElement)json.get("fluid"));
            int airPerBucket = JSONUtils.func_151203_m((JsonObject)json, (String)"air_per_bucket");
            float burnRate = JSONUtils.func_151221_a((JsonObject)json, (String)"burn_rate", (float)1.0f);
            return this.factory.create(recipeId, (FluidIngredient)fluidInput, airPerBucket, burnRate);
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            FluidIngredient fluidIn = (FluidIngredient)Ingredient.func_199566_b((PacketBuffer)buffer);
            int airPerBucket = buffer.readInt();
            float burnRate = buffer.readFloat();
            return this.factory.create(recipeId, fluidIn, airPerBucket, burnRate);
        }

        public void write(PacketBuffer buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends FuelQualityRecipe> {
            public T create(ResourceLocation var1, FluidIngredient var2, int var3, float var4);
        }
    }
}

