/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.other;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicConstant;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class HeatPropertiesRecipeImpl
extends HeatPropertiesRecipe {
    private final Block block;
    private final BlockState inputState;
    private final BlockState transformHot;
    private final BlockState transformHotFlowing;
    private final BlockState transformCold;
    private final BlockState transformColdFlowing;
    private final Map<String, String> predicates;
    private final IHeatExchangerLogic logic;
    private final int heatCapacity;
    private final int temperature;
    private final double thermalResistance;
    private final String descriptionKey;

    public HeatPropertiesRecipeImpl(ResourceLocation id, Block block, BlockState transformHot, BlockState transformHotFlowing, BlockState transformCold, BlockState transformColdFlowing, int heatCapacity, int temperature, double thermalResistance, Map<String, String> predicates, String descriptionKey) {
        super(id);
        this.block = block;
        this.transformHot = transformHot;
        this.transformHotFlowing = transformHotFlowing;
        this.transformCold = transformCold;
        this.transformColdFlowing = transformColdFlowing;
        this.predicates = ImmutableMap.copyOf(predicates);
        this.heatCapacity = heatCapacity;
        this.temperature = temperature;
        this.thermalResistance = thermalResistance;
        this.descriptionKey = descriptionKey;
        this.logic = new HeatExchangerLogicConstant(temperature, thermalResistance);
        this.inputState = this.makeInputState();
    }

    public HeatPropertiesRecipeImpl(Block block, int temperature, double thermalResistance) {
        this(block.getRegistryName(), block, null, null, null, null, 0, temperature, thermalResistance, Collections.emptyMap(), "");
    }

    private BlockState makeInputState() {
        if (!this.predicates.isEmpty()) {
            BlockStateParser parser;
            List l = this.predicates.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList());
            try {
                String str = this.block.getRegistryName().toString() + "[" + String.join((CharSequence)",", l) + "]";
                parser = new BlockStateParser(new StringReader(str), false).func_197243_a(false);
            }
            catch (CommandSyntaxException e2) {
                return this.block.func_176223_P();
            }
            return parser.func_197249_b();
        }
        return this.block.func_176223_P();
    }

    @Override
    public int getHeatCapacity() {
        return this.heatCapacity;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public double getThermalResistance() {
        return this.thermalResistance;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockState getBlockState() {
        return this.inputState;
    }

    @Override
    public BlockState getTransformHot() {
        return this.transformHot;
    }

    @Override
    public BlockState getTransformCold() {
        return this.transformCold;
    }

    @Override
    public BlockState getTransformHotFlowing() {
        return this.transformHotFlowing;
    }

    @Override
    public BlockState getTransformColdFlowing() {
        return this.transformColdFlowing;
    }

    @Override
    public IHeatExchangerLogic getLogic() {
        return this.logic;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeRegistryId((IForgeRegistryEntry)this.block);
        PacketUtil.writeNullableBlockState(buffer, this.transformHot);
        PacketUtil.writeNullableBlockState(buffer, this.transformCold);
        PacketUtil.writeNullableBlockState(buffer, this.transformHotFlowing);
        PacketUtil.writeNullableBlockState(buffer, this.transformColdFlowing);
        buffer.func_150787_b(this.predicates.size());
        this.predicates.forEach((key, val) -> {
            buffer.func_180714_a(key);
            buffer.func_180714_a(val);
        });
        buffer.writeInt(this.temperature);
        buffer.writeInt(this.heatCapacity);
        buffer.writeDouble(this.thermalResistance);
        buffer.func_180714_a(this.descriptionKey);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.HEAT_PROPERTIES.get();
    }

    public IRecipeType<?> func_222127_g() {
        return PneumaticCraftRecipeType.HEAT_PROPERTIES;
    }

    @Override
    public boolean matchState(BlockState state) {
        if (this.predicates.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, String> entry : this.predicates.entrySet()) {
            Property iproperty = state.func_177230_c().func_176194_O().func_185920_a(entry.getKey());
            if (iproperty == null) {
                return false;
            }
            Comparable comparable = iproperty.func_185929_b(entry.getValue()).orElse(null);
            if (comparable != null && state.func_177229_b(iproperty) == comparable) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, String> getBlockStatePredicates() {
        return this.predicates;
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public static class Serializer<T extends HeatPropertiesRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            int temperature;
            Fluid fluid;
            Block block;
            BlockState transformHot = null;
            BlockState transformHotFlowing = null;
            BlockState transformCold = null;
            BlockState transformColdFlowing = null;
            HashMap<String, String> predicates = new HashMap<String, String>();
            if (json.has("block") && json.has("fluid")) {
                throw new JsonSyntaxException("heat properties entry must have only one of \"block\" or \"fluid\" fields!");
            }
            if (json.has("block")) {
                ResourceLocation blockId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"block"));
                if (blockId.toString().equals("minecraft:air")) {
                    throw new JsonSyntaxException("minecraft:air block heat properties may not be changed!");
                }
                if (!ModList.get().isLoaded(blockId.func_110624_b())) {
                    Log.info("ignoring heat properties for block %s: mod not loaded", blockId);
                    return null;
                }
                block = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
                this.validateBlock(blockId, block);
                fluid = Objects.requireNonNull(block).func_176223_P().func_204520_s().func_206886_c();
            } else if (json.has("fluid")) {
                ResourceLocation fluidId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
                if (!ModList.get().isLoaded(fluidId.func_110624_b())) {
                    Log.info("ignoring heat properties for fluid %s: mod not loaded", fluidId);
                    return null;
                }
                fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
                if (fluid == null || fluid == Fluids.field_204541_a) {
                    throw new JsonSyntaxException("unknown fluid " + fluidId);
                }
                block = fluid.func_207188_f().func_206883_i().func_177230_c();
                this.validateBlock(fluidId, block);
            } else {
                throw new JsonSyntaxException("heat properties entry must have a \"block\" or \"fluid\" field!");
            }
            int totalHeat = 0;
            if (json.has("heatCapacity")) {
                totalHeat = json.get("heatCapacity").getAsInt();
            } else if (fluid != Fluids.field_204541_a) {
                totalHeat = PNCConfig.Common.Heat.defaultFluidHeatCapacity;
            }
            if (totalHeat != 0) {
                transformHot = this.maybeGetBlockState(block, json, "transformHot");
                transformHotFlowing = this.maybeGetBlockState(block, json, "transformHotFlowing");
                transformCold = this.maybeGetBlockState(block, json, "transformCold");
                transformColdFlowing = this.maybeGetBlockState(block, json, "transformColdFlowing");
            }
            if (json.has("temperature")) {
                temperature = JSONUtils.func_151203_m((JsonObject)json, (String)"temperature");
            } else {
                if (fluid == Fluids.field_204541_a) {
                    throw new JsonSyntaxException(block.toString() + ": Non-fluid definitions must have a 'temperature' field!");
                }
                temperature = fluid.getAttributes().getTemperature();
            }
            double thermalResistance = json.has("thermalResistance") ? json.get("thermalResistance").getAsDouble() : (fluid == Fluids.field_204541_a ? PNCConfig.Common.Heat.defaultBlockThermalResistance : PNCConfig.Common.Heat.defaultFluidThermalResistance);
            if (json.has("statePredicate")) {
                json.getAsJsonObject("statePredicate").entrySet().forEach(entry -> {
                    if (block.func_176194_O().func_185920_a((String)entry.getKey()) == null) {
                        throw new JsonSyntaxException("unknown blockstate property " + (String)entry.getKey() + " for block" + block.getRegistryName());
                    }
                    predicates.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                });
            }
            String descriptionKey = JSONUtils.func_151219_a((JsonObject)json, (String)"description", (String)"");
            return this.factory.create(recipeId, block, transformHot, transformHotFlowing, transformCold, transformColdFlowing, totalHeat, temperature, thermalResistance, predicates, descriptionKey);
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            Block block = (Block)buffer.readRegistryId();
            BlockState transformHot = PacketUtil.readNullableBlockState(buffer);
            BlockState transformCold = PacketUtil.readNullableBlockState(buffer);
            BlockState transformHotFlowing = PacketUtil.readNullableBlockState(buffer);
            BlockState transformColdFlowing = PacketUtil.readNullableBlockState(buffer);
            ImmutableMap.Builder predBuilder = ImmutableMap.builder();
            int nPredicates = buffer.func_150792_a();
            for (int i = 0; i < nPredicates; ++i) {
                predBuilder.put((Object)buffer.func_218666_n(), (Object)buffer.func_218666_n());
            }
            int temperature = buffer.readInt();
            int heatCapacity = buffer.readInt();
            double thermalResistance = buffer.readDouble();
            String descriptionKey = buffer.func_218666_n();
            return this.factory.create(recipeId, block, transformHot, transformHotFlowing, transformCold, transformColdFlowing, heatCapacity, temperature, thermalResistance, (Map<String, String>)predBuilder.build(), descriptionKey);
        }

        public void write(PacketBuffer buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        private void validateBlock(ResourceLocation blockId, Block block) {
            if (block == null || block == Blocks.field_150350_a) {
                throw new JsonSyntaxException("unknown block id: " + blockId.toString());
            }
        }

        private BlockState parseBlockState(String str) {
            try {
                BlockStateParser parser = new BlockStateParser(new StringReader(str), false).func_197243_a(false);
                return parser.func_197249_b();
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException(String.format("invalid blockstate [%s] - %s", str, e.getMessage()));
            }
        }

        private BlockState maybeGetBlockState(Block b, JsonObject json, String field) {
            if (!json.has(field)) {
                return null;
            }
            JsonObject sub = json.get(field).getAsJsonObject();
            if (sub.has("block")) {
                return this.parseBlockState(JSONUtils.func_151200_h((JsonObject)sub, (String)"block"));
            }
            if (sub.has("fluid")) {
                ResourceLocation fluidId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)sub, (String)"fluid"));
                if (ForgeRegistries.FLUIDS.containsKey(fluidId)) {
                    return ((Fluid)ForgeRegistries.FLUIDS.getValue(fluidId)).func_207188_f().func_206883_i();
                }
                throw new JsonSyntaxException(String.format("unknown fluid '%s' for field '%s' in block '%s'", fluidId, field, b.getRegistryName()));
            }
            throw new JsonSyntaxException(String.format("block %s must have either a 'block' or 'fluid' section!", b.getRegistryName()));
        }

        public static interface IFactory<T extends HeatPropertiesRecipe> {
            public T create(ResourceLocation var1, Block var2, BlockState var3, BlockState var4, BlockState var5, BlockState var6, int var7, int var8, double var9, Map<String, String> var11, String var12);
        }
    }
}

