/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.common.block.BlockFluidMixer;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.thirdparty.jei.Helpers;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class JEIFluidMixerCategory
implements IRecipeCategory<FluidMixerRecipe> {
    private final String localizedName;
    private final IDrawable background;
    private final IDrawable icon = JEIPlugin.jeiHelpers.getGuiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.FLUID_MIXER.get()));
    private final ITickTimer tickTimer;
    private final IDrawableAnimated progressBar;

    public JEIFluidMixerCategory() {
        this.background = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_JEI_FLUID_MIXER, 0, 0, 166, 70);
        this.localizedName = I18n.func_135052_a((String)((BlockFluidMixer)ModBlocks.FLUID_MIXER.get()).func_149739_a(), (Object[])new Object[0]);
        this.tickTimer = JEIPlugin.jeiHelpers.getGuiHelper().createTickTimer(60, 60, false);
        IDrawableStatic d = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_FLUID_MIXER, 180, 0, 44, 30);
        this.progressBar = JEIPlugin.jeiHelpers.getGuiHelper().createAnimatedDrawable(d, 60, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return ModCategoryUid.FLUID_MIXER;
    }

    public Class<? extends FluidMixerRecipe> getRecipeClass() {
        return FluidMixerRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(FluidMixerRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, (List)ImmutableList.of(recipe.getInput1().getFluidStacks(), recipe.getInput2().getFluidStacks()));
        if (!recipe.getOutputFluid().isEmpty()) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutputFluid());
        }
        if (!recipe.getOutputItem().func_190926_b()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutputItem());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, FluidMixerRecipe recipe, IIngredients ingredients) {
        FluidStack in1 = (FluidStack)((List)ingredients.getInputs(VanillaTypes.FLUID).get(0)).get(0);
        FluidStack in2 = (FluidStack)((List)ingredients.getInputs(VanillaTypes.FLUID).get(1)).get(0);
        FluidStack outF = recipe.getOutputFluid();
        int[] amounts = new int[]{in1.getAmount(), in2.getAmount(), outF.getAmount()};
        int max = Arrays.stream(amounts).max().getAsInt();
        int inH1 = Math.min(64, in1.getAmount() * 64 / max);
        int inH2 = Math.min(64, in2.getAmount() * 64 / max);
        int outH = Math.min(64, outF.getAmount() * 64 / max);
        recipeLayout.getFluidStacks().init(0, true, 5, 3 + (64 - inH1), 16, inH1, in1.getAmount(), false, Helpers.makeTankOverlay(inH1));
        recipeLayout.getFluidStacks().set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        recipeLayout.getFluidStacks().init(1, true, 28, 3 + (64 - inH2), 16, inH2, in2.getAmount(), false, Helpers.makeTankOverlay(inH2));
        recipeLayout.getFluidStacks().set(1, (List)ingredients.getInputs(VanillaTypes.FLUID).get(1));
        if (!recipe.getOutputFluid().isEmpty()) {
            recipeLayout.getFluidStacks().init(2, false, 90, 3 + (64 - outH), 16, outH, outF.getAmount(), false, Helpers.makeTankOverlay(outH));
            recipeLayout.getFluidStacks().set(2, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
        }
        if (!recipe.getOutputItem().func_190926_b()) {
            recipeLayout.getItemStacks().init(3, false, 63, 50);
            recipeLayout.getItemStacks().set(3, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
    }

    public void draw(FluidMixerRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        float pressure = recipe.getRequiredPressure() * ((float)this.tickTimer.getValue() / (float)this.tickTimer.getMaxValue());
        PressureGaugeRenderer2D.drawPressureGauge(matrixStack, Minecraft.func_71410_x().field_71466_p, -1.0f, 7.0f, 5.0f, recipe.getRequiredPressure(), pressure, 138, 35);
        this.progressBar.draw(matrixStack, 45, 20);
    }

    public List<ITextComponent> getTooltipStrings(FluidMixerRecipe recipe, double mouseX, double mouseY) {
        ArrayList<ITextComponent> res = new ArrayList<ITextComponent>();
        if (recipe.getRequiredPressure() > 0.0f && mouseX >= 116.0 && mouseY >= 22.0 && mouseX <= 156.0 && mouseY <= 62.0) {
            res.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", Float.valueOf(recipe.getRequiredPressure())));
        }
        return res;
    }
}

